/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.pairinglist.impl;

import com.sap.sse.common.PairingListCreationException;
import com.sap.sse.pairinglist.CompetitionFormat;
import com.sap.sse.pairinglist.PairingFrameProvider;
import com.sap.sse.pairinglist.PairingList;
import com.sap.sse.pairinglist.PairingListTemplate;
import com.sap.sse.pairinglist.impl.PairingListImpl;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PairingListTemplateImpl
implements PairingListTemplate {
    private static final Logger logger = Logger.getLogger(PairingListTemplateImpl.class.getName());
    private final Random random = new Random();
    private final int[][] pairingListTemplate;
    private final double standardDev;
    private final double boatAssignmentsQuality;
    private final int flightMultiplier;
    private final int boatChangeFactor;
    private final int boatchanges;
    private final int dummies;
    private final ExecutorService executorService = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();
    private final int iterations;

    public PairingListTemplateImpl(PairingFrameProvider pairingFrameProvider) {
        this(pairingFrameProvider, 100000, 1, 0);
    }

    public PairingListTemplateImpl(PairingFrameProvider pairingFrameProvider, int flightMultiplier) {
        this(pairingFrameProvider, 100000, flightMultiplier, 0);
    }

    public PairingListTemplateImpl(PairingFrameProvider pairingFrameProvider, int flighMultiplier, int boatChangeFactor) {
        this(pairingFrameProvider, 100000, flighMultiplier, boatChangeFactor);
    }

    public PairingListTemplateImpl(PairingFrameProvider pairingFrameProvider, int iterations, int flightMultiplier, int boatChangeFactor) {
        this.iterations = iterations;
        this.flightMultiplier = flightMultiplier;
        this.boatChangeFactor = boatChangeFactor;
        if (!this.checkValues(pairingFrameProvider.getFlightsCount(), pairingFrameProvider.getGroupsCount(), pairingFrameProvider.getCompetitorsCount())) {
            throw new IllegalArgumentException("Wrong arguments for creating a pairing list template: count of flights has to be greater than 0; count of groups has to be greater than 1; count of competitors has to be greater than 1; count of competitors has to be greater than count of groups");
        }
        this.dummies = pairingFrameProvider.getCompetitorsCount() % pairingFrameProvider.getGroupsCount() != 0 ? pairingFrameProvider.getGroupsCount() - pairingFrameProvider.getCompetitorsCount() % pairingFrameProvider.getGroupsCount() : 0;
        this.pairingListTemplate = this.createPairingListTemplate(flightMultiplier, pairingFrameProvider);
        int boatChangesFromPairingList = this.getBoatChangesFromPairingList(this.pairingListTemplate, pairingFrameProvider.getFlightsCount(), pairingFrameProvider.getGroupsCount(), pairingFrameProvider.getCompetitorsCount());
        this.boatchanges = flightMultiplier <= 1 ? boatChangesFromPairingList : boatChangesFromPairingList * flightMultiplier + flightMultiplier * this.getMatches(this.pairingListTemplate[this.pairingListTemplate.length - 1], this.pairingListTemplate[0]);
        this.standardDev = this.calcStandardDev(this.incrementAssociations(this.pairingListTemplate, new int[pairingFrameProvider.getCompetitorsCount() + this.dummies][pairingFrameProvider.getCompetitorsCount() + this.dummies]));
        this.boatAssignmentsQuality = this.calcStandardDev(this.getBoatAssignments(this.pairingListTemplate, new int[pairingFrameProvider.getCompetitorsCount() + this.dummies][(pairingFrameProvider.getCompetitorsCount() + this.dummies) / pairingFrameProvider.getGroupsCount()]));
        this.resetDummies(this.pairingListTemplate, pairingFrameProvider.getCompetitorsCount() + this.dummies);
    }

    private int[][] createPairingListTemplate(int flightMultiplier, PairingFrameProvider pairingFrameProvider) {
        return this.createPairingListTemplate(pairingFrameProvider.getFlightsCount() / flightMultiplier, pairingFrameProvider.getGroupsCount(), pairingFrameProvider.getCompetitorsCount() + this.dummies);
    }

    public PairingListTemplateImpl(int[][] template, int competitorsCount, int flightMultiplier, int boatChangeFactor) {
        this.pairingListTemplate = template;
        int groupCount = competitorsCount / this.pairingListTemplate[0].length;
        if (groupCount != competitorsCount / this.pairingListTemplate[0].length) {
            ++groupCount;
        }
        this.dummies = groupCount - competitorsCount % groupCount;
        int dummyIndex = 0;
        int[][] nArray = this.pairingListTemplate;
        int n = this.pairingListTemplate.length;
        int n2 = 0;
        while (n2 < n) {
            int[] group = nArray[n2];
            int competitorNumber = 0;
            while (competitorNumber < group.length) {
                if (group[competitorNumber] < 0) {
                    group[competitorNumber] = competitorsCount + dummyIndex;
                    if (++dummyIndex >= this.dummies) {
                        dummyIndex = 0;
                    }
                }
                ++competitorNumber;
            }
            ++n2;
        }
        this.standardDev = this.calcStandardDev(this.incrementAssociations(this.pairingListTemplate, new int[competitorsCount + this.dummies][competitorsCount + this.dummies]));
        this.boatAssignmentsQuality = this.calcStandardDev(this.getBoatAssignments(template, new int[competitorsCount + this.dummies][(competitorsCount + this.dummies) / groupCount]));
        this.boatchanges = this.getBoatChangesFromPairingList(template, template.length / groupCount, groupCount, competitorsCount);
        this.resetDummies(this.pairingListTemplate, competitorsCount + this.dummies);
        this.iterations = 100000;
        this.flightMultiplier = flightMultiplier;
        this.boatChangeFactor = boatChangeFactor;
    }

    @Override
    public double getQuality() {
        return this.standardDev;
    }

    @Override
    public double getBoatAssignmentsQuality() {
        return this.boatAssignmentsQuality;
    }

    @Override
    public int getBoatChanges() {
        return this.boatchanges;
    }

    @Override
    public <Flight, Group, Competitor, CompetitorAllocation> PairingList<Flight, Group, Competitor, CompetitorAllocation> createPairingList(CompetitionFormat<Flight, Group, Competitor, CompetitorAllocation> competitionFormat) throws PairingListCreationException {
        return new PairingListImpl<Flight, Group, Competitor, CompetitorAllocation>(this, competitionFormat);
    }

    @Override
    public int[][] getPairingListTemplate() {
        return this.pairingListTemplate;
    }

    protected int[][] createPairingListTemplate(int flightCount, int groupCount, int competitorCount) {
        int[][] bestPLT = new int[flightCount * groupCount][competitorCount / groupCount];
        double bestDev = Double.POSITIVE_INFINITY;
        int[][] allSeeds = new int[this.iterations][flightCount];
        int i = 0;
        while (i < this.iterations) {
            allSeeds[i] = this.generateSeeds(flightCount, competitorCount, flightCount);
            ++i;
        }
        allSeeds = this.radixSort(allSeeds, competitorCount);
        ArrayList<int[][]> parts = this.divideSeeds(allSeeds);
        ArrayList<Future<int[][]>> futures = new ArrayList<Future<int[][]>>();
        for (int[][] nArray : parts) {
            Future<int[][]> future = this.executorService.submit(new CreateFlightsForListOfSeeds(flightCount, groupCount, competitorCount, nArray));
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                int[][] currentPLT = (int[][])future.get();
                double currentStandardDev = this.calcStandardDev(this.incrementAssociations(currentPLT, new int[competitorCount][competitorCount]));
                if (!(currentStandardDev < bestDev)) continue;
                bestPLT = currentPLT;
                bestDev = currentStandardDev;
            }
            catch (InterruptedException | ExecutionException e) {
                logger.log(Level.WARNING, "Caught exception waiting for the seed creation", e);
            }
        }
        this.improveCompetitorAllocations(bestPLT, flightCount, groupCount, competitorCount);
        this.improveAssignmentChanges(bestPLT, flightCount, groupCount, competitorCount);
        if (this.flightMultiplier > 1) {
            bestPLT = this.multiplyFlights(bestPLT, flightCount, groupCount, competitorCount);
        }
        futures.clear();
        return bestPLT;
    }

    private ArrayList<int[][]> divideSeeds(int[][] allSeeds) {
        ArrayList<int[][]> output = new ArrayList<int[][]>();
        int parts = ThreadPoolUtil.INSTANCE.getReasonableThreadPoolSize();
        int partsize = allSeeds.length / parts;
        int x = 0;
        while (x < allSeeds.length) {
            if (x + partsize < allSeeds.length) {
                output.add((int[][])Arrays.copyOfRange(allSeeds, x, x + partsize));
            } else {
                output.add((int[][])Arrays.copyOfRange(allSeeds, x, allSeeds.length));
            }
            x += partsize;
        }
        return output;
    }

    protected int[][] radixSort(int[][] allSeeds, int competitorCount) {
        int lengthOfASeed = allSeeds[0].length;
        int[][] output = new int[allSeeds.length][allSeeds[0].length];
        int[] count = new int[competitorCount];
        int[] writeIndexInOutput = new int[competitorCount];
        int i = lengthOfASeed - 1;
        while (i >= 0) {
            Arrays.fill(count, 0);
            int[][] nArray = allSeeds;
            int n = allSeeds.length;
            int n2 = 0;
            while (n2 < n) {
                int[] seed = nArray[n2];
                int n3 = seed[i];
                count[n3] = count[n3] + 1;
                ++n2;
            }
            writeIndexInOutput[0] = 0;
            int z = 1;
            while (z < count.length) {
                writeIndexInOutput[z] = writeIndexInOutput[z - 1] + count[z - 1];
                ++z;
            }
            nArray = allSeeds;
            n = allSeeds.length;
            n2 = 0;
            while (n2 < n) {
                int[] seed = nArray[n2];
                int n4 = seed[i];
                int n5 = writeIndexInOutput[n4];
                writeIndexInOutput[n4] = n5 + 1;
                output[n5] = seed;
                ++n2;
            }
            int[][] tmp = allSeeds;
            allSeeds = output;
            output = tmp;
            --i;
        }
        return allSeeds;
    }

    private boolean checkValues(int flights, int groups, int competitors) {
        return flights > 0 && groups > 0 && competitors > 1 && competitors >= groups;
    }

    private int[] generateSeeds(int flights, int competitors, int count) {
        int[] seeds = new int[count];
        Arrays.fill(seeds, 0);
        int x = 0;
        while (x < seeds.length) {
            int random;
            seeds[x] = random = this.getRandomIntegerBetweenZeroAndMax(competitors - 1);
            ++x;
        }
        return seeds;
    }

    protected int[][] createFlight(int groupCount, int competitorCount, int[][] currentAssociations, int seed) {
        int[][] flightColumn;
        int[][] nArray = flightColumn = new int[groupCount][competitorCount / groupCount];
        int n = flightColumn.length;
        int n2 = 0;
        while (n2 < n) {
            int[] group = nArray[n2];
            Arrays.fill(group, -1);
            ++n2;
        }
        boolean[] contains = new boolean[competitorCount];
        if (groupCount > 1) {
            int[] associationHigh = new int[groupCount - 1];
            flightColumn[0][0] = seed;
            contains[seed] = true;
            int[] sumsOf3rdDemension = new int[competitorCount];
            System.arraycopy(currentAssociations[seed], 0, sumsOf3rdDemension, 0, competitorCount);
            int[] maxValues = new int[competitorCount];
            System.arraycopy(currentAssociations[seed], 0, maxValues, 0, competitorCount);
            int assignmentIndex = 1;
            while (assignmentIndex < competitorCount / groupCount) {
                int associationSum = Integer.MAX_VALUE;
                associationHigh[0] = Integer.MAX_VALUE;
                int competitorIndex = 0;
                while (competitorIndex < competitorCount) {
                    if (sumsOf3rdDemension[competitorIndex] <= associationSum && !contains[competitorIndex] && maxValues[competitorIndex] <= associationHigh[0]) {
                        flightColumn[0][assignmentIndex] = competitorIndex;
                        associationSum = sumsOf3rdDemension[competitorIndex];
                        associationHigh[0] = maxValues[competitorIndex];
                    }
                    ++competitorIndex;
                }
                contains[flightColumn[0][assignmentIndex]] = true;
                int competitor = 0;
                while (competitor < competitorCount) {
                    if (flightColumn[0][assignmentIndex] != competitor) {
                        int n3 = competitor;
                        sumsOf3rdDemension[n3] = sumsOf3rdDemension[n3] + currentAssociations[flightColumn[0][assignmentIndex]][competitor];
                        if (maxValues[competitor] < flightColumn[0][assignmentIndex]) {
                            maxValues[competitor] = flightColumn[0][assignmentIndex];
                        }
                    }
                    ++competitor;
                }
                ++assignmentIndex;
            }
            int groupIndex = 1;
            while (groupIndex < groupCount - 1) {
                int competitorIndex = 0;
                while (competitorIndex < competitorCount) {
                    if (!contains[competitorIndex]) {
                        flightColumn[groupIndex][0] = competitorIndex;
                        contains[flightColumn[groupIndex][0]] = true;
                        System.arraycopy(currentAssociations[flightColumn[groupIndex][0]], 0, sumsOf3rdDemension, 0, competitorCount);
                        System.arraycopy(currentAssociations[flightColumn[groupIndex][0]], 0, maxValues, 0, competitorCount);
                        break;
                    }
                    ++competitorIndex;
                }
                int assignmentIndex2 = 1;
                while (assignmentIndex2 < competitorCount / groupCount) {
                    int associationSum = Integer.MAX_VALUE;
                    associationHigh[groupIndex] = Integer.MAX_VALUE;
                    int competitorIndex2 = 0;
                    while (competitorIndex2 < competitorCount) {
                        if (sumsOf3rdDemension[competitorIndex2] <= associationSum && !contains[competitorIndex2] && maxValues[competitorIndex2] <= associationHigh[groupIndex]) {
                            flightColumn[groupIndex][assignmentIndex2] = competitorIndex2;
                            associationSum = sumsOf3rdDemension[competitorIndex2];
                            associationHigh[groupIndex] = maxValues[competitorIndex2];
                        }
                        ++competitorIndex2;
                    }
                    contains[flightColumn[groupIndex][assignmentIndex2]] = true;
                    int competitor = 0;
                    while (competitor < competitorCount) {
                        if (flightColumn[groupIndex][assignmentIndex2] != competitor) {
                            int n4 = competitor;
                            sumsOf3rdDemension[n4] = sumsOf3rdDemension[n4] + currentAssociations[flightColumn[groupIndex][assignmentIndex2]][competitor];
                            if (maxValues[competitor] < flightColumn[groupIndex][assignmentIndex2]) {
                                maxValues[competitor] = flightColumn[groupIndex][assignmentIndex2];
                            }
                        }
                        ++competitor;
                    }
                    ++assignmentIndex2;
                }
                ++groupIndex;
            }
        }
        int assignmentIndex = 0;
        while (assignmentIndex < competitorCount / groupCount) {
            int competitorIndex = 0;
            while (competitorIndex < competitorCount) {
                if (!contains[competitorIndex]) {
                    flightColumn[groupCount - 1][assignmentIndex] = competitorIndex;
                }
                ++competitorIndex;
            }
            contains[flightColumn[groupCount - 1][assignmentIndex]] = true;
            ++assignmentIndex;
        }
        return flightColumn;
    }

    private int[][] createSinglePariringListTemplate(int flightCount, int groupCount, int competitorCount, int[][] seeds) {
        int[][] bestPLT = new int[flightCount * groupCount][competitorCount / groupCount];
        double bestDev = Double.POSITIVE_INFINITY;
        int[][] bestAssociations = new int[competitorCount][competitorCount];
        int x = 0;
        while (x < seeds[0].length) {
            int[][] flightColumn = this.createFlight(groupCount, competitorCount, bestAssociations, seeds[seeds.length - 1][x]);
            int z = 0;
            while (z < flightColumn.length) {
                System.arraycopy(flightColumn[z], 0, bestPLT[x * groupCount + z], 0, flightColumn[0].length);
                ++z;
            }
            this.incrementAssociations(flightColumn, bestAssociations);
            ++x;
        }
        bestDev = this.calcStandardDev(bestAssociations);
        int z = seeds.length - 2;
        while (z >= 0) {
            int[][] currentPLT = new int[flightCount * groupCount][competitorCount / groupCount];
            int[][] currentAssociations = new int[competitorCount][competitorCount];
            int x2 = 0;
            while (x2 < seeds[0].length) {
                int[][] flightColumn = this.createFlight(groupCount, competitorCount, currentAssociations, seeds[z][x2]);
                int y = 0;
                while (y < flightColumn.length) {
                    System.arraycopy(flightColumn[y], 0, currentPLT[x2 * groupCount + y], 0, flightColumn[0].length);
                    ++y;
                }
                this.incrementAssociations(flightColumn, currentAssociations);
                ++x2;
            }
            if (bestDev > this.calcStandardDev(currentAssociations)) {
                bestPLT = currentPLT;
                bestDev = this.calcStandardDev(currentAssociations);
                bestAssociations = currentAssociations;
            }
            --z;
        }
        return bestPLT;
    }

    protected int[][] getBoatAssignments(int[][] pairingList, int[][] associations) {
        int[][] nArray = pairingList;
        int n = pairingList.length;
        int n2 = 0;
        while (n2 < n) {
            int[] group = nArray[n2];
            int i = 0;
            while (i < pairingList[0].length) {
                int[] nArray2 = associations[group[i]];
                int n3 = i++;
                nArray2[n3] = nArray2[n3] + 1;
            }
            ++n2;
        }
        return associations;
    }

    private void improveCompetitorAllocations(int[][] pairingList, int numberOflights, int numberOfGroups, int numberOfCompetitors) {
        int numberOfBoats = numberOfCompetitors / numberOfGroups;
        int[][] boatAllocationCount = new int[numberOfCompetitors][numberOfBoats];
        int raceIndex = 0;
        while (raceIndex < pairingList.length) {
            int currentFlightIndex = raceIndex / numberOfGroups;
            int previousFlight = currentFlightIndex - 1;
            int[] targetAssignmentsForOriginalCompetitorSlots = new int[numberOfBoats];
            int i = 0;
            while (i < numberOfBoats) {
                targetAssignmentsForOriginalCompetitorSlots[i] = -1;
                ++i;
            }
            int competitorSlotIndex = 0;
            while (competitorSlotIndex < numberOfBoats) {
                int competitorIndex = pairingList[raceIndex][competitorSlotIndex];
                int[] allocationCountPerBoatForCurrentCompetitor = boatAllocationCount[competitorIndex];
                int minimumAllocationCount = Integer.MAX_VALUE;
                int minimiumAvailableAllocationCount = Integer.MAX_VALUE;
                int boatIndexOfAvailableBoatWithMinimumAllocationCount = -1;
                int boatIndex = 0;
                while (boatIndex < numberOfBoats) {
                    if (allocationCountPerBoatForCurrentCompetitor[boatIndex] < minimumAllocationCount) {
                        minimumAllocationCount = allocationCountPerBoatForCurrentCompetitor[boatIndex];
                    }
                    if (targetAssignmentsForOriginalCompetitorSlots[boatIndex] == -1 && allocationCountPerBoatForCurrentCompetitor[boatIndex] < minimiumAvailableAllocationCount) {
                        boatIndexOfAvailableBoatWithMinimumAllocationCount = boatIndex;
                        minimiumAvailableAllocationCount = allocationCountPerBoatForCurrentCompetitor[boatIndex];
                    }
                    ++boatIndex;
                }
                assert (boatIndexOfAvailableBoatWithMinimumAllocationCount != -1);
                if (currentFlightIndex > 0) {
                    int boatIndexOfCurrentCompetitorInPreviousFlight = this.getBoatIndexInFlight(pairingList, numberOfGroups, competitorIndex, previousFlight);
                    if (targetAssignmentsForOriginalCompetitorSlots[boatIndexOfCurrentCompetitorInPreviousFlight] == -1) {
                        int allocationCountDeviationForBoatOfPreviousFlight = allocationCountPerBoatForCurrentCompetitor[boatIndexOfCurrentCompetitorInPreviousFlight] - minimumAllocationCount;
                        if (allocationCountDeviationForBoatOfPreviousFlight < this.boatChangeFactor) {
                            targetAssignmentsForOriginalCompetitorSlots[boatIndexOfCurrentCompetitorInPreviousFlight] = competitorIndex;
                        } else {
                            targetAssignmentsForOriginalCompetitorSlots[boatIndexOfAvailableBoatWithMinimumAllocationCount] = competitorIndex;
                        }
                    } else {
                        targetAssignmentsForOriginalCompetitorSlots[boatIndexOfAvailableBoatWithMinimumAllocationCount] = competitorIndex;
                    }
                } else {
                    targetAssignmentsForOriginalCompetitorSlots[boatIndexOfAvailableBoatWithMinimumAllocationCount] = competitorIndex;
                }
                ++competitorSlotIndex;
            }
            competitorSlotIndex = 0;
            while (competitorSlotIndex < numberOfBoats) {
                pairingList[raceIndex][competitorSlotIndex] = targetAssignmentsForOriginalCompetitorSlots[competitorSlotIndex];
                int[] nArray = boatAllocationCount[targetAssignmentsForOriginalCompetitorSlots[competitorSlotIndex]];
                int n = competitorSlotIndex++;
                nArray[n] = nArray[n] + 1;
            }
            ++raceIndex;
        }
    }

    private int getBoatIndexInFlight(int[][] pairingList, int numberOfGroups, int competitorIndex, int previousFlight) {
        int raceIndex = previousFlight * numberOfGroups;
        while (raceIndex < previousFlight * numberOfGroups + numberOfGroups) {
            int boatIndex = 0;
            while (boatIndex < pairingList[raceIndex].length) {
                if (competitorIndex == pairingList[raceIndex][boatIndex]) {
                    return boatIndex;
                }
                ++boatIndex;
            }
            ++raceIndex;
        }
        throw new IllegalStateException("Previous flight " + previousFlight + " unexpectedly did not contain competitor " + competitorIndex);
    }

    private void improveAssignmentChanges(int[][] pairingList, int flights, int groups, int competitors) {
        int numberOfGroupsPerFlight = pairingList.length / flights;
        int flightIndex = 1;
        while (flightIndex < flights) {
            int bestMatchesIndexInCurrentFlight = -1;
            int bestMatchesIndexInPreviousFlight = -1;
            int bestMatch = 0;
            int groupIndexInPreviousFlight = 1;
            while (groupIndexInPreviousFlight < numberOfGroupsPerFlight) {
                int[] groupPrev = pairingList[(flightIndex - 1) * numberOfGroupsPerFlight + groupIndexInPreviousFlight];
                int groupIndexInCurrentFlight = 0;
                while (groupIndexInCurrentFlight < numberOfGroupsPerFlight) {
                    int[] candidateForFirstGroupInCurrentFlight = pairingList[flightIndex * numberOfGroupsPerFlight + groupIndexInCurrentFlight];
                    int currentMatch = this.getMatches(groupPrev, candidateForFirstGroupInCurrentFlight);
                    if (currentMatch > bestMatch) {
                        bestMatch = currentMatch;
                        bestMatchesIndexInCurrentFlight = groupIndexInCurrentFlight;
                        bestMatchesIndexInPreviousFlight = groupIndexInPreviousFlight;
                    }
                    ++groupIndexInCurrentFlight;
                }
                ++groupIndexInPreviousFlight;
            }
            if (bestMatchesIndexInCurrentFlight > 0) {
                int[] temp = pairingList[flightIndex * numberOfGroupsPerFlight];
                pairingList[flightIndex * numberOfGroupsPerFlight] = pairingList[flightIndex * numberOfGroupsPerFlight + bestMatchesIndexInCurrentFlight];
                pairingList[flightIndex * numberOfGroupsPerFlight + bestMatchesIndexInCurrentFlight] = temp;
            }
            if (bestMatchesIndexInPreviousFlight > 0 && bestMatchesIndexInPreviousFlight < numberOfGroupsPerFlight - 1) {
                int[] temp = pairingList[(flightIndex - 1) * numberOfGroupsPerFlight + numberOfGroupsPerFlight - 1];
                pairingList[(flightIndex - 1) * numberOfGroupsPerFlight + numberOfGroupsPerFlight - 1] = pairingList[(flightIndex - 1) * numberOfGroupsPerFlight + bestMatchesIndexInPreviousFlight];
                pairingList[(flightIndex - 1) * numberOfGroupsPerFlight + bestMatchesIndexInPreviousFlight] = temp;
            }
            ++flightIndex;
        }
    }

    private int getMatches(int[] arr1, int[] arr2) {
        int matches = 0;
        int i = 0;
        while (i < arr1.length) {
            if (arr1[i] == arr2[i]) {
                ++matches;
            }
            ++i;
        }
        return matches;
    }

    private int[][] multiplyFlights(int[][] bestPLT, int flightCount, int groupCount, int competitorCount) {
        int[][] result = new int[flightCount * this.flightMultiplier * groupCount][competitorCount / groupCount];
        int flightIndex = 0;
        while (flightIndex < flightCount) {
            int x = 0;
            while (x < this.flightMultiplier) {
                int groupIndex = 0;
                while (groupIndex < groupCount) {
                    result[flightIndex * groupCount * this.flightMultiplier + groupIndex + x * groupCount] = bestPLT[flightIndex * groupCount + groupIndex];
                    ++groupIndex;
                }
                ++x;
            }
            ++flightIndex;
        }
        return result;
    }

    private int getRandomIntegerBetweenZeroAndMax(int max) {
        return this.random.nextInt(max + 1);
    }

    public int[][] incrementAssociations(int[][] pairingList, int[][] associations) {
        int[][] nArray = pairingList;
        int n = pairingList.length;
        int n2 = 0;
        while (n2 < n) {
            int[] group = nArray[n2];
            int i = 0;
            while (i < pairingList[0].length) {
                int j = 0;
                while (j < pairingList[0].length) {
                    if (group[i] == group[j]) {
                        associations[group[i]][group[j]] = -1;
                    } else {
                        int[] nArray2 = associations[group[i]];
                        int n3 = group[j];
                        nArray2[n3] = nArray2[n3] + 1;
                    }
                    ++j;
                }
                ++i;
            }
            ++n2;
        }
        return associations;
    }

    public int[][] decrementAssociations(int[][] pairingList, int[][] associations) {
        int[][] nArray = pairingList;
        int n = pairingList.length;
        int n2 = 0;
        while (n2 < n) {
            int[] group = nArray[n2];
            int i = 0;
            while (i < group.length) {
                int j = 0;
                while (j < group.length) {
                    if (group[i] == group[j]) {
                        associations[group[i]][group[j]] = -1;
                    } else {
                        int[] nArray2 = associations[group[i]];
                        int n3 = group[j];
                        nArray2[n3] = nArray2[n3] - 1;
                    }
                    ++j;
                }
                ++i;
            }
            ++n2;
        }
        return associations;
    }

    protected double calcStandardDev(int[][] associations) {
        double standardDev = 0.0;
        int k = associations[0][0];
        int n = 0;
        int exp = 0;
        int exp2 = 0;
        int i = 0;
        while (i < associations.length) {
            int j = 0;
            while (j < associations[0].length) {
                if (associations[i][j] >= 0) {
                    ++n;
                    int base = associations[i][j] - k;
                    exp += base;
                    exp2 += base * base;
                }
                ++j;
            }
            ++i;
        }
        standardDev = Math.sqrt(((double)exp2 - (double)(exp * exp) / (double)n) / (double)n);
        return standardDev;
    }

    private int[][] resetDummies(int[][] bestPLT, int competitorCount) {
        if (this.dummies > 0) {
            int[] dummyCompetitors = new int[this.dummies];
            int i = 0;
            while (i < this.dummies) {
                dummyCompetitors[i] = competitorCount - 1 - i;
                ++i;
            }
            int x = 0;
            while (x < bestPLT.length) {
                int y = 0;
                while (y < bestPLT[0].length) {
                    int[] nArray = dummyCompetitors;
                    int n = dummyCompetitors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i2 = nArray[n2];
                        if (bestPLT[x][y] == i2) {
                            bestPLT[x][y] = -1;
                        }
                        ++n2;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return bestPLT;
    }

    protected int getBoatChangesFromPairingList(int[][] pairinglist, int flightcount, int groupcount, int competitorcount) {
        int sumOfBoatchanges = 0;
        int groupindex = groupcount - 1;
        while (groupindex < flightcount * groupcount) {
            if (groupindex + 1 < pairinglist.length) {
                sumOfBoatchanges += competitorcount / groupcount - this.getMatches(pairinglist[groupindex], pairinglist[groupindex + 1]);
            }
            groupindex += groupcount;
        }
        return sumOfBoatchanges;
    }

    class CreateFlightsForListOfSeeds
    implements Callable<int[][]> {
        int flights;
        int groups;
        int competitors;
        int[][] seeds;

        CreateFlightsForListOfSeeds(int flights, int groups, int competitors, int[][] seeds) {
            this.flights = flights;
            this.groups = groups;
            this.competitors = competitors;
            this.seeds = seeds;
        }

        @Override
        public int[][] call() {
            return PairingListTemplateImpl.this.createSinglePariringListTemplate(this.flights, this.groups, this.competitors, this.seeds);
        }
    }
}

