/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.osgi;

import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CachedOsgiTypeBasedServiceFinder<ServiceT>
implements ServiceTrackerCustomizer<ServiceT, ServiceT>,
TypeBasedServiceFinder<ServiceT> {
    private static final Logger logger = Logger.getLogger(CachedOsgiTypeBasedServiceFinder.class.getName());
    private final ConcurrentHashMap<String, ServiceT> services = new ConcurrentHashMap();
    private final BundleContext context;
    private final Class<ServiceT> serviceType;
    private ServiceT fallback;
    private final Map<String, Set<TypeBasedServiceFinder.Callback<ServiceT>>> callbacks;
    private static final String NULL_STRING = UUID.randomUUID().toString();

    public CachedOsgiTypeBasedServiceFinder(Class<ServiceT> serviceType, BundleContext context) {
        this.serviceType = serviceType;
        this.context = context;
        this.callbacks = new HashMap<String, Set<TypeBasedServiceFinder.Callback<ServiceT>>>();
    }

    public ServiceT findService(String type) {
        ServiceT service = this.services.get(this.getNullSafeType(type));
        if (service == null) {
            if (this.fallback != null) {
                return this.fallback;
            }
            throw new NoCorrespondingServiceRegisteredException("Could not find service", type, this.serviceType.getSimpleName());
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyServiceWhenAvailable(String type, TypeBasedServiceFinder.Callback<ServiceT> callback) {
        ServiceT service;
        ConcurrentHashMap<String, ServiceT> concurrentHashMap = this.services;
        synchronized (concurrentHashMap) {
            service = this.services.get(this.getNullSafeType(type));
            if (service == null) {
                Util.addToValueSet(this.callbacks, (Object)this.getNullSafeType(type), callback);
            }
        }
        if (service != null) {
            callback.withService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceT addingService(ServiceReference<ServiceT> reference) {
        Set<TypeBasedServiceFinder.Callback<ServiceT>> callbacksToNotify;
        String type = (String)reference.getProperty("type");
        Object service = this.context.getService(reference);
        ConcurrentHashMap<String, ServiceT> concurrentHashMap = this.services;
        synchronized (concurrentHashMap) {
            this.services.put(this.getNullSafeType(type), service);
            callbacksToNotify = this.callbacks.remove(type);
        }
        if (callbacksToNotify != null) {
            callbacksToNotify.forEach(c -> {
                try {
                    c.withService(service);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception trying to inform " + c + " about the availability of service " + service, e);
                }
            });
        }
        return (ServiceT)service;
    }

    public void modifiedService(ServiceReference<ServiceT> reference, ServiceT service) {
        this.addingService(reference);
    }

    public void removedService(ServiceReference<ServiceT> reference, ServiceT service) {
        String type = (String)reference.getProperty("type");
        this.services.remove(this.getNullSafeType(type));
    }

    private String getNullSafeType(String type) {
        return type == null ? NULL_STRING : type;
    }

    public void setFallbackService(ServiceT fallback) {
        this.fallback = fallback;
    }

    public Set<ServiceT> findAllServices() {
        return new HashSet<ServiceT>(this.services.values());
    }
}

