/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.impl;

import com.sap.sse.rest.CORSFilterConfiguration;
import com.sap.sse.rest.impl.CORSFilterConfigurationImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static Activator INSTANCE;
    private final CORSFilterConfiguration corsFilterConfiguration;

    public Activator() {
        INSTANCE = this;
        this.corsFilterConfiguration = new CORSFilterConfigurationImpl();
    }

    public static Activator getInstance() {
        return INSTANCE;
    }

    public CORSFilterConfiguration getCORSFilterConfiguration() {
        return this.corsFilterConfiguration;
    }

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        context.registerService(CORSFilterConfiguration.class, (Object)this.corsFilterConfiguration, null);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.info("Executing shutdown hook, gracefully shutting down OSGi framework");
            try {
                Bundle systemBundle = context.getBundle(0L);
                if (systemBundle == null) {
                    logger.warning("Couldn't find system bundle (anymore?). Perhaps already shut down.");
                } else {
                    logger.info("Found system bundle " + systemBundle.getSymbolicName());
                    systemBundle.stop();
                }
            }
            catch (BundleException e) {
                logger.log(Level.WARNING, "Exception while trying to gracefully stop the OSGi framework", e);
            }
        }, "com.sap.sse shutdown hook"));
    }

    public void stop(BundleContext context) throws Exception {
    }
}

