/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.userstore.mongodb.impl;

import com.mongodb.BasicDBList;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.sap.sse.common.impl.TimedLockImpl;
import com.sap.sse.security.interfaces.Social;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.Account;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.SocialUserAccount;
import com.sap.sse.security.shared.UsernamePasswordAccount;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.subscription.SubscriptionDataHandler;
import com.sap.sse.security.userstore.mongodb.MongoObjectFactory;
import com.sap.sse.security.userstore.mongodb.impl.Activator;
import com.sap.sse.security.userstore.mongodb.impl.CollectionNames;
import com.sap.sse.security.userstore.mongodb.impl.FieldNames;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private static final Logger logger = Logger.getLogger(MongoObjectFactoryImpl.class.getName());
    private final MongoDatabase db;
    final MongoCollection<Document> settingCollection;

    public MongoObjectFactoryImpl(MongoDatabase db) {
        this.db = db;
        this.settingCollection = db.getCollection(CollectionNames.PREFERENCES.name());
        for (Document index : this.settingCollection.listIndexes()) {
            Document keyDocument;
            Object key = index.get((Object)"key");
            if (!(key instanceof Document) || (keyDocument = (Document)key).size() != 1 || !keyDocument.containsKey((Object)FieldNames.Preferences.USERNAME.name()) || index.getBoolean((Object)"unique", false)) continue;
            this.settingCollection.dropIndex(index.getString((Object)"name"));
            break;
        }
        try {
            this.settingCollection.createIndex((Bson)new Document(FieldNames.Preferences.USERNAME.name(), (Object)1), new IndexOptions().name("uniquebyusername").unique(true).background(false));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "There are duplicate keys in the " + CollectionNames.PREFERENCES.name() + " collection. Unique index cannot be created. Consider cleaning up.", e);
        }
    }

    @Override
    public MongoDatabase getDatabase() {
        return this.db;
    }

    @Override
    public void storeAccessControlList(AccessControlListAnnotation acl) {
        MongoCollection aclCollection = this.db.getCollection(CollectionNames.ACCESS_CONTROL_LISTS.name());
        aclCollection.createIndex((Bson)new Document(FieldNames.AccessControlList.OBJECT_ID.name(), (Object)1));
        Document dbACL = new Document();
        Document query = new Document(FieldNames.AccessControlList.OBJECT_ID.name(), (Object)acl.getIdOfAnnotatedObject().toString());
        dbACL.put(FieldNames.AccessControlList.OBJECT_ID.name(), (Object)acl.getIdOfAnnotatedObject().toString());
        dbACL.put(FieldNames.AccessControlList.OBJECT_DISPLAY_NAME.name(), (Object)acl.getDisplayNameOfAnnotatedObject());
        BasicDBList permissionMap = new BasicDBList();
        for (Map.Entry entry : ((AccessControlList)acl.getAnnotation()).getActionsByUserGroup().entrySet()) {
            Document permissionMapEntry = new Document();
            permissionMapEntry.put(FieldNames.AccessControlList.PERMISSION_MAP_USER_GROUP_ID.name(), entry.getKey() == null ? null : ((UserGroup)entry.getKey()).getId());
            BasicDBList dbActions = new BasicDBList();
            dbActions.addAll((Collection)entry.getValue());
            permissionMapEntry.put(FieldNames.AccessControlList.PERMISSION_MAP_ACTIONS.name(), (Object)dbActions);
            permissionMap.add((Object)permissionMapEntry);
        }
        dbACL.put(FieldNames.AccessControlList.PERMISSION_MAP.name(), (Object)permissionMap);
        aclCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbACL, new ReplaceOptions().upsert(true));
    }

    @Override
    public void deleteAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObject, AccessControlList acl) {
        MongoCollection aclCollection = this.db.getCollection(CollectionNames.ACCESS_CONTROL_LISTS.name());
        Document dbACL = new Document();
        dbACL.put(FieldNames.AccessControlList.OBJECT_ID.name(), (Object)idOfAccessControlledObject.toString());
        aclCollection.deleteOne((Bson)dbACL);
    }

    @Override
    public void deleteAllAccessControlLists() {
        MongoCollection aclCollection = this.db.getCollection(CollectionNames.ACCESS_CONTROL_LISTS.name());
        aclCollection.deleteMany((Bson)new Document());
    }

    @Override
    public void storeOwnership(OwnershipAnnotation owner) {
        MongoCollection ownershipCollection = this.db.getCollection(CollectionNames.OWNERSHIPS.name());
        ownershipCollection.createIndex((Bson)new Document(FieldNames.Ownership.OBJECT_ID.name(), (Object)1));
        Document dbOwnership = new Document();
        Document query = new Document(FieldNames.Ownership.OBJECT_ID.name(), (Object)owner.getIdOfAnnotatedObject().toString());
        dbOwnership.put(FieldNames.Ownership.OBJECT_ID.name(), (Object)owner.getIdOfAnnotatedObject().toString());
        dbOwnership.put(FieldNames.Ownership.OWNER_USERNAME.name(), ((Ownership)owner.getAnnotation()).getUserOwner() == null ? null : ((User)((Ownership)owner.getAnnotation()).getUserOwner()).getName());
        dbOwnership.put(FieldNames.Ownership.TENANT_OWNER_ID.name(), ((Ownership)owner.getAnnotation()).getTenantOwner() == null ? null : ((UserGroup)((Ownership)owner.getAnnotation()).getTenantOwner()).getId());
        dbOwnership.put(FieldNames.Ownership.OBJECT_DISPLAY_NAME.name(), (Object)owner.getDisplayNameOfAnnotatedObject());
        ownershipCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbOwnership, new ReplaceOptions().upsert(true));
    }

    @Override
    public void deleteOwnership(QualifiedObjectIdentifier ownedObjectId, Ownership ownership) {
        MongoCollection ownershipCollection = this.db.getCollection(CollectionNames.OWNERSHIPS.name());
        Document dbOwnership = new Document();
        dbOwnership.put(FieldNames.Ownership.OBJECT_ID.name(), (Object)ownedObjectId.toString());
        ownershipCollection.deleteOne((Bson)dbOwnership);
    }

    @Override
    public void deleteAllOwnerships() {
        MongoCollection ownershipCollection = this.db.getCollection(CollectionNames.OWNERSHIPS.name());
        ownershipCollection.deleteMany((Bson)new Document());
    }

    @Override
    public void storeRoleDefinition(RoleDefinition role) {
        MongoCollection roleCollection = this.db.getCollection(CollectionNames.ROLES.name());
        roleCollection.createIndex((Bson)new Document(FieldNames.Role.ID.name(), (Object)1));
        Document dbRole = new Document();
        Document query = new Document(FieldNames.Role.ID.name(), (Object)role.getId().toString());
        dbRole.put(FieldNames.Role.ID.name(), (Object)role.getId().toString());
        dbRole.put(FieldNames.Role.NAME.name(), (Object)role.getName());
        HashSet<String> stringPermissions = new HashSet<String>();
        for (WildcardPermission permission : role.getPermissions()) {
            stringPermissions.add(permission.toString());
        }
        dbRole.put(FieldNames.Role.PERMISSIONS.name(), stringPermissions);
        roleCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbRole, new ReplaceOptions().upsert(true));
    }

    @Override
    public void deleteRoleDefinition(RoleDefinition role) {
        MongoCollection roleCollection = this.db.getCollection(CollectionNames.ROLES.name());
        Document dbRole = new Document();
        dbRole.put(FieldNames.Role.ID.name(), (Object)role.getId().toString());
        roleCollection.deleteOne((Bson)dbRole);
    }

    private Document storeRole(Role role) {
        Document result = new Document();
        result.put(FieldNames.Role.ID.name(), (Object)role.getRoleDefinition().getId());
        result.put(FieldNames.Role.NAME.name(), (Object)role.getRoleDefinition().getName());
        result.put(FieldNames.Role.QUALIFYING_TENANT_ID.name(), role.getQualifiedForTenant() == null ? null : ((UserGroup)role.getQualifiedForTenant()).getId());
        result.put(FieldNames.Role.QUALIFYING_TENANT_NAME.name(), role.getQualifiedForTenant() == null ? null : ((UserGroup)role.getQualifiedForTenant()).getName());
        result.put(FieldNames.Role.QUALIFYING_USERNAME.name(), role.getQualifiedForUser() == null ? null : ((User)role.getQualifiedForUser()).getName());
        result.put(FieldNames.Role.TRANSITIVE.name(), (Object)role.isTransitive());
        return result;
    }

    @Override
    public void storeUserGroup(UserGroup group) {
        MongoCollection userGroupCollection = this.db.getCollection(CollectionNames.USER_GROUPS.name());
        userGroupCollection.createIndex((Bson)new Document(FieldNames.UserGroup.ID.name(), (Object)1));
        Document dbUserGroup = new Document();
        Document query = new Document(FieldNames.UserGroup.ID.name(), (Object)group.getId());
        dbUserGroup.put(FieldNames.UserGroup.ID.name(), (Object)group.getId());
        dbUserGroup.put(FieldNames.UserGroup.NAME.name(), (Object)group.getName());
        BasicDBList dbUsernames = new BasicDBList();
        for (User user : group.getUsers()) {
            if (user == null) continue;
            dbUsernames.add((Object)user.getName());
        }
        dbUserGroup.put(FieldNames.UserGroup.USERNAMES.name(), (Object)dbUsernames);
        BasicDBList dbRoleDefinitionMap = new BasicDBList();
        for (Map.Entry entry : group.getRoleDefinitionMap().entrySet()) {
            Document dbRoleDef = new Document();
            dbRoleDef.put(FieldNames.UserGroup.ROLE_DEFINITION_MAP_ROLE_ID.name(), (Object)((RoleDefinition)entry.getKey()).getId());
            dbRoleDef.put(FieldNames.UserGroup.ROLE_DEFINITION_MAP_FOR_ALL.name(), entry.getValue());
            dbRoleDefinitionMap.add((Object)dbRoleDef);
        }
        dbUserGroup.put(FieldNames.UserGroup.ROLE_DEFINITION_MAP.name(), (Object)dbRoleDefinitionMap);
        userGroupCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbUserGroup, new ReplaceOptions().upsert(true));
    }

    @Override
    public void deleteUserGroup(UserGroup userGroup) {
        MongoCollection userGroupCollection = this.db.getCollection(CollectionNames.USER_GROUPS.name());
        Document dbUserGroup = new Document();
        dbUserGroup.put(FieldNames.UserGroup.ID.name(), (Object)userGroup.getId());
        userGroupCollection.deleteOne((Bson)dbUserGroup);
    }

    @Override
    public void storeUser(User user) {
        MongoCollection usersCollection = this.db.getCollection(CollectionNames.USERS.name());
        usersCollection.createIndex((Bson)new Document(FieldNames.User.NAME.name(), (Object)1));
        Document dbUser = new Document();
        Document query = new Document(FieldNames.User.NAME.name(), (Object)user.getName());
        dbUser.put(FieldNames.User.NAME.name(), (Object)user.getName());
        dbUser.put(FieldNames.User.EMAIL.name(), (Object)user.getEmail());
        dbUser.put(FieldNames.User.FULLNAME.name(), (Object)user.getFullName());
        dbUser.put(FieldNames.User.COMPANY.name(), (Object)user.getCompany());
        dbUser.put(FieldNames.User.LOCALE.name(), user.getLocale() != null ? user.getLocale().toLanguageTag() : null);
        dbUser.put(FieldNames.User.EMAIL_VALIDATED.name(), (Object)user.isEmailValidated());
        dbUser.put(FieldNames.User.PASSWORD_RESET_SECRET.name(), (Object)user.getPasswordResetSecret());
        dbUser.put(FieldNames.User.VALIDATION_SECRET.name(), (Object)user.getValidationSecret());
        dbUser.put(FieldNames.User.ACCOUNTS.name(), (Object)this.createAccountMapObject(user.getAllAccounts()));
        if (user.getTimedLock() instanceof TimedLockImpl) {
            TimedLockImpl timedLock = (TimedLockImpl)user.getTimedLock();
            dbUser.put(FieldNames.User.LOCKED_UNTIL_MILLIS.name(), (Object)timedLock.getLockedUntil().asMillis());
            dbUser.put(FieldNames.User.NEXT_LOCKING_DURATION_MILLIS.name(), (Object)timedLock.getNextLockingDelay().asMillis());
        } else {
            logger.warning("Expected user locking/banning to be of type " + TimedLockImpl.class.getSimpleName() + " but was of type " + user.getTimedLock().getClass().getSimpleName() + "; not storing to DB");
        }
        BasicDBList dbRoles = new BasicDBList();
        for (Role role : user.getRoles()) {
            dbRoles.add((Object)this.storeRole(role));
        }
        dbUser.put(FieldNames.User.ROLE_IDS.name(), (Object)dbRoles);
        BasicDBList dbPermissions = new BasicDBList();
        for (WildcardPermission permission : user.getPermissions()) {
            dbPermissions.add((Object)permission.toString());
        }
        dbUser.put(FieldNames.User.PERMISSIONS.name(), (Object)dbPermissions);
        BasicDBList defaultTennants = new BasicDBList();
        for (Map.Entry entries : user.getDefaultTenantMap().entrySet()) {
            Document tenant = new Document();
            tenant.put(FieldNames.User.DEFAULT_TENANT_SERVER.name(), entries.getKey());
            tenant.put(FieldNames.User.DEFAULT_TENANT_GROUP.name(), (Object)((UserGroup)entries.getValue()).getId());
            defaultTennants.add(tenant);
        }
        dbUser.put(FieldNames.User.DEFAULT_TENANT_IDS.name(), (Object)defaultTennants);
        dbUser.put(FieldNames.User.SUBSCRIPTIONS.name(), (Object)this.createSubscriptions(user.getSubscriptions()));
        usersCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbUser, new ReplaceOptions().upsert(true));
    }

    @Override
    public void deleteUser(User user) {
        MongoCollection usersCollection = this.db.getCollection(CollectionNames.USERS.name());
        Document dbUser = new Document();
        dbUser.put(FieldNames.User.NAME.name(), (Object)user.getName());
        usersCollection.deleteOne((Bson)dbUser);
    }

    private Document createAccountMapObject(Map<Account.AccountType, Account> accounts) {
        Document dbAccounts = new Document();
        for (Map.Entry<Account.AccountType, Account> e : accounts.entrySet()) {
            dbAccounts.put(e.getKey().name(), (Object)this.createAccountObject(e.getValue()));
        }
        return dbAccounts;
    }

    private Document createAccountObject(Account a) {
        Document dbAccount = new Document();
        if (a instanceof UsernamePasswordAccount) {
            UsernamePasswordAccount upa = (UsernamePasswordAccount)a;
            dbAccount.put(FieldNames.UsernamePassword.NAME.name(), (Object)upa.getName());
            dbAccount.put(FieldNames.UsernamePassword.SALTED_PW.name(), (Object)upa.getSaltedPassword());
            dbAccount.put(FieldNames.UsernamePassword.SALT.name(), (Object)upa.getSalt());
        }
        if (a instanceof SocialUserAccount) {
            SocialUserAccount account = (SocialUserAccount)a;
            Social[] socialArray = Social.values();
            int n = socialArray.length;
            int n2 = 0;
            while (n2 < n) {
                Social s = socialArray[n2];
                dbAccount.put(s.name(), (Object)account.getProperty(s.name()));
                ++n2;
            }
        }
        return dbAccount;
    }

    @Override
    public void storeSettings(Map<String, Object> settings) {
        MongoCollection settingCollection = this.db.getCollection(CollectionNames.SETTINGS.name());
        settingCollection.createIndex((Bson)new Document(FieldNames.Settings.NAME.name(), (Object)1));
        Document dbSettings = new Document();
        Document query = new Document(FieldNames.Settings.NAME.name(), (Object)FieldNames.Settings.VALUES.name());
        dbSettings.put(FieldNames.Settings.NAME.name(), (Object)FieldNames.Settings.VALUES.name());
        dbSettings.put(FieldNames.Settings.MAP.name(), (Object)this.createSettingsMapObject(settings));
        settingCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbSettings, new ReplaceOptions().upsert(true));
    }

    @Override
    public void deleteAllSettings() {
        MongoCollection settingsCollection = this.db.getCollection(CollectionNames.SETTINGS.name());
        settingsCollection.deleteMany((Bson)new Document());
    }

    @Override
    public void storePreferences(String username, Map<String, String> userMap) {
        BasicDBList dbSettings = new BasicDBList();
        for (Map.Entry<String, String> e : userMap.entrySet()) {
            Document entry = new Document();
            entry.put(FieldNames.Preferences.KEY.name(), (Object)e.getKey());
            entry.put(FieldNames.Preferences.VALUE.name(), (Object)e.getValue());
            dbSettings.add((Object)entry);
        }
        Document query = new Document(FieldNames.Preferences.USERNAME.name(), (Object)username);
        Document update = new Document(FieldNames.Preferences.KEYS_AND_VALUES.name(), (Object)dbSettings);
        update.put(FieldNames.Preferences.USERNAME.name(), (Object)username);
        this.settingCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)update, new ReplaceOptions().upsert(true));
    }

    @Override
    public void deleteAllPreferences() {
        MongoCollection preferencesCollection = this.db.getCollection(CollectionNames.PREFERENCES.name());
        preferencesCollection.deleteMany((Bson)new Document());
    }

    @Override
    public void storeSettingTypes(Map<String, Class<?>> settingTypes) {
        MongoCollection settingCollection = this.db.getCollection(CollectionNames.SETTINGS.name());
        settingCollection.createIndex((Bson)new Document(FieldNames.Settings.NAME.name(), (Object)1));
        Document dbSettingTypes = new Document();
        Document query = new Document(FieldNames.Settings.NAME.name(), (Object)FieldNames.Settings.TYPES.name());
        dbSettingTypes.put(FieldNames.Settings.NAME.name(), (Object)FieldNames.Settings.TYPES.name());
        dbSettingTypes.put(FieldNames.Settings.MAP.name(), (Object)this.createSettingTypesMapObject(settingTypes));
        settingCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)dbSettingTypes, new ReplaceOptions().upsert(true));
    }

    private Document createSettingsMapObject(Map<String, Object> settings) {
        Document dbSettings = new Document();
        for (Map.Entry<String, Object> e : settings.entrySet()) {
            dbSettings.put(e.getKey(), e.getValue());
        }
        return dbSettings;
    }

    private Document createSettingTypesMapObject(Map<String, Class<?>> settingTypes) {
        Document dbSettingTypes = new Document();
        for (Map.Entry<String, Class<?>> e : settingTypes.entrySet()) {
            dbSettingTypes.put(e.getKey(), (Object)e.getValue().getName());
        }
        return dbSettingTypes;
    }

    private BasicDBList createSubscriptions(Iterable<Subscription> subscriptions) {
        BasicDBList result;
        if (subscriptions != null) {
            result = new BasicDBList();
            for (Subscription subscription : subscriptions) {
                Document doc = new Document();
                SubscriptionDataHandler subscriptionDataHandler = Activator.getSubscriptionDataHandler(subscription.getProviderName());
                doc.putAll(subscriptionDataHandler.toMap(subscription));
                result.add((Object)doc);
            }
        } else {
            result = null;
        }
        return result;
    }
}

