/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.common;

import com.sap.sse.common.Util;
import java.util.Arrays;
import java.util.Collections;

public interface SharedLandscapeConstants {
    public static final String DEFAULT_DOMAIN_NAME = "sapsailing.com";
    public static final Iterable<String> TRUSTED_DOMAINS = Collections.unmodifiableCollection(Arrays.asList("sapsailing.com", "sailing.omegatiming.com", "localhost", "127.0.0.1"));
    public static final String IGTIMI_DEFAULT_RIOT_REPLICA_SET_NAME = "wind";
    public static final String IGTIMI_DEFAULT_RIOT_HOSTNAME = "wind.sapsailing.com";
    public static final String IGTIMI_BASE_URL_DEFAULT = "https://wind.sapsailing.com/";
    public static final int IGTIMI_DEFAULT_RIOT_PORT = 6000;
    public static final String DEFAULT_SECURITY_SERVICE_REPLICA_SET_NAME = "security-service";
    public static final String RABBIT_IN_DEFAULT_REGION_HOSTNAME = "rabbit.internal.sapsailing.com";
    public static final String DEFAULT_REGION = "eu-west-1";
    public static final String REGION_WITH_RABBITMQ_DNS_HOSTNAME = "eu-west-1";
    public static final String REGION_WITH_DEFAULT_LOAD_BALANCER = "eu-west-1";
    public static final String RABBITMQ_TAG_NAME = "RabbitMQEndpoint";
    public static final String IMAGE_TYPE_TAG_VALUE_SAILING = "sailing-analytics-server";
    public static final String SAILING_ANALYTICS_APPLICATION_HOST_TAG = "sailing-analytics-server";
    public static final String ARCHIVE_SERVER_APPLICATION_REPLICA_SET_NAME = "ARCHIVE";
    public static final String MULTI_PROCESS_INSTANCE_TAG_VALUE = "___multi___";
    public static final String MULTI_PROCESS_INSTANCE_DEFAULT_NAME = "SL Multi-Server";
    public static final String DEFAULT_DEDICATED_INSTANCE_TYPE_NAME = "C5_2_XLARGE";
    public static final String DEFAULT_SHARED_INSTANCE_TYPE_NAME = "I3_2_XLARGE";
    public static final int DEFAULT_NUMBER_OF_PROCESSES_IN_MEMORY = 4;
    public static final String DEFAULT_REVERSE_PROXY_INSTANCE_TYPE = "T3_MEDIUM";
    public static final String DEFAULT_DISPOSABLE_REVERSE_PROXY_INSTANCE_NAME = "DisposableReverseProxy";
    public static final String ARCHIVE_FAILOVER_ADDRESS = "archive-failover.sapsailing.com";

    public static boolean isTrustedDomain(String domain) {
        while (Util.hasLength((String)domain)) {
            if (Util.contains(TRUSTED_DOMAINS, (Object)domain)) {
                return true;
            }
            int indexOfSubdomainSeparator = domain.indexOf(46);
            String string = domain = indexOfSubdomainSeparator >= 0 ? domain.substring(indexOfSubdomainSeparator + 1) : "";
        }
        return false;
    }
}

