/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.threadmanager;

import com.sap.sse.ServerStartupConstants;
import com.sap.sse.rest.StreamingOutputUtil;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/threads")
public class ThreadManager
extends StreamingOutputUtil {
    @Context
    ServletContext servletContext;

    @Path(value="")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getThreads() {
        this.checkThreadsPermission();
        JSONArray threadsJson = new JSONArray();
        Thread[] threads = new Thread[10000];
        Thread.enumerate(threads);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            if (t != null) {
                JSONObject threadJson = new JSONObject();
                threadJson.put((Object)"name", (Object)t.getName());
                threadJson.put((Object)"id", (Object)t.getId());
                threadJson.put((Object)"daemon", (Object)t.isDaemon());
                threadJson.put((Object)"alive", (Object)t.isAlive());
                threadJson.put((Object)"threadgroup", (Object)t.getThreadGroup().getName());
                threadsJson.add((Object)threadJson);
            }
            ++n2;
        }
        return Response.ok((Object)this.streamingOutput(threadsJson), (String)"application/json").build();
    }

    private void checkThreadsPermission() {
        SecurityUtils.getSubject().checkPermissions(new String[]{SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredSecurityTypes.ServerActions.THREADS, new TypeRelativeObjectIdentifier(new String[]{ServerStartupConstants.SERVER_NAME}))});
    }

    @Path(value="{name}/suspend")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response suspend(@PathParam(value="name") String name) {
        Response response;
        this.checkThreadsPermission();
        JSONObject result = new JSONObject();
        Thread[] threads = new Thread[10000];
        boolean found = false;
        Thread.enumerate(threads);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            if (t != null && t.getName().equals(name)) {
                t.suspend();
                result.put((Object)"status", (Object)"OK");
                found = true;
            }
            ++n2;
        }
        if (!found) {
            result.put((Object)"status", (Object)"Not found");
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.streamingOutput(result)).build();
        } else {
            response = Response.ok((Object)this.streamingOutput(result), (String)"application/json").build();
        }
        return response;
    }

    @Path(value="{name}/stop")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response stop(@PathParam(value="name") String name) {
        Response response;
        this.checkThreadsPermission();
        JSONObject result = new JSONObject();
        Thread[] threads = new Thread[10000];
        boolean found = false;
        Thread.enumerate(threads);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            if (t != null && t.getName().equals(name)) {
                t.stop();
                result.put((Object)"status", (Object)"OK");
                found = true;
            }
            ++n2;
        }
        if (!found) {
            result.put((Object)"status", (Object)"Not found");
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.streamingOutput(result)).build();
        } else {
            response = Response.ok((Object)this.streamingOutput(result), (String)"application/json").build();
        }
        return response;
    }

    @Path(value="{name}/interrupt")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response interrupt(@PathParam(value="name") String name) {
        Response response;
        this.checkThreadsPermission();
        JSONObject result = new JSONObject();
        Thread[] threads = new Thread[10000];
        boolean found = false;
        Thread.enumerate(threads);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            if (t != null && t.getName().equals(name)) {
                t.interrupt();
                result.put((Object)"status", (Object)"OK");
                found = true;
            }
            ++n2;
        }
        if (!found) {
            result.put((Object)"status", (Object)"Not found");
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.streamingOutput(result)).build();
        } else {
            response = Response.ok((Object)this.streamingOutput(result), (String)"application/json").build();
        }
        return response;
    }

    @Path(value="{name}/resume")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response resume(@PathParam(value="name") String name) {
        Response response;
        this.checkThreadsPermission();
        JSONObject result = new JSONObject();
        Thread[] threads = new Thread[10000];
        boolean found = false;
        Thread.enumerate(threads);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            if (t != null && t.getName().equals(name)) {
                t.resume();
                result.put((Object)"status", (Object)"OK");
                found = true;
            }
            ++n2;
        }
        if (!found) {
            result.put((Object)"status", (Object)"Not found");
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.streamingOutput(result)).build();
        } else {
            response = Response.ok((Object)this.streamingOutput(result), (String)"application/json").build();
        }
        return response;
    }
}

