/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.server.gateway.interfaces.MasterDataImportResult;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MasterDataImportResultJsonSerializer
implements JsonSerializer<MasterDataImportResult> {
    public static final String LEADERBOARDGROUPS_IMPORTED = "leaderboardgroupsImported";
    public static final String IMPORTED_FROM = "importedFrom";
    public static final String OVERRIDE_FORM_PARAM = "override";
    public static final String EXPORT_WIND_FORM_PARAM = "exportWind";
    public static final String COMPRESS_FORM_PARAM = "compress";
    public static final String LEADERBOARDGROUP_UUID_FORM_PARAM = "leaderboardgroupUUID[]";
    public static final String EXPORT_DEVICE_CONFIGS_FORM_PARAM = "exportDeviceConfigs";
    public static final String EXPORT_TRACKED_RACES_AND_START_TRACKING_FORM_PARAM = "exportTrackedRacesAndStartTracking";

    public JSONObject serialize(MasterDataImportResult object) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)LEADERBOARDGROUPS_IMPORTED, (Object)this.getLeaderboardGroupNamesFromIdList(object.getLeaderboardGroupsImported()));
        jsonResponse.put((Object)IMPORTED_FROM, (Object)object.getRemoteServerUrl());
        jsonResponse.put((Object)OVERRIDE_FORM_PARAM, (Object)object.isOverride());
        jsonResponse.put((Object)EXPORT_WIND_FORM_PARAM, (Object)object.isImportWind());
        jsonResponse.put((Object)EXPORT_DEVICE_CONFIGS_FORM_PARAM, (Object)object.isImportDeviceConfigurations());
        jsonResponse.put((Object)EXPORT_TRACKED_RACES_AND_START_TRACKING_FORM_PARAM, (Object)object.isImportTrackedRacesAndStartTracking());
        return jsonResponse;
    }

    private JSONArray getLeaderboardGroupNamesFromIdList(Iterable<MasterDataImportResult.LeaderboardGroupWithEventIds> leaderboardGroupsWithEventIds) {
        JSONArray result = new JSONArray();
        for (MasterDataImportResult.LeaderboardGroupWithEventIds leaderboardGroupWithEventIds : leaderboardGroupsWithEventIds) {
            JSONObject lgJson = new JSONObject();
            result.add((Object)lgJson);
            lgJson.put((Object)"id", (Object)leaderboardGroupWithEventIds.getId().toString());
            lgJson.put((Object)"name", (Object)leaderboardGroupWithEventIds.getName());
            JSONArray eventIds = new JSONArray();
            for (UUID eventId : leaderboardGroupWithEventIds.getEventIds()) {
                eventIds.add((Object)eventId.toString());
            }
            lgJson.put((Object)"events", (Object)eventIds);
        }
        return result;
    }
}

