/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.maneuverdetection.ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.server.gateway.serialization.impl.ManeuverCurveBoundariesJsonSerializer;
import org.json.simple.JSONObject;

public class ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataJsonSerializer
extends ManeuverCurveBoundariesJsonSerializer {
    public static final String AVERAGE_SPEED_BEFORE_IN_KNOTS = "averageSpeedBeforeInKnots";
    public static final String AVERAGE_SPEED_AFTER_IN_KNOTS = "averageSpeedAfterInKnots";
    public static final String AVERAGE_COURSE_BEFORE_IN_DEGREES = "averageCourseBeforeInDegrees";
    public static final String AVERAGE_COURSE_AFTER_IN_DEGREES = "averageCourseAfterInDegrees";
    public static final String DURATION_FROM_PREVIOUS_MANEUVER_IN_SECONDS = "durationFromPreviousManeuverInSeconds";
    public static final String DURATION_TO_NEXT_MANEUVER_IN_SECONDS = "durationToNextManeuverInSeconds";
    public static final String GPS_FIXES_COUNT_FROM_PREVIOUS_MANEUVER_IN_SECONDS = "gpsFixesCountFromPreviousManeuver";
    public static final String GPS_FIXES_COUNT_TO_NEXT_MANEUVER_IN_SECONDS = "gpsFixesCountToNextManeuver";
    public static final String GPS_FIXES_COUNT = "gpsFixesCount";
    public static final String LONGEST_INTERVAL_BETWEEN_TWO_FIXES = "longestIntervalBetweenTwoFixesInSeconds";
    public static final String INTERVAL_BETWEEN_LAST_FIX_OF_CURVE_AND_NEXT_FIX = "intervalBetweenLastFixOfCurveAndNextFixInSeconds";
    public static final String INTERVAL_BETWEEN_FIRST_FIX_OF_CURVE_AND_PREVIOUS_FIX = "intervalBetweenFirstFixOfCurveAndPreviousFixInSeconds";

    @Override
    public JSONObject serialize(ManeuverCurveBoundaries curveBoundaries) {
        JSONObject result = super.serialize(curveBoundaries);
        if (curveBoundaries instanceof ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData) {
            ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData curve = (ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData)curveBoundaries;
            result.put((Object)AVERAGE_SPEED_BEFORE_IN_KNOTS, curve.getAverageSpeedWithBearingBefore() == null ? null : Double.valueOf(curve.getAverageSpeedWithBearingBefore().getKnots()));
            result.put((Object)AVERAGE_COURSE_BEFORE_IN_DEGREES, curve.getAverageSpeedWithBearingBefore() == null ? null : Double.valueOf(curve.getAverageSpeedWithBearingBefore().getBearing().getDegrees()));
            result.put((Object)DURATION_FROM_PREVIOUS_MANEUVER_IN_SECONDS, curve.getDurationFromPreviousManeuverEndToManeuverStart() == null ? null : Double.valueOf(curve.getDurationFromPreviousManeuverEndToManeuverStart().asSeconds()));
            result.put((Object)AVERAGE_SPEED_AFTER_IN_KNOTS, curve.getAverageSpeedWithBearingAfter() == null ? null : Double.valueOf(curve.getAverageSpeedWithBearingAfter().getKnots()));
            result.put((Object)AVERAGE_COURSE_AFTER_IN_DEGREES, curve.getAverageSpeedWithBearingAfter() == null ? null : Double.valueOf(curve.getAverageSpeedWithBearingAfter().getBearing().getDegrees()));
            result.put((Object)DURATION_TO_NEXT_MANEUVER_IN_SECONDS, curve.getDurationFromManeuverEndToNextManeuverStart() == null ? null : Double.valueOf(curve.getDurationFromManeuverEndToNextManeuverStart().asSeconds()));
            result.put((Object)GPS_FIXES_COUNT, (Object)curve.getGpsFixesCount());
            result.put((Object)GPS_FIXES_COUNT_FROM_PREVIOUS_MANEUVER_IN_SECONDS, (Object)curve.getGpsFixesCountFromPreviousManeuverEndToManeuverStart());
            result.put((Object)GPS_FIXES_COUNT_TO_NEXT_MANEUVER_IN_SECONDS, (Object)curve.getGpsFixesCountFromManeuverEndToNextManeuverStart());
            result.put((Object)LONGEST_INTERVAL_BETWEEN_TWO_FIXES, (Object)curve.getLongestIntervalBetweenTwoFixes().asSeconds());
            result.put((Object)INTERVAL_BETWEEN_LAST_FIX_OF_CURVE_AND_NEXT_FIX, (Object)curve.getIntervalBetweenLastFixOfCurveAndNextFix().asSeconds());
            result.put((Object)INTERVAL_BETWEEN_FIRST_FIX_OF_CURVE_AND_PREVIOUS_FIX, (Object)curve.getIntervalBetweenFirstFixOfCurveAndPreviousFix().asSeconds());
        }
        return result;
    }
}

