/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class ManeuverCurveBoundariesJsonSerializer
implements JsonSerializer<ManeuverCurveBoundaries> {
    public static final String TIME_POINT_BEFORE = "unixTimeBefore";
    public static final String SPEED_BEFORE_IN_KNOTS = "speedBeforeInKnots";
    public static final String COG_BEFORE_IN_TRUE_DEGREES = "cogBeforeInTrueDegrees";
    public static final String TIME_POINT_AFTER = "unixTimeAfter";
    public static final String SPEED_AFTER_IN_KNOTS = "speedAfterInKnots";
    public static final String COG_AFTER_IN_TRUE_DEGREES = "cogAfterInTrueDegrees";
    public static final String DIRECTION_CHANGE_IN_DEGREES = "directionChangeInDegrees";
    public static final String DURATION_IN_MILLIS = "durationInMillis";
    public static final String LOWEST_SPEED_IN_KNOTS = "lowestSpeedInKnots";
    public static final String HIGHEST_SPEED_IN_KNOTS = "highestSpeedInKnots";

    public JSONObject serialize(ManeuverCurveBoundaries curveBoundaries) {
        JSONObject result = new JSONObject();
        result.put((Object)TIME_POINT_BEFORE, (Object)curveBoundaries.getTimePointBefore().asMillis());
        result.put((Object)SPEED_BEFORE_IN_KNOTS, curveBoundaries.getSpeedWithBearingBefore() == null ? null : Double.valueOf(curveBoundaries.getSpeedWithBearingBefore().getKnots()));
        result.put((Object)COG_BEFORE_IN_TRUE_DEGREES, curveBoundaries.getSpeedWithBearingBefore() == null ? null : Double.valueOf(curveBoundaries.getSpeedWithBearingBefore().getBearing().getDegrees()));
        result.put((Object)TIME_POINT_AFTER, (Object)curveBoundaries.getTimePointAfter().asMillis());
        result.put((Object)SPEED_AFTER_IN_KNOTS, curveBoundaries.getSpeedWithBearingAfter() == null ? null : Double.valueOf(curveBoundaries.getSpeedWithBearingAfter().getKnots()));
        result.put((Object)COG_AFTER_IN_TRUE_DEGREES, curveBoundaries.getSpeedWithBearingAfter() == null ? null : Double.valueOf(curveBoundaries.getSpeedWithBearingAfter().getBearing().getDegrees()));
        result.put((Object)DIRECTION_CHANGE_IN_DEGREES, (Object)curveBoundaries.getDirectionChangeInDegrees());
        result.put((Object)DURATION_IN_MILLIS, (Object)curveBoundaries.getTimePointBefore().until(curveBoundaries.getTimePointAfter()).asMillis());
        result.put((Object)LOWEST_SPEED_IN_KNOTS, (Object)curveBoundaries.getLowestSpeed().getKnots());
        result.put((Object)HIGHEST_SPEED_IN_KNOTS, (Object)curveBoundaries.getHighestSpeed().getKnots());
        return result;
    }
}

