/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.gateway.serialization.impl.RaceStateSerializer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Calendar;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class EventRaceStatesSerializer
implements JsonSerializer<Util.Pair<Event, Iterable<Leaderboard>>> {
    public static final String FIELD_EVENT_NAME = "name";
    public static final String FIELD_EVENT_ID = "id";
    public static final String FIELD_RACE_STATES = "raceStates";
    private final String filterByCourseArea;
    private final String filterByLeaderboardName;
    private final Calendar filterDay;
    private final RaceLogResolver raceLogResolver;
    private final Duration clientTimeZoneOffset;

    public EventRaceStatesSerializer(String filterByCourseArea, String filterByLeaderboard, String filterByDayOffset, Duration clientTimeZoneOffset, RaceLogResolver raceLogResolver) {
        this.filterByCourseArea = filterByCourseArea;
        this.filterByLeaderboardName = filterByLeaderboard;
        this.raceLogResolver = raceLogResolver;
        this.clientTimeZoneOffset = clientTimeZoneOffset;
        Integer dayOffset = null;
        if (filterByDayOffset != null) {
            Calendar myFilterDay;
            try {
                dayOffset = Integer.parseInt(filterByDayOffset);
                myFilterDay = Calendar.getInstance();
                myFilterDay.setTime(new Date());
                myFilterDay.add(6, dayOffset);
            }
            catch (NumberFormatException e) {
                myFilterDay = null;
            }
            this.filterDay = myFilterDay;
        } else {
            this.filterDay = null;
        }
    }

    public JSONObject serialize(Util.Pair<Event, Iterable<Leaderboard>> eventAndLeaderboards) {
        Event event = (Event)eventAndLeaderboards.getA();
        Iterable leaderboards = (Iterable)eventAndLeaderboards.getB();
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_EVENT_NAME, (Object)event.getName());
        result.put((Object)FIELD_EVENT_ID, (Object)event.getId().toString());
        JSONArray raceStatesLogEntriesJson = new JSONArray();
        result.put((Object)FIELD_RACE_STATES, (Object)raceStatesLogEntriesJson);
        for (CourseArea courseArea : event.getVenue().getCourseAreas()) {
            if (this.filterByCourseArea != null && !courseArea.getName().equals(this.filterByCourseArea)) continue;
            for (Leaderboard leaderboard : leaderboards) {
                RaceStateSerializer raceStateSerializer = new RaceStateSerializer(this.raceLogResolver);
                if (this.filterByLeaderboardName != null && !leaderboard.getName().equals(this.filterByLeaderboardName) || !Util.contains((Iterable)leaderboard.getCourseAreas(), (Object)courseArea)) continue;
                String leaderboardName = leaderboard.getName();
                String leaderboardDisplayName = leaderboard.getDisplayName();
                for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                    for (Fleet fleet : raceColumn.getFleets()) {
                        Util.Pair raceColumnAndFleet = new Util.Pair((Object)raceColumn, (Object)fleet);
                        if (this.filterDay != null && !raceStateSerializer.isRaceStateOfSameDay((Util.Pair<RaceColumn, Fleet>)raceColumnAndFleet, this.filterDay, this.clientTimeZoneOffset)) continue;
                        JSONObject raceStateJson = raceStateSerializer.serialize((Util.Pair<RaceColumn, Fleet>)raceColumnAndFleet);
                        raceStateJson.put((Object)"courseAreaName", (Object)courseArea.getName());
                        raceStateJson.put((Object)"leaderboardName", (Object)leaderboardName);
                        raceStateJson.put((Object)"leaderboardDisplayName", (Object)leaderboardDisplayName);
                        raceStatesLogEntriesJson.add((Object)raceStateJson);
                    }
                }
            }
        }
        return result;
    }
}

