/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.maneuverdetection.CompleteManeuverCurveWithEstimationData;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.server.gateway.serialization.impl.ManeuverCurveBoundariesJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.ManeuverWindJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.PositionJsonSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class CompleteManeuverCurveWithEstimationDataJsonSerializer
implements JsonSerializer<CompleteManeuverCurveWithEstimationData> {
    public static final String POSITION = "position";
    public static final String MARK_PASSING = "markPassing";
    public static final String MAIN_CURVE = "mainCurve";
    public static final String CURVE_WITH_UNSTABLE_COURSE_AND_SPEED = "curveWithUnstableCourseAndSpeed";
    public static final String WIND = "wind";
    public static final String TACKING_COUNT = "tackingCount";
    public static final String JIBING_COUNT = "jibingCount";
    public static final String MANEUVER_STARTS_BY_RUNNING_AWAY_FROM_WIND = "maneuverStartsByRunningAwayFromWind";
    public static final String RELATIVE_BEARING_TO_NEXT_MARK_BEFORE_MANEUVER = "relativeBearingToNextMarkBeforeManeuver";
    public static final String RELATIVE_BEARING_TO_NEXT_MARK_AFTER_MANEUVER = "relativeBearingToNextMarkAfterManeuver";
    public static final String CLOSEST_DISTANCE_TO_MARK = "closestDistanceToMarkInMeters";
    public static final String TARGET_TACK_ANGLE = "targetTackAngleInDegrees";
    public static final String TARGET_JIBE_ANGLE = "targetJibeAngleInDegrees";
    private final ManeuverCurveBoundariesJsonSerializer mainCurveSerializer;
    private final ManeuverCurveBoundariesJsonSerializer curveWithUnstableCourseAndSpeedSerializer;
    private final ManeuverWindJsonSerializer windSerializer;
    private final PositionJsonSerializer positionSerializer;

    public CompleteManeuverCurveWithEstimationDataJsonSerializer(ManeuverCurveBoundariesJsonSerializer mainCurveSerializer, ManeuverCurveBoundariesJsonSerializer curveWithUnstableCourseAndSpeedSerializer, ManeuverWindJsonSerializer windSerializer, PositionJsonSerializer positionSerializer) {
        this.mainCurveSerializer = mainCurveSerializer;
        this.curveWithUnstableCourseAndSpeedSerializer = curveWithUnstableCourseAndSpeedSerializer;
        this.windSerializer = windSerializer;
        this.positionSerializer = positionSerializer;
    }

    public JSONObject serialize(CompleteManeuverCurveWithEstimationData maneuverWithEstimationData) {
        JSONObject result = new JSONObject();
        result.put((Object)POSITION, (Object)this.positionSerializer.serialize(maneuverWithEstimationData.getPosition()));
        result.put((Object)MARK_PASSING, (Object)maneuverWithEstimationData.isMarkPassing());
        result.put((Object)MAIN_CURVE, (Object)this.mainCurveSerializer.serialize((ManeuverCurveBoundaries)maneuverWithEstimationData.getMainCurve()));
        result.put((Object)CURVE_WITH_UNSTABLE_COURSE_AND_SPEED, (Object)this.curveWithUnstableCourseAndSpeedSerializer.serialize((ManeuverCurveBoundaries)maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed()));
        result.put((Object)WIND, maneuverWithEstimationData.getWind() == null ? null : this.windSerializer.serialize(maneuverWithEstimationData.getWind()));
        result.put((Object)TACKING_COUNT, (Object)maneuverWithEstimationData.getTackingCount());
        result.put((Object)JIBING_COUNT, (Object)maneuverWithEstimationData.getJibingCount());
        result.put((Object)MANEUVER_STARTS_BY_RUNNING_AWAY_FROM_WIND, (Object)maneuverWithEstimationData.isManeuverStartsByRunningAwayFromWind());
        result.put((Object)RELATIVE_BEARING_TO_NEXT_MARK_BEFORE_MANEUVER, maneuverWithEstimationData.getRelativeBearingToNextMarkBeforeManeuver() == null ? null : Double.valueOf(maneuverWithEstimationData.getRelativeBearingToNextMarkBeforeManeuver().getDegrees()));
        result.put((Object)RELATIVE_BEARING_TO_NEXT_MARK_AFTER_MANEUVER, maneuverWithEstimationData.getRelativeBearingToNextMarkAfterManeuver() == null ? null : Double.valueOf(maneuverWithEstimationData.getRelativeBearingToNextMarkAfterManeuver().getDegrees()));
        result.put((Object)CLOSEST_DISTANCE_TO_MARK, maneuverWithEstimationData.getDistanceToClosestMark() == null ? null : Double.valueOf(maneuverWithEstimationData.getDistanceToClosestMark().getMeters()));
        result.put((Object)TARGET_TACK_ANGLE, (Object)maneuverWithEstimationData.getTargetTackAngleInDegrees());
        result.put((Object)TARGET_JIBE_ANGLE, (Object)maneuverWithEstimationData.getTargetJibeAngleInDegrees());
        return result;
    }
}

