/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.coursetemplate.ControlPointTemplate;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkRolePair;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.impl.CourseTemplateImpl;
import com.sap.sailing.domain.coursetemplate.impl.WaypointTemplateImpl;
import com.sap.sailing.server.gateway.deserialization.impl.RepeatablePartJsonDeserializer;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Function;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CourseTemplateJsonDeserializer
implements JsonDeserializer<CourseTemplate> {
    private final Function<UUID, MarkTemplate> markTemplateResolver;
    private final Function<UUID, MarkRole> markRoleResolver;
    private final JsonDeserializer<RepeatablePart> repeatablePartJsonDeserializer;

    public CourseTemplateJsonDeserializer(Function<UUID, MarkTemplate> markTemplateResolver, Function<UUID, MarkRole> markRoleResolver) {
        this.markTemplateResolver = markTemplateResolver;
        this.markRoleResolver = markRoleResolver;
        this.repeatablePartJsonDeserializer = new RepeatablePartJsonDeserializer();
    }

    public CourseTemplate deserialize(JSONObject json) throws JsonDeserializationException {
        URL optionalImageURL;
        String courseTemplateName = (String)json.get((Object)"name");
        String courseTemplateShortName = (String)json.get((Object)"shortName");
        String optionalImageUrlString = (String)json.get((Object)"optionalImageURL");
        try {
            optionalImageURL = optionalImageUrlString == null ? null : new URL(optionalImageUrlString);
        }
        catch (MalformedURLException e) {
            throw new JsonDeserializationException("Error while trying to deserialize the given image URL: " + optionalImageUrlString);
        }
        ArrayList tags = new ArrayList();
        JSONArray tagsJSON = (JSONArray)json.get((Object)"tags");
        if (tagsJSON != null) {
            tagsJSON.forEach(t -> {
                boolean bl = tags.add(t.toString());
            });
        }
        HashMap<UUID, Iterator> allMarkRolesById = new HashMap<UUID, Iterator>();
        HashMap<Iterator, MarkTemplate> defaultMarkTemplatesForMarkRoles = new HashMap<Iterator, MarkTemplate>();
        JSONArray allMarkRolesJSON = (JSONArray)json.get((Object)"allMarkRoles");
        for (Object markRoleWithMarkTemplateRefObject : allMarkRolesJSON) {
            JSONObject markRoleWithMarkTemplateRef = (JSONObject)markRoleWithMarkTemplateRefObject;
            UUID markRoleUUID = UUID.fromString((String)markRoleWithMarkTemplateRef.get((Object)"id"));
            Iterator resolvedMarkRole = this.markRoleResolver.apply(markRoleUUID);
            if (resolvedMarkRole == null) {
                throw new JsonDeserializationException("Mark role with ID " + markRoleUUID + " can't be resolved");
            }
            allMarkRolesById.put(markRoleUUID, resolvedMarkRole);
            String markTemplateIdAsString = (String)markRoleWithMarkTemplateRef.get((Object)"associatedMarkTemplateId");
            MarkTemplate resolvedMarkTemplate = this.markTemplateResolver.apply(UUID.fromString(markTemplateIdAsString));
            defaultMarkTemplatesForMarkRoles.put(resolvedMarkRole, resolvedMarkTemplate);
        }
        HashMap<UUID, Iterator> allMarkTemplatesById = new HashMap<UUID, Iterator>();
        HashMap<Iterator, MarkRole> defaultMarkRolesForMarkTemplates = new HashMap<Iterator, MarkRole>();
        JSONArray allMarkTemplatesJSON = (JSONArray)json.get((Object)"allMarkTemplates");
        for (Object markTemplateWithOptionalRoleNameObject : allMarkTemplatesJSON) {
            JSONObject markTemplateWithOptionalRoleName = (JSONObject)markTemplateWithOptionalRoleNameObject;
            UUID markTemplateUUID = UUID.fromString((String)markTemplateWithOptionalRoleName.get((Object)"id"));
            Iterator resolvedMarkTemplate = this.markTemplateResolver.apply(markTemplateUUID);
            if (resolvedMarkTemplate == null) {
                throw new JsonDeserializationException("Mark template with ID " + markTemplateUUID + " can't be resolved");
            }
            allMarkTemplatesById.put(markTemplateUUID, resolvedMarkTemplate);
            String markRoleIdAsStringOrNull = (String)markTemplateWithOptionalRoleName.get((Object)"associatedRoleId");
            if (markRoleIdAsStringOrNull == null || markRoleIdAsStringOrNull.isEmpty()) continue;
            MarkRole resolvedMarkRole = this.markRoleResolver.apply(UUID.fromString(markRoleIdAsStringOrNull));
            defaultMarkRolesForMarkTemplates.put(resolvedMarkTemplate, resolvedMarkRole);
        }
        ArrayList<WaypointTemplateImpl> waypoints = new ArrayList<WaypointTemplateImpl>();
        MarkRolePair.MarkRolePairFactory markPairTemplateFactory = new MarkRolePair.MarkRolePairFactory();
        JSONArray waypointsJSON = (JSONArray)json.get((Object)"waypoints");
        for (Object waypointObject : waypointsJSON) {
            ControlPointTemplate controlPointTemplate;
            JSONObject waypointJSON = (JSONObject)waypointObject;
            JSONArray markRoleIDs = (JSONArray)waypointJSON.get((Object)"markRoleIds");
            ArrayList<MarkRole> resolvedMarkRoles = new ArrayList<MarkRole>();
            for (Object markRoleIdObject : markRoleIDs) {
                MarkRole resolvedMarkRole = (MarkRole)allMarkRolesById.get(UUID.fromString(markRoleIdObject.toString()));
                if (resolvedMarkRole == null) {
                    throw new JsonDeserializationException("Mark role with ID " + markRoleIdObject + " was not defined to be part of the course template");
                }
                resolvedMarkRoles.add(resolvedMarkRole);
            }
            if (resolvedMarkRoles.size() == 1) {
                controlPointTemplate = (ControlPointTemplate)resolvedMarkRoles.get(0);
            } else if (resolvedMarkRoles.size() == 2) {
                controlPointTemplate = markPairTemplateFactory.create((String)waypointJSON.get((Object)"controlPointName"), (String)waypointJSON.get((Object)"controlPointShortName"), (MarkRole)resolvedMarkRoles.get(0), (MarkRole)resolvedMarkRoles.get(1));
            } else {
                throw new JsonDeserializationException("Unexpected number of marks found for waypoint");
            }
            PassingInstruction passingInstruction = PassingInstruction.valueOf((String)((String)waypointJSON.get((Object)"passingInstruction")));
            waypoints.add(new WaypointTemplateImpl(controlPointTemplate, passingInstruction));
        }
        JSONObject repeatablePartJSON = (JSONObject)json.get((Object)"optionalRepeatablePart");
        RepeatablePart optionalRepeatablePart = repeatablePartJSON == null ? null : (RepeatablePart)this.repeatablePartJsonDeserializer.deserialize(repeatablePartJSON);
        Number defaultNumberOfLapsNumber = (Number)json.get((Object)"defaultNumberOfLaps");
        Integer defaultNumberOfLaps = defaultNumberOfLapsNumber == null ? null : Integer.valueOf(defaultNumberOfLapsNumber.intValue());
        CourseTemplateImpl courseTemplate = new CourseTemplateImpl(null, courseTemplateName, courseTemplateShortName, allMarkTemplatesById.values(), waypoints, defaultMarkTemplatesForMarkRoles, defaultMarkRolesForMarkTemplates, optionalImageURL, optionalRepeatablePart, defaultNumberOfLaps);
        courseTemplate.setTags(tags);
        return courseTemplate;
    }
}

