/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.maneuverdetection.CompleteManeuverCurveWithEstimationData;
import com.sap.sailing.domain.maneuverdetection.ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData;
import com.sap.sailing.domain.maneuverdetection.ManeuverMainCurveWithEstimationData;
import com.sap.sailing.domain.maneuverdetection.impl.CompleteManeuverCurveWithEstimationDataImpl;
import com.sap.sailing.server.gateway.deserialization.impl.ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.ManeuverMainCurveWithEstimationDataJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.ManeuverWindJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.PositionJsonDeserializer;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import org.json.simple.JSONObject;

public class CompleteManeuverCurveWithEstimationDataJsonDeserializer
implements JsonDeserializer<CompleteManeuverCurveWithEstimationData> {
    private final ManeuverMainCurveWithEstimationDataJsonDeserializer mainCurveDeserializer;
    private final ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataJsonDeserializer curveWithUnstableCourseAndSpeedDeserializer;
    private final ManeuverWindJsonDeserializer windDeserializer;
    private final PositionJsonDeserializer positionDeserializer;

    public CompleteManeuverCurveWithEstimationDataJsonDeserializer(ManeuverMainCurveWithEstimationDataJsonDeserializer mainCurveDeserializer, ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataJsonDeserializer curveWithUnstableCourseAndSpeedDeserializer, ManeuverWindJsonDeserializer windDeserializer, PositionJsonDeserializer positionDeserializer) {
        this.mainCurveDeserializer = mainCurveDeserializer;
        this.curveWithUnstableCourseAndSpeedDeserializer = curveWithUnstableCourseAndSpeedDeserializer;
        this.windDeserializer = windDeserializer;
        this.positionDeserializer = positionDeserializer;
    }

    public CompleteManeuverCurveWithEstimationData deserialize(JSONObject object) throws JsonDeserializationException {
        Position position = this.positionDeserializer.deserialize((JSONObject)object.get((Object)"position"));
        boolean markPassing = (Boolean)object.get((Object)"markPassing");
        ManeuverMainCurveWithEstimationData mainCurve = this.mainCurveDeserializer.deserialize((JSONObject)object.get((Object)"mainCurve"));
        ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData curveWithUnstableCourseAndSpeed = this.curveWithUnstableCourseAndSpeedDeserializer.deserialize((JSONObject)object.get((Object)"curveWithUnstableCourseAndSpeed"));
        JSONObject windJson = (JSONObject)object.get((Object)"wind");
        SpeedWithBearing windSpeedWithBearing = windJson == null ? null : this.windDeserializer.deserialize(windJson);
        WindImpl wind = windSpeedWithBearing == null ? null : new WindImpl(position, mainCurve.getTimePointOfMaxTurningRate(), windSpeedWithBearing);
        Integer tackingCount = CompleteManeuverCurveWithEstimationDataJsonDeserializer.getInteger(object.get((Object)"tackingCount"));
        Integer jibingCount = CompleteManeuverCurveWithEstimationDataJsonDeserializer.getInteger(object.get((Object)"jibingCount"));
        Boolean maneuverStartsByRunningAwayFromWind = (Boolean)object.get((Object)"maneuverStartsByRunningAwayFromWind");
        Double relativeBearingToNextMarkBeforeManeuver = (Double)object.get((Object)"relativeBearingToNextMarkBeforeManeuver");
        Double relativeBearingToNextMarkAfterManeuver = (Double)object.get((Object)"relativeBearingToNextMarkAfterManeuver");
        Double closestDistanceToMarkInMeters = (Double)object.get((Object)"closestDistanceToMarkInMeters");
        Double targetTackAngle = (Double)object.get((Object)"targetTackAngleInDegrees");
        Double targetJibeAngle = (Double)object.get((Object)"targetJibeAngleInDegrees");
        return new CompleteManeuverCurveWithEstimationDataImpl(position, mainCurve, curveWithUnstableCourseAndSpeed, (Wind)wind, tackingCount.intValue(), jibingCount.intValue(), maneuverStartsByRunningAwayFromWind.booleanValue(), this.convertBearing(relativeBearingToNextMarkBeforeManeuver), this.convertBearing(relativeBearingToNextMarkAfterManeuver), markPassing, this.convertDistance(closestDistanceToMarkInMeters), targetTackAngle, targetJibeAngle);
    }

    private Bearing convertBearing(Double degrees) {
        return degrees == null ? null : new DegreeBearingImpl(degrees.doubleValue());
    }

    private Distance convertDistance(Double meters) {
        return meters == null ? null : new MeterDistance(meters.doubleValue());
    }

    public static Integer getInteger(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return ((Long)object).intValue();
    }
}

