/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.server.gateway.interfaces.CompareServersResult;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.Iterator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CompareServersResultJsonDeserializer
implements JsonDeserializer<CompareServersResult> {
    public CompareServersResult deserialize(JSONObject object) throws JsonDeserializationException {
        assert (object.size() == 2);
        Iterator i = object.keySet().iterator();
        final String serverAName = i.next().toString();
        final String serverBName = i.next().toString();
        final Iterable<JSONObject> serverADiffs = this.getDiffs(object, serverAName);
        final Iterable<JSONObject> serverBDiffs = this.getDiffs(object, serverBName);
        return new CompareServersResult(){

            public String getServerB() {
                return serverAName;
            }

            public String getServerA() {
                return serverBName;
            }

            public Iterable<JSONObject> getADiffs() {
                return serverADiffs;
            }

            public Iterable<JSONObject> getBDiffs() {
                return serverBDiffs;
            }
        };
    }

    private Iterable<JSONObject> getDiffs(JSONObject object, String serverName) {
        return Util.map((Iterable)((JSONArray)object.get((Object)serverName)), o -> (JSONObject)o);
    }
}

