/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.persistence.impl;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.ReplaceOptions;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingArchiveConfiguration;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingConfiguration;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingFactory;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingConfigurationImpl;
import com.sap.sailing.domain.swisstimingadapter.persistence.SwissTimingAdapterPersistence;
import com.sap.sailing.domain.swisstimingadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.swisstimingadapter.persistence.impl.FieldNames;
import com.sap.sse.common.Util;
import com.sap.sse.mongodb.MongoDBService;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class SwissTimingAdapterPersistenceImpl
implements SwissTimingAdapterPersistence {
    private final MongoDatabase database;
    private final SwissTimingFactory swissTimingFactory;
    private static final Logger logger = Logger.getLogger(SwissTimingAdapterPersistenceImpl.class.getName());

    public SwissTimingAdapterPersistenceImpl(MongoDBService mongoDBService, SwissTimingFactory swissTimingFactory) {
        this.database = mongoDBService.getDB();
        this.swissTimingFactory = swissTimingFactory;
    }

    @Override
    public Iterable<SwissTimingConfiguration> getSwissTimingConfigurations() {
        ArrayList<SwissTimingConfiguration> result = new ArrayList<SwissTimingConfiguration>();
        try {
            MongoCollection stConfigs = this.database.getCollection(CollectionNames.SWISSTIMING_CONFIGURATIONS.name());
            for (Document o : stConfigs.find()) {
                SwissTimingConfiguration stConfig = this.loadSwissTimingConfiguration(o);
                if (stConfig.getJsonURL() == null) continue;
                result.add(stConfig);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load recorded SwissTiming configurations. Check MongoDB settings.");
            logger.throwing(SwissTimingAdapterPersistenceImpl.class.getName(), "getSwissTimingConfigurations", e);
        }
        return result;
    }

    private SwissTimingConfiguration loadSwissTimingConfiguration(Document object) {
        boolean needsUpdate;
        String name = (String)object.get((Object)FieldNames.ST_CONFIG_NAME.name());
        String jsonURL = (String)object.get((Object)FieldNames.ST_CONFIG_JSON_URL.name());
        String hostname = (String)object.get((Object)FieldNames.ST_CONFIG_HOSTNAME.name());
        Integer port = (Integer)object.get((Object)FieldNames.ST_CONFIG_PORT.name());
        String updateURL = (String)object.get((Object)FieldNames.ST_CONFIG_UPDATE_URL.name());
        String apiToken = (String)object.get((Object)FieldNames.ST_CONFIG_API_TOKEN.name());
        String creatorName = object.getString((Object)FieldNames.ST_CONFIG_CREATOR_NAME.name());
        boolean bl = needsUpdate = creatorName == null;
        if (needsUpdate) {
            creatorName = "admin";
        }
        SwissTimingConfiguration loadedSwissTimingConfiguration = this.swissTimingFactory.createSwissTimingConfiguration(name, jsonURL, hostname, port, updateURL, apiToken, creatorName);
        if (needsUpdate) {
            this.deleteSwissTimingConfiguration(null, jsonURL);
            this.createSwissTimingConfiguration(loadedSwissTimingConfiguration);
        }
        return loadedSwissTimingConfiguration;
    }

    @Override
    public Iterable<SwissTimingArchiveConfiguration> getSwissTimingArchiveConfigurations() {
        ArrayList<SwissTimingArchiveConfiguration> result = new ArrayList<SwissTimingArchiveConfiguration>();
        try {
            MongoCollection stConfigs = this.database.getCollection(CollectionNames.SWISSTIMING_ARCHIVE_CONFIGURATIONS.name());
            for (Document o : stConfigs.find()) {
                SwissTimingArchiveConfiguration stConfig = this.loadSwissTimingArchiveConfiguration(o);
                result.add(stConfig);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load recorded SwissTiming archive configurations. Check MongoDB settings.");
            logger.throwing(SwissTimingAdapterPersistenceImpl.class.getName(), "getSwissTimingArchiveConfigurations", e);
        }
        return result;
    }

    private SwissTimingArchiveConfiguration loadSwissTimingArchiveConfiguration(Document object) {
        boolean needsUpdate;
        String jsonUrl = object.getString((Object)FieldNames.ST_ARCHIVE_JSON_URL.name());
        String creatorName = object.getString((Object)FieldNames.ST_ARCHIVE_CREATOR_NAME.name());
        boolean bl = needsUpdate = creatorName == null;
        if (needsUpdate) {
            creatorName = "admin";
        }
        SwissTimingArchiveConfiguration loadedSwissTimingArchiveConfiguration = this.swissTimingFactory.createSwissTimingArchiveConfiguration(jsonUrl, creatorName);
        if (needsUpdate) {
            this.deleteSwissTimingArchiveConfiguration(this.swissTimingFactory.createSwissTimingArchiveConfiguration(jsonUrl, null));
            this.createSwissTimingArchiveConfiguration(loadedSwissTimingArchiveConfiguration);
        }
        return loadedSwissTimingArchiveConfiguration;
    }

    @Override
    public void createSwissTimingConfiguration(SwissTimingConfiguration swissTimingConfiguration) {
        MongoCollection stConfigCollection = this.database.getCollection(CollectionNames.SWISSTIMING_CONFIGURATIONS.name());
        Document result = this.storeSwissTimingConfiguration(swissTimingConfiguration);
        stConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).insertOne((Object)result);
    }

    private Document storeSwissTimingConfiguration(SwissTimingConfiguration swissTimingConfiguration) {
        Document result = new Document();
        result.put(FieldNames.ST_CONFIG_NAME.name(), (Object)swissTimingConfiguration.getName());
        result.put(FieldNames.ST_CONFIG_JSON_URL.name(), (Object)swissTimingConfiguration.getJsonURL());
        result.put(FieldNames.ST_CONFIG_HOSTNAME.name(), (Object)swissTimingConfiguration.getHostname());
        result.put(FieldNames.ST_CONFIG_PORT.name(), (Object)swissTimingConfiguration.getPort());
        result.put(FieldNames.ST_CONFIG_UPDATE_URL.name(), (Object)swissTimingConfiguration.getUpdateURL());
        result.put(FieldNames.ST_CONFIG_CREATOR_NAME.name(), (Object)swissTimingConfiguration.getCreatorName());
        result.put(FieldNames.ST_CONFIG_API_TOKEN.name(), (Object)swissTimingConfiguration.getApiToken());
        return result;
    }

    @Override
    public void createSwissTimingArchiveConfiguration(SwissTimingArchiveConfiguration config) {
        MongoCollection stArchiveConfigCollection = this.database.getCollection(CollectionNames.SWISSTIMING_ARCHIVE_CONFIGURATIONS.name());
        Document result = this.storeSwissTimingArchiveConfiguration(config);
        stArchiveConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).insertOne((Object)result);
    }

    @Override
    public void updateSwissTimingArchiveConfiguration(SwissTimingArchiveConfiguration config) {
        MongoCollection stArchiveConfigCollection = this.database.getCollection(CollectionNames.SWISSTIMING_ARCHIVE_CONFIGURATIONS.name());
        Document result = this.storeSwissTimingArchiveConfiguration(config);
        stArchiveConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)result, (Object)result, new ReplaceOptions().upsert(true));
    }

    private Document storeSwissTimingArchiveConfiguration(SwissTimingArchiveConfiguration config) {
        Document result = new Document();
        result.put(FieldNames.ST_ARCHIVE_JSON_URL.name(), (Object)config.getJsonURL());
        result.put(FieldNames.ST_ARCHIVE_CREATOR_NAME.name(), (Object)config.getCreatorName());
        return result;
    }

    @Override
    public void deleteSwissTimingArchiveConfiguration(SwissTimingArchiveConfiguration config) {
        MongoCollection stArchiveConfigCollection = this.database.getCollection(CollectionNames.SWISSTIMING_ARCHIVE_CONFIGURATIONS.name());
        Document result = this.storeSwissTimingArchiveConfiguration(config);
        stArchiveConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteOne((Bson)result);
    }

    @Override
    public void deleteSwissTimingConfiguration(String creatorName, String jsonURL) {
        MongoCollection stConfigCollection = this.database.getCollection(CollectionNames.SWISSTIMING_CONFIGURATIONS.name());
        Document deleteQuery = new Document(FieldNames.ST_CONFIG_JSON_URL.name(), (Object)jsonURL);
        deleteQuery.put(FieldNames.ST_CONFIG_CREATOR_NAME.name(), (Object)creatorName);
        stConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteMany((Bson)deleteQuery);
    }

    @Override
    public void updateSwissTimingConfiguration(SwissTimingConfiguration config, boolean isApiTokenAvailable) {
        SwissTimingConfiguration configToStore;
        MongoCollection stConfigCollection = this.database.getCollection(CollectionNames.SWISSTIMING_CONFIGURATIONS.name());
        if (isApiTokenAvailable && !Util.hasLength((String)config.getApiToken())) {
            String oldApiToken = (String)Util.first((Iterable)Util.map((Iterable)Util.filter(this.getSwissTimingConfigurations(), c -> c.getJsonURL().equals(config.getJsonURL())), c -> c.getApiToken()));
            configToStore = new SwissTimingConfigurationImpl(config.getName(), config.getJsonURL(), config.getHostname(), config.getPort(), config.getUpdateURL(), oldApiToken, config.getCreatorName());
        } else {
            configToStore = config;
        }
        Document result = this.storeSwissTimingConfiguration(configToStore);
        Document updateQuery = new Document(FieldNames.ST_CONFIG_JSON_URL.name(), (Object)configToStore.getJsonURL());
        updateQuery.put(FieldNames.ST_CONFIG_CREATOR_NAME.name(), (Object)configToStore.getCreatorName());
        stConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)updateQuery, (Object)result, new ReplaceOptions().upsert(true));
    }
}

