/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.persistence.impl;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.MongoRaceLogStoreFactory;
import com.sap.sailing.domain.persistence.MongoRegattaLogStoreFactory;
import com.sap.sailing.domain.swisstimingadapter.DomainFactory;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingAdapterFactory;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingArchiveConfiguration;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingConfiguration;
import com.sap.sailing.domain.swisstimingadapter.persistence.SwissTimingAdapterPersistence;
import com.sap.sailing.domain.swisstimingadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.swisstimingadapter.persistence.impl.SwissTimingConnectivityParamsHandler;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        CollectionNames[] collectionNamesArray = CollectionNames.values();
        int n = collectionNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CollectionNames name = collectionNamesArray[n2];
            MongoDBService.INSTANCE.registerExclusively(CollectionNames.class, name.name());
            ++n2;
        }
        new Thread(() -> {
            FullyInitializedReplicableTracker securityServiceServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
            ServiceTracker mongoObjectFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, MongoObjectFactory.class);
            ServiceTracker domainObjectFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, DomainObjectFactory.class);
            ServiceTracker swissTimingAdapterFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, SwissTimingAdapterFactory.class);
            try {
                MongoObjectFactory mongoObjectFactory = (MongoObjectFactory)mongoObjectFactoryServiceTracker.waitForService(0L);
                DomainObjectFactory domainObjectFactory = (DomainObjectFactory)domainObjectFactoryServiceTracker.waitForService(0L);
                SwissTimingAdapterFactory swissTimingAdapterFactory = (SwissTimingAdapterFactory)swissTimingAdapterFactoryServiceTracker.waitForService(0L);
                SecurityService securityService = (SecurityService)securityServiceServiceTracker.getInitializedService(0L);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                DomainFactory domainFactory = swissTimingAdapterFactory.getOrCreateSwissTimingAdapter(domainObjectFactory.getBaseDomainFactory()).getSwissTimingDomainFactory();
                SwissTimingConnectivityParamsHandler paramsHandler = new SwissTimingConnectivityParamsHandler(MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStore(mongoObjectFactory, domainObjectFactory), MongoRegattaLogStoreFactory.INSTANCE.getMongoRegattaLogStore(mongoObjectFactory, domainObjectFactory), domainFactory, securityService);
                ((Dictionary)properties).put("type", "SWISS_TIMING");
                context.registerService(RaceTrackingConnectivityParametersHandler.class, (Object)paramsHandler, properties);
                for (SwissTimingArchiveConfiguration swissTimingArchive : SwissTimingAdapterPersistence.INSTANCE.getSwissTimingArchiveConfigurations()) {
                    securityService.migrateOwnership((WithQualifiedObjectIdentifier)swissTimingArchive);
                }
                for (SwissTimingConfiguration swissTiming : SwissTimingAdapterPersistence.INSTANCE.getSwissTimingConfigurations()) {
                    securityService.migrateOwnership((WithQualifiedObjectIdentifier)swissTiming);
                }
                securityService.assumeOwnershipMigrated(SecuredDomainType.SWISS_TIMING_ACCOUNT.getName());
                securityService.assumeOwnershipMigrated(SecuredDomainType.SWISS_TIMING_ARCHIVE_ACCOUNT.getName());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception trying to register SwissTiming RaceTrackingConnectivityParametersHandler implementation", e);
            }
        }, String.valueOf(this.getClass().getName()) + " registering connectivity handler").start();
    }

    public void stop(BundleContext context) throws Exception {
    }
}

