/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLayersRequest extends LambdaRequest implements
        ToCopyableBuilder<ListLayersRequest.Builder, ListLayersRequest> {
    private static final SdkField<String> COMPATIBLE_RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompatibleRuntime").getter(getter(ListLayersRequest::compatibleRuntimeAsString))
            .setter(setter(Builder::compatibleRuntime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CompatibleRuntime").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListLayersRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(ListLayersRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final SdkField<String> COMPATIBLE_ARCHITECTURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CompatibleArchitecture")
            .getter(getter(ListLayersRequest::compatibleArchitectureAsString))
            .setter(setter(Builder::compatibleArchitecture))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CompatibleArchitecture").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_RUNTIME_FIELD,
            MARKER_FIELD, MAX_ITEMS_FIELD, COMPATIBLE_ARCHITECTURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String compatibleRuntime;

    private final String marker;

    private final Integer maxItems;

    private final String compatibleArchitecture;

    private ListLayersRequest(BuilderImpl builder) {
        super(builder);
        this.compatibleRuntime = builder.compatibleRuntime;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.compatibleArchitecture = builder.compatibleArchitecture;
    }

    /**
     * <p>
     * A runtime identifier.
     * </p>
     * <p>
     * The following list includes deprecated runtimes. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime use
     * after deprecation</a>.
     * </p>
     * <p>
     * For a list of all currently supported runtimes, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
     * runtimes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compatibleRuntime}
     * will return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compatibleRuntimeAsString}.
     * </p>
     * 
     * @return A runtime identifier.</p>
     *         <p>
     *         The following list includes deprecated runtimes. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
     *         >Runtime use after deprecation</a>.
     *         </p>
     *         <p>
     *         For a list of all currently supported runtimes, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
     *         runtimes</a>.
     * @see Runtime
     */
    public final Runtime compatibleRuntime() {
        return Runtime.fromValue(compatibleRuntime);
    }

    /**
     * <p>
     * A runtime identifier.
     * </p>
     * <p>
     * The following list includes deprecated runtimes. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime use
     * after deprecation</a>.
     * </p>
     * <p>
     * For a list of all currently supported runtimes, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
     * runtimes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compatibleRuntime}
     * will return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compatibleRuntimeAsString}.
     * </p>
     * 
     * @return A runtime identifier.</p>
     *         <p>
     *         The following list includes deprecated runtimes. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
     *         >Runtime use after deprecation</a>.
     *         </p>
     *         <p>
     *         For a list of all currently supported runtimes, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
     *         runtimes</a>.
     * @see Runtime
     */
    public final String compatibleRuntimeAsString() {
        return compatibleRuntime;
    }

    /**
     * <p>
     * A pagination token returned by a previous call.
     * </p>
     * 
     * @return A pagination token returned by a previous call.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of layers to return.
     * </p>
     * 
     * @return The maximum number of layers to return.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     * architecture</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compatibleArchitecture} will return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #compatibleArchitectureAsString}.
     * </p>
     * 
     * @return The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
     *         set architecture</a>.
     * @see Architecture
     */
    public final Architecture compatibleArchitecture() {
        return Architecture.fromValue(compatibleArchitecture);
    }

    /**
     * <p>
     * The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     * architecture</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compatibleArchitecture} will return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #compatibleArchitectureAsString}.
     * </p>
     * 
     * @return The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
     *         set architecture</a>.
     * @see Architecture
     */
    public final String compatibleArchitectureAsString() {
        return compatibleArchitecture;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(compatibleRuntimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(compatibleArchitectureAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayersRequest)) {
            return false;
        }
        ListLayersRequest other = (ListLayersRequest) obj;
        return Objects.equals(compatibleRuntimeAsString(), other.compatibleRuntimeAsString())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(compatibleArchitectureAsString(), other.compatibleArchitectureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLayersRequest").add("CompatibleRuntime", compatibleRuntimeAsString())
                .add("Marker", marker()).add("MaxItems", maxItems())
                .add("CompatibleArchitecture", compatibleArchitectureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompatibleRuntime":
            return Optional.ofNullable(clazz.cast(compatibleRuntimeAsString()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "CompatibleArchitecture":
            return Optional.ofNullable(clazz.cast(compatibleArchitectureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompatibleRuntime", COMPATIBLE_RUNTIME_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("CompatibleArchitecture", COMPATIBLE_ARCHITECTURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLayersRequest, T> g) {
        return obj -> g.apply((ListLayersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLayersRequest> {
        /**
         * <p>
         * A runtime identifier.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime
         * use after deprecation</a>.
         * </p>
         * <p>
         * For a list of all currently supported runtimes, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         * runtimes</a>.
         * </p>
         * 
         * @param compatibleRuntime
         *        A runtime identifier.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
         *        >Runtime use after deprecation</a>.
         *        </p>
         *        <p>
         *        For a list of all currently supported runtimes, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         *        runtimes</a>.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder compatibleRuntime(String compatibleRuntime);

        /**
         * <p>
         * A runtime identifier.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime
         * use after deprecation</a>.
         * </p>
         * <p>
         * For a list of all currently supported runtimes, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         * runtimes</a>.
         * </p>
         * 
         * @param compatibleRuntime
         *        A runtime identifier.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
         *        >Runtime use after deprecation</a>.
         *        </p>
         *        <p>
         *        For a list of all currently supported runtimes, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         *        runtimes</a>.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder compatibleRuntime(Runtime compatibleRuntime);

        /**
         * <p>
         * A pagination token returned by a previous call.
         * </p>
         * 
         * @param marker
         *        A pagination token returned by a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of layers to return.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of layers to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         * architecture</a>.
         * </p>
         * 
         * @param compatibleArchitecture
         *        The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         *        set architecture</a>.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder compatibleArchitecture(String compatibleArchitecture);

        /**
         * <p>
         * The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         * architecture</a>.
         * </p>
         * 
         * @param compatibleArchitecture
         *        The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         *        set architecture</a>.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder compatibleArchitecture(Architecture compatibleArchitecture);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String compatibleRuntime;

        private String marker;

        private Integer maxItems;

        private String compatibleArchitecture;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLayersRequest model) {
            super(model);
            compatibleRuntime(model.compatibleRuntime);
            marker(model.marker);
            maxItems(model.maxItems);
            compatibleArchitecture(model.compatibleArchitecture);
        }

        public final String getCompatibleRuntime() {
            return compatibleRuntime;
        }

        public final void setCompatibleRuntime(String compatibleRuntime) {
            this.compatibleRuntime = compatibleRuntime;
        }

        @Override
        public final Builder compatibleRuntime(String compatibleRuntime) {
            this.compatibleRuntime = compatibleRuntime;
            return this;
        }

        @Override
        public final Builder compatibleRuntime(Runtime compatibleRuntime) {
            this.compatibleRuntime(compatibleRuntime == null ? null : compatibleRuntime.toString());
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getCompatibleArchitecture() {
            return compatibleArchitecture;
        }

        public final void setCompatibleArchitecture(String compatibleArchitecture) {
            this.compatibleArchitecture = compatibleArchitecture;
        }

        @Override
        public final Builder compatibleArchitecture(String compatibleArchitecture) {
            this.compatibleArchitecture = compatibleArchitecture;
            return this;
        }

        @Override
        public final Builder compatibleArchitecture(Architecture compatibleArchitecture) {
            this.compatibleArchitecture(compatibleArchitecture == null ? null : compatibleArchitecture.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLayersRequest build() {
            return new ListLayersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
