/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceLinkedRoleDeletionStatusRequest extends IamRequest implements
        ToCopyableBuilder<GetServiceLinkedRoleDeletionStatusRequest.Builder, GetServiceLinkedRoleDeletionStatusRequest> {
    private static final SdkField<String> DELETION_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionTaskId").getter(getter(GetServiceLinkedRoleDeletionStatusRequest::deletionTaskId))
            .setter(setter(Builder::deletionTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTaskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_TASK_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String deletionTaskId;

    private GetServiceLinkedRoleDeletionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.deletionTaskId = builder.deletionTaskId;
    }

    /**
     * <p>
     * The deletion task identifier. This identifier is returned by the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
     * >DeleteServiceLinkedRole</a> operation in the format
     * <code>task/aws-service-role/&lt;service-principal-name&gt;/&lt;role-name&gt;/&lt;task-uuid&gt;</code>.
     * </p>
     * 
     * @return The deletion task identifier. This identifier is returned by the <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
     *         >DeleteServiceLinkedRole</a> operation in the format
     *         <code>task/aws-service-role/&lt;service-principal-name&gt;/&lt;role-name&gt;/&lt;task-uuid&gt;</code>.
     */
    public final String deletionTaskId() {
        return deletionTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletionTaskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLinkedRoleDeletionStatusRequest)) {
            return false;
        }
        GetServiceLinkedRoleDeletionStatusRequest other = (GetServiceLinkedRoleDeletionStatusRequest) obj;
        return Objects.equals(deletionTaskId(), other.deletionTaskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceLinkedRoleDeletionStatusRequest").add("DeletionTaskId", deletionTaskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletionTaskId":
            return Optional.ofNullable(clazz.cast(deletionTaskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeletionTaskId", DELETION_TASK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceLinkedRoleDeletionStatusRequest, T> g) {
        return obj -> g.apply((GetServiceLinkedRoleDeletionStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceLinkedRoleDeletionStatusRequest> {
        /**
         * <p>
         * The deletion task identifier. This identifier is returned by the <a
         * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
         * >DeleteServiceLinkedRole</a> operation in the format
         * <code>task/aws-service-role/&lt;service-principal-name&gt;/&lt;role-name&gt;/&lt;task-uuid&gt;</code>.
         * </p>
         * 
         * @param deletionTaskId
         *        The deletion task identifier. This identifier is returned by the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
         *        >DeleteServiceLinkedRole</a> operation in the format
         *        <code>task/aws-service-role/&lt;service-principal-name&gt;/&lt;role-name&gt;/&lt;task-uuid&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionTaskId(String deletionTaskId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String deletionTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLinkedRoleDeletionStatusRequest model) {
            super(model);
            deletionTaskId(model.deletionTaskId);
        }

        public final String getDeletionTaskId() {
            return deletionTaskId;
        }

        public final void setDeletionTaskId(String deletionTaskId) {
            this.deletionTaskId = deletionTaskId;
        }

        @Override
        public final Builder deletionTaskId(String deletionTaskId) {
            this.deletionTaskId = deletionTaskId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetServiceLinkedRoleDeletionStatusRequest build() {
            return new GetServiceLinkedRoleDeletionStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
