/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a volume status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeStatusDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeStatusDetails.Builder, VolumeStatusDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(VolumeStatusDetails::nameAsString))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(VolumeStatusDetails::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private VolumeStatusDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the volume status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>io-enabled</code> - Indicates the volume I/O status. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume status
     * checks</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io-performance</code> - Indicates the volume performance status. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume status
     * checks</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>initialization-state</code> - Indicates the status of the volume initialization process. For more
     * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize
     * Amazon EBS volumes</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link VolumeStatusName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the volume status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>io-enabled</code> - Indicates the volume I/O status. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume
     *         status checks</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io-performance</code> - Indicates the volume performance status. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume
     *         status checks</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>initialization-state</code> - Indicates the status of the volume initialization process. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize Amazon EBS
     *         volumes</a>.
     *         </p>
     *         </li>
     * @see VolumeStatusName
     */
    public final VolumeStatusName name() {
        return VolumeStatusName.fromValue(name);
    }

    /**
     * <p>
     * The name of the volume status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>io-enabled</code> - Indicates the volume I/O status. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume status
     * checks</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io-performance</code> - Indicates the volume performance status. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume status
     * checks</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>initialization-state</code> - Indicates the status of the volume initialization process. For more
     * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize
     * Amazon EBS volumes</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link VolumeStatusName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the volume status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>io-enabled</code> - Indicates the volume I/O status. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume
     *         status checks</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io-performance</code> - Indicates the volume performance status. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume
     *         status checks</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>initialization-state</code> - Indicates the status of the volume initialization process. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize Amazon EBS
     *         volumes</a>.
     *         </p>
     *         </li>
     * @see VolumeStatusName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The intended status of the volume status.
     * </p>
     * 
     * @return The intended status of the volume status.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusDetails)) {
            return false;
        }
        VolumeStatusDetails other = (VolumeStatusDetails) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeStatusDetails").add("Name", nameAsString()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatusDetails, T> g) {
        return obj -> g.apply((VolumeStatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeStatusDetails> {
        /**
         * <p>
         * The name of the volume status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>io-enabled</code> - Indicates the volume I/O status. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume
         * status checks</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io-performance</code> - Indicates the volume performance status. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume
         * status checks</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>initialization-state</code> - Indicates the status of the volume initialization process. For more
         * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize
         * Amazon EBS volumes</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the volume status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>io-enabled</code> - Indicates the volume I/O status. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS
         *        volume status checks</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io-performance</code> - Indicates the volume performance status. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS
         *        volume status checks</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>initialization-state</code> - Indicates the status of the volume initialization process. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize Amazon EBS
         *        volumes</a>.
         *        </p>
         *        </li>
         * @see VolumeStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the volume status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>io-enabled</code> - Indicates the volume I/O status. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume
         * status checks</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io-performance</code> - Indicates the volume performance status. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS volume
         * status checks</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>initialization-state</code> - Indicates the status of the volume initialization process. For more
         * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize
         * Amazon EBS volumes</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the volume status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>io-enabled</code> - Indicates the volume I/O status. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS
         *        volume status checks</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io-performance</code> - Indicates the volume performance status. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-checks.html">Amazon EBS
         *        volume status checks</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>initialization-state</code> - Indicates the status of the volume initialization process. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize Amazon EBS
         *        volumes</a>.
         *        </p>
         *        </li>
         * @see VolumeStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusName
         */
        Builder name(VolumeStatusName name);

        /**
         * <p>
         * The intended status of the volume status.
         * </p>
         * 
         * @param status
         *        The intended status of the volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusDetails model) {
            name(model.name);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(VolumeStatusName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public VolumeStatusDetails build() {
            return new VolumeStatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
