/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration settings for the modified Reserved Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstancesConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstancesConfiguration.Builder, ReservedInstancesConfiguration> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(ReservedInstancesConfiguration::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(ReservedInstancesConfiguration::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(ReservedInstancesConfiguration::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Platform")
            .getter(getter(ReservedInstancesConfiguration::platform))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Scope")
            .getter(getter(ReservedInstancesConfiguration::scopeAsString))
            .setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope")
                    .unmarshallLocationName("scope").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(ReservedInstancesConfiguration::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD, PLATFORM_FIELD, SCOPE_FIELD, AVAILABILITY_ZONE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final Integer instanceCount;

    private final String instanceType;

    private final String platform;

    private final String scope;

    private final String availabilityZoneId;

    private ReservedInstancesConfiguration(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
        this.scope = builder.scope;
        this.availabilityZoneId = builder.availabilityZoneId;
    }

    /**
     * <p>
     * The Availability Zone for the modified Reserved Instances.
     * </p>
     * 
     * @return The Availability Zone for the modified Reserved Instances.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of modified Reserved Instances.
     * </p>
     * <note>
     * <p>
     * This is a required field for a request.
     * </p>
     * </note>
     * 
     * @return The number of modified Reserved Instances.</p> <note>
     *         <p>
     *         This is a required field for a request.
     *         </p>
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The instance type for the modified Reserved Instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for the modified Reserved Instances.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type for the modified Reserved Instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for the modified Reserved Instances.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The network platform of the modified Reserved Instances.
     * </p>
     * 
     * @return The network platform of the modified Reserved Instances.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a Region or instances in a specific Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a Region or instances in a specific Availability
     *         Zone.
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a Region or instances in a specific Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a Region or instances in a specific Availability
     *         Zone.
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The ID of the Availability Zone.
     * </p>
     * 
     * @return The ID of the Availability Zone.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesConfiguration)) {
            return false;
        }
        ReservedInstancesConfiguration other = (ReservedInstancesConfiguration) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(platform(), other.platform()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedInstancesConfiguration").add("AvailabilityZone", availabilityZone())
                .add("InstanceCount", instanceCount()).add("InstanceType", instanceTypeAsString()).add("Platform", platform())
                .add("Scope", scopeAsString()).add("AvailabilityZoneId", availabilityZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesConfiguration, T> g) {
        return obj -> g.apply((ReservedInstancesConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstancesConfiguration> {
        /**
         * <p>
         * The Availability Zone for the modified Reserved Instances.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the modified Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of modified Reserved Instances.
         * </p>
         * <note>
         * <p>
         * This is a required field for a request.
         * </p>
         * </note>
         * 
         * @param instanceCount
         *        The number of modified Reserved Instances.</p> <note>
         *        <p>
         *        This is a required field for a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The instance type for the modified Reserved Instances.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the modified Reserved Instances.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type for the modified Reserved Instances.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the modified Reserved Instances.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The network platform of the modified Reserved Instances.
         * </p>
         * 
         * @param platform
         *        The network platform of the modified Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a Region or instances in a specific Availability
         * Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a Region or instances in a specific
         *        Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a Region or instances in a specific Availability
         * Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a Region or instances in a specific
         *        Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * The ID of the Availability Zone.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Integer instanceCount;

        private String instanceType;

        private String platform;

        private String scope;

        private String availabilityZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesConfiguration model) {
            availabilityZone(model.availabilityZone);
            instanceCount(model.instanceCount);
            instanceType(model.instanceType);
            platform(model.platform);
            scope(model.scope);
            availabilityZoneId(model.availabilityZoneId);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        @Override
        public ReservedInstancesConfiguration build() {
            return new ReservedInstancesConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
