/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.rest.impl;

import com.sap.sse.common.http.HttpHeaderUtil;
import com.sap.sse.rest.CORSFilterConfiguration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CORSFilterConfigurationImpl
implements CORSFilterConfiguration {
    private boolean wildcard;
    private final Set<String> allowedOrigins = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public boolean isWildcard() {
        return this.wildcard;
    }

    @Override
    public void setWildcard() {
        this.wildcard = true;
    }

    @Override
    public boolean contains(String origin) {
        return origin != null && this.allowedOrigins.contains(origin.toLowerCase());
    }

    @Override
    public void setOrigins(Iterable<String> allowedOrigins) throws IllegalArgumentException {
        for (String allowedOrigin : allowedOrigins) {
            if (HttpHeaderUtil.isValidOriginHeaderValue((String)allowedOrigin)) continue;
            throw new IllegalArgumentException("\"" + allowedOrigin + "\" is not a valid CORS origin");
        }
        this.wildcard = false;
        this.allowedOrigins.clear();
        for (String allowedOrigin : allowedOrigins) {
            this.allowedOrigins.add(allowedOrigin.toLowerCase());
        }
    }

    @Override
    public Iterable<String> getOrigins() {
        return Collections.unmodifiableSet(this.allowedOrigins);
    }

    public String toString() {
        return "Access-Control-Allow-Origin: " + (this.isWildcard() ? "*" : this.allowedOrigins);
    }
}

