/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.windestimation;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.confidence.ConfidenceBasedAverager;
import com.sap.sailing.domain.common.confidence.ConfidenceFactory;
import com.sap.sailing.domain.common.confidence.HasConfidence;
import com.sap.sailing.domain.common.confidence.impl.ScalableDouble;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableBearing;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableSpeed;
import com.sap.sailing.domain.tracking.impl.WindTrackImpl;
import com.sap.sailing.polars.windestimation.ManeuverBasedWindEstimationTrack;
import com.sap.sailing.polars.windestimation.ManeuverClassification;
import com.sap.sailing.polars.windestimation.ManeuverClassificationToHasConfidenceAndIsScalableAdapter;
import com.sap.sailing.polars.windestimation.ScalableBearingAndScalableDouble;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.util.kmeans.Cluster;
import com.sap.sse.util.kmeans.KMeansMappingClusterer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractManeuverBasedWindEstimationTrackImpl
extends WindTrackImpl
implements ManeuverBasedWindEstimationTrack {
    private static final long serialVersionUID = -764156498143531475L;
    private static final Logger logger = Logger.getLogger(AbstractManeuverBasedWindEstimationTrackImpl.class.getName());
    protected static final double DEFAULT_BASE_CONFIDENCE = 0.01;
    protected static final double ANGULAR_DISTANCE_FOR_HALF_CONFIDENCE_FOR_OPPOSITE_TACK_CLUSTER_DEG = 20.0;
    protected static final double BOOST_FACTOR_FOR_FULL_JIBE_CLUSTER_LIKELIHOOD = 0.2;
    protected static final double BOOST_FACTOR_FOR_FULL_HEAD_UP_BEAR_AWAY_CLUSTER_LIKELIHOOD = 0.1;
    protected static final double EXPECTED_AVERAGE_HEAD_UP_AND_BEAR_AWAY_MANEUVER_ANGLE_DEG = 10.0;
    protected static final double THRESHOLD_JIBE_CLUSTER_DIFFERENCE_DEGREES = 20.0;
    protected static final double BOOST_FACTOR_FOR_JIBE_TACK_SPEED_RATIO_LIKELIHOOD = 0.0;
    private final Map<Util.Pair<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>, ManeuverType>, Util.Pair<Bearing, Double>> weightedAverageMiddleCOGForManeuverType;
    private Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> clusters;
    private List<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> tackClusters;
    private List<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> jibeClusters;
    private final BoatClass boatClass;
    private final String raceName;
    private Map<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>, Double> likelihoodOfBeingTackCluster = new HashMap<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>, Double>();

    public AbstractManeuverBasedWindEstimationTrackImpl(String raceName, BoatClass boatClass, long millisecondsOverWhichToAverage) {
        super(millisecondsOverWhichToAverage, 0.01, false, AbstractManeuverBasedWindEstimationTrackImpl.class.getName());
        this.raceName = raceName;
        this.boatClass = boatClass;
        this.weightedAverageMiddleCOGForManeuverType = new HashMap<Util.Pair<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>, ManeuverType>, Util.Pair<Bearing, Double>>();
    }

    @Override
    public void initialize() throws NotEnoughDataHasBeenAddedException {
        long start = System.currentTimeMillis();
        Util.Triple<Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>>, List<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>>, List<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>>> clusterStructure = this.analyzeRace();
        logger.fine("Computed virtual wind fixes from maneuvers for race " + this.raceName + " in " + (System.currentTimeMillis() - start) + "ms");
        this.clusters = (Set)clusterStructure.getA();
        this.tackClusters = (List)clusterStructure.getB();
        this.jibeClusters = (List)clusterStructure.getC();
    }

    private Util.Triple<Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>>, List<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>>, List<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>>> analyzeRace() throws NotEnoughDataHasBeenAddedException {
        int numberOfClusters = 16;
        KMeansMappingClusterer clusterer = new KMeansMappingClusterer(16, this.getManeuverClassifications(), mc -> mc.getScalableMiddleManeuverCourseAndManeuverAngleDeg(), Stream.concat(IntStream.range(0, 8).mapToObj(i -> new Util.Pair((Object)new DegreeBearingImpl((double)i * 360.0 / 16.0 / 2.0), (Object)45.0)), IntStream.range(0, 8).mapToObj(i -> new Util.Pair((Object)new DegreeBearingImpl((double)i * 360.0 / 16.0 / 2.0), (Object)-45.0))));
        logger.fine("K-Means maneuver clusterer for wind estimation took " + clusterer.getNumberOfIterations() + " iterations");
        Set clusters = clusterer.getClusters();
        for (Cluster c : clusters) {
            this.likelihoodOfBeingTackCluster.put((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)c, this.getLikelihoodOfBeingTackCluster((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)c, clusters));
        }
        List tackClusters = clusters.stream().sorted((c1, c2) -> (int)(-Math.signum(this.likelihoodOfBeingTackCluster.get(c1) - this.likelihoodOfBeingTackCluster.get(c2)))).limit(2L).collect(Collectors.toList());
        this.addWindFixes(tackClusters.stream(), ManeuverType.TACK);
        Bearing estimatedJibeMiddleCOG = null;
        if (!tackClusters.isEmpty()) {
            Bearing avgTackCog;
            if (tackClusters.size() > 1 && (avgTackCog = (Bearing)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)((Cluster)tackClusters.get(1)), ManeuverType.TACK).getA()) != null) {
                estimatedJibeMiddleCOG = new ScalableBearing((Bearing)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)((Cluster)tackClusters.get(0)), ManeuverType.TACK).getA()).add((ScalableValue)new ScalableBearing(avgTackCog)).divide(2.0).reverse();
            }
            if (estimatedJibeMiddleCOG == null && (avgTackCog = (Bearing)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)((Cluster)tackClusters.get(0)), ManeuverType.TACK).getA()) != null) {
                estimatedJibeMiddleCOG = avgTackCog.reverse();
            }
        }
        List jibeClusters = estimatedJibeMiddleCOG == null ? Collections.emptyList() : this.getJibeClusters(estimatedJibeMiddleCOG, clusters).collect(Collectors.toList());
        this.addWindFixes(jibeClusters.stream(), ManeuverType.JIBE);
        return new Util.Triple((Object)clusters, tackClusters, jibeClusters);
    }

    private void addWindFixes(Stream<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> clusters, ManeuverType maneuverType) {
        clusters.forEach(cluster -> {
            for (ManeuverClassification mc : cluster) {
                SpeedWithBearingWithConfidence<Void> estimatedWindSpeedAndBearing = mc.getEstimatedWindSpeedAndBearing(maneuverType);
                if (estimatedWindSpeedAndBearing == null) continue;
                WindImpl windFromTack = new WindImpl(mc.getPosition(), mc.getTimePoint(), estimatedWindSpeedAndBearing.getObject());
                this.add((Wind)windFromTack);
            }
        });
    }

    protected abstract double getLikelihoodOfBeingTackCluster(Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble> var1, Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> var2);

    protected double getAverageLikelihoodOfBeingManeuver(ManeuverType maneuverType, Stream<ManeuverClassification> maneuverClassifications) {
        return maneuverClassifications.mapToDouble(mc -> mc.getLikelihoodForManeuverType(maneuverType)).average().orElse(0.0);
    }

    @Override
    public BoatClass getBoatClass() {
        return this.boatClass;
    }

    protected Stream<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> getJibeClusters(Bearing approximateMiddleCOGForJibes, Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> clusters) {
        return clusters.stream().sorted((a, b) -> (int)(-Math.signum(this.getAverageLikelihoodOfBeingManeuver(ManeuverType.JIBE, a.stream()) - this.getAverageLikelihoodOfBeingManeuver(ManeuverType.JIBE, b.stream())))).filter(jibeClusterCandidate -> {
            Bearing middleCog = (Bearing)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)jibeClusterCandidate, ManeuverType.JIBE).getA();
            return middleCog == null ? false : Math.abs(middleCog.getDifferenceTo(approximateMiddleCOGForJibes).getDegrees()) < 20.0;
        }).limit(2L);
    }

    protected abstract double getLikelihoodOfBeingJibeCluster(Speed var1, Stream<ManeuverClassification> var2, BoatClass var3, Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> var4);

    protected Speed getWeightedAverageSpeed(Stream<ManeuverClassification> cluster, ManeuverType maneuverType) {
        ConfidenceBasedAverager averager = ConfidenceFactory.INSTANCE.createAverager(null);
        HasConfidence average = averager.getAverage(cluster.map(new ManeuverClassificationToHasConfidenceAndIsScalableAdapter(maneuverType, mc -> new ScalableSpeed(mc.getSpeedAtManeuverStart()))).iterator(), null);
        return average == null ? null : (Speed)average.getObject();
    }

    protected abstract Stream<ManeuverClassification> getManeuverClassifications();

    protected Util.Pair<Bearing, Double> getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg(Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble> cluster, ManeuverType maneuverType) {
        Util.Pair key = new Util.Pair(cluster, (Object)maneuverType);
        Util.Pair result = this.weightedAverageMiddleCOGForManeuverType.get(key);
        if (result == null) {
            ConfidenceBasedAverager middleCOGAverager = ConfidenceFactory.INSTANCE.createAverager(null);
            HasConfidence average = middleCOGAverager.getAverage(cluster.stream().map(new ManeuverClassificationToHasConfidenceAndIsScalableAdapter(maneuverType, mc -> new ScalableBearing(mc.getMiddleManeuverCourse()))).iterator(), null);
            ConfidenceBasedAverager maneuverAngleAverager = ConfidenceFactory.INSTANCE.createAverager(null);
            HasConfidence maneuverAngleAverageDeg = maneuverAngleAverager.getAverage(cluster.stream().map(new ManeuverClassificationToHasConfidenceAndIsScalableAdapter(maneuverType, mc -> new ScalableDouble(mc.getManeuverAngleDeg()))).iterator(), null);
            result = new Util.Pair((Object)((Bearing)average.getObject()), (Object)((Double)maneuverAngleAverageDeg.getObject()));
            this.weightedAverageMiddleCOGForManeuverType.put((Util.Pair<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>, ManeuverType>)key, (Util.Pair<Bearing, Double>)result);
        }
        return result;
    }

    @Override
    public Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> getClusters() {
        return this.clusters;
    }

    @Override
    public List<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> getTackClusters() {
        return this.tackClusters;
    }

    @Override
    public List<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> getJibeClusters() {
        return this.jibeClusters;
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation(this.getClusters().stream());
    }

    @Override
    public String getStringRepresentation(Stream<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> clusters) {
        StringBuilder stringRepresentation = new StringBuilder();
        stringRepresentation.delete(0, stringRepresentation.length());
        stringRepresentation.append(this.getManeuverClassificationColumnHeaders());
        stringRepresentation.append('\n');
        stringRepresentation.append(this.getManeuverClassificationColumnTypes());
        stringRepresentation.append('\n');
        stringRepresentation.append(this.getManeuverClassificationColumnHeaders());
        stringRepresentation.append('\n');
        int[] id = new int[1];
        clusters.map(c -> c.stream()).reduce(Stream::concat).get().forEach(i -> {
            int n = id[0];
            nArray[0] = n + 1;
            stringRepresentation.append(i.format("" + n));
            stringRepresentation.append('\n');
        });
        return stringRepresentation.toString();
    }

    protected String getManeuverClassificationColumnHeaders() {
        return "datapoint\tcompetitor\ttimePoint\tangleDeg\tboatSpeedKn\tcogDeg\tmiddleManeuverCourse\tlossM\ttackLikelihood\tjibeLikelihood";
    }

    protected String getManeuverClassificationColumnTypes() {
        return "infoitem\tstring\tdate\tfloat\tfloat\tfloat\tfloat\tfloat\tfloat\tfloat";
    }

    public Double getLikelihoodForClusterOfBeingTackCluster(Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble> cluster) {
        return this.likelihoodOfBeingTackCluster.get(cluster);
    }
}

