/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication;

import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FullyInitializedReplicableTracker<R extends Replicable<?, ?>>
extends ServiceTracker<R, R> {
    private final ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker;

    public static <R extends Replicable<?, ?>> FullyInitializedReplicableTracker<R> createAndOpen(BundleContext context, Class<R> clazz) {
        return FullyInitializedReplicableTracker.createAndOpen(context, clazz, null);
    }

    public static <R extends Replicable<?, ?>> FullyInitializedReplicableTracker<R> createAndOpen(BundleContext context, Class<R> clazz, ServiceTrackerCustomizer<R, R> customizer) {
        FullyInitializedReplicableTracker<R> result = new FullyInitializedReplicableTracker<R>(context, clazz, customizer, (ServiceTracker<ReplicationService, ReplicationService>)ServiceTrackerFactory.createAndOpen((BundleContext)context, ReplicationService.class));
        result.open();
        return result;
    }

    public FullyInitializedReplicableTracker(BundleContext context, Class<R> clazz, ServiceTrackerCustomizer<R, R> customizer, ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker) {
        super(context, clazz, customizer);
        this.replicationServiceTracker = replicationServiceTracker;
    }

    public FullyInitializedReplicableTracker(BundleContext context, Filter filter, ServiceTrackerCustomizer<R, R> customizer, ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker) {
        super(context, filter, customizer);
        this.replicationServiceTracker = replicationServiceTracker;
    }

    public FullyInitializedReplicableTracker(BundleContext context, ServiceReference<R> reference, ServiceTrackerCustomizer<R, R> customizer, ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker) {
        super(context, reference, customizer);
        this.replicationServiceTracker = replicationServiceTracker;
    }

    public FullyInitializedReplicableTracker(BundleContext context, String clazz, ServiceTrackerCustomizer<R, R> customizer, ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker) {
        super(context, clazz, customizer);
        this.replicationServiceTracker = replicationServiceTracker;
    }

    private boolean waitForReplicationToBeInitialized(long timeoutInMillis) throws InterruptedException {
        boolean result;
        if (this.replicationServiceTracker != null) {
            CountDownLatch latch = new CountDownLatch(1);
            ReplicationService replicationService = (ReplicationService)this.replicationServiceTracker.waitForService(timeoutInMillis);
            if (replicationService != null) {
                ReplicationService.ReplicationStartingListener replicationStartingListener = newIsReplicationStarting -> {
                    if (!newIsReplicationStarting) {
                        latch.countDown();
                    }
                };
                replicationService.addReplicationStartingListener(replicationStartingListener);
                if (!replicationService.isReplicationStarting()) {
                    latch.countDown();
                }
                if (timeoutInMillis == 0L) {
                    latch.await();
                    result = true;
                } else {
                    result = latch.await(timeoutInMillis, TimeUnit.MILLISECONDS);
                }
                replicationService.removeReplicationStartingListener(replicationStartingListener);
            } else {
                result = false;
            }
        } else {
            result = true;
        }
        return result;
    }

    public R getInitializedService(long timeoutInMillis) throws InterruptedException {
        Replicable service = (Replicable)this.waitForService(timeoutInMillis);
        Replicable result = service != null ? (this.waitForReplicationToBeInitialized(timeoutInMillis) ? service : null) : null;
        return (R)result;
    }
}

