/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.server.gateway.serialization.impl.DistanceJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.GPSFixJsonSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class ManeuverJsonSerializer
implements JsonSerializer<Maneuver> {
    public static final String MANEUVER_TYPE = "maneuverType";
    public static final String NEW_TACK = "newTack";
    public static final String SPEED_BEFORE_IN_KNOTS = "speedBeforeInKnots";
    public static final String COG_BEFORE_IN_TRUE_DEGREES = "cogBeforeInTrueDegrees";
    public static final String SPEED_AFTER_IN_KNOTS = "speedAfterInKnots";
    public static final String COG_AFTER_IN_TRUE_DEGREES = "cogAfterInTrueDegrees";
    public static final String DIRECTION_CHANGE_IN_DEGREES = "directionChangeInDegrees";
    public static final String MANEUVER_LOSS = "maneuverLoss";
    public static final String POSITION_AND_TIME = "positionAndTime";
    public static final String MAX_TURNING_RATE_IN_DEGREES_PER_SECOND = "maxTurningRateInDegreesPerSecond";
    public static final String AVG_TURNING_RATE_IN_DEGREES_PER_SECOND = "avgTurningRateInDegreesPerSecond";
    public static final String LOWEST_SPEED_IN_KNOTS = "lowestSpeedInKnots";
    public static final String MARK_PASSING = "markPassing";
    private final GPSFixJsonSerializer gpsFixSerializer;
    private final DistanceJsonSerializer distanceSerializer;

    public ManeuverJsonSerializer(GPSFixJsonSerializer gpsFixSerializer, DistanceJsonSerializer distanceSerializer) {
        this.gpsFixSerializer = gpsFixSerializer;
        this.distanceSerializer = distanceSerializer;
    }

    public JSONObject serialize(Maneuver maneuver) {
        JSONObject result = new JSONObject();
        result.put((Object)MANEUVER_TYPE, maneuver.getType() == null ? null : maneuver.getType().name());
        result.put((Object)NEW_TACK, maneuver.getNewTack() == null ? null : maneuver.getNewTack().name());
        result.put((Object)SPEED_BEFORE_IN_KNOTS, maneuver.getSpeedWithBearingBefore() == null ? null : Double.valueOf(maneuver.getSpeedWithBearingBefore().getKnots()));
        result.put((Object)COG_BEFORE_IN_TRUE_DEGREES, maneuver.getSpeedWithBearingBefore() == null ? null : Double.valueOf(maneuver.getSpeedWithBearingBefore().getBearing().getDegrees()));
        result.put((Object)SPEED_AFTER_IN_KNOTS, maneuver.getSpeedWithBearingAfter() == null ? null : Double.valueOf(maneuver.getSpeedWithBearingAfter().getKnots()));
        result.put((Object)COG_AFTER_IN_TRUE_DEGREES, maneuver.getSpeedWithBearingAfter() == null ? null : Double.valueOf(maneuver.getSpeedWithBearingAfter().getBearing().getDegrees()));
        result.put((Object)DIRECTION_CHANGE_IN_DEGREES, (Object)maneuver.getDirectionChangeInDegrees());
        result.put((Object)MANEUVER_LOSS, maneuver.getManeuverLoss() == null ? null : this.distanceSerializer.serialize(maneuver.getManeuverLoss().getProjectedDistanceLost()));
        result.put((Object)POSITION_AND_TIME, (Object)this.gpsFixSerializer.serialize((GPSFix)maneuver));
        result.put((Object)MAX_TURNING_RATE_IN_DEGREES_PER_SECOND, (Object)maneuver.getMaxTurningRateInDegreesPerSecond());
        result.put((Object)AVG_TURNING_RATE_IN_DEGREES_PER_SECOND, (Object)maneuver.getAvgTurningRateInDegreesPerSecond());
        result.put((Object)LOWEST_SPEED_IN_KNOTS, (Object)maneuver.getLowestSpeed().getKnots());
        result.put((Object)MARK_PASSING, (Object)maneuver.isMarkPassing());
        return result;
    }
}

