/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DataImportProgressJsonSerializer
implements JsonSerializer<DataImportProgress> {
    public static final String OVERALL_PROGRESS_PERCENT = "overallProgressPercent";
    public static final String CURRENT_SUB_PROGRESS = "currentSubProgress";
    public static final String CURRENT_SUB_PROGRESS_PERCENT = "currentSubProgressPercent";
    public static final String RESULT = "result";
    public static final String OPERATION_ID = "operationId";
    public static final String FAILED = "failed";
    public static final String ERROR_MESSAGE = "errorMessage";
    public static final String LEADERBOARD_COUNT = "leaderboardCount";
    public static final String LEADERBOARD_GROUP_COUNT = "leaderboardGroupCount";
    public static final String EVENT_COUNT = "eventCount";
    public static final String REGATTA_COUNT = "regattaCount";
    public static final String MEDIA_TRACK_COUNT = "mediaTrackCount";
    public static final String OVERWRITTEN_REGATTA_NAMES = "overwrittenRegattaNames";
    public static final String TRACKED_RACES_COUNT = "trackedRacesCount";

    public JSONObject serialize(DataImportProgress object) {
        JSONObject result = new JSONObject();
        result.put((Object)OVERALL_PROGRESS_PERCENT, (Object)object.getOverallProgressPct());
        result.put((Object)CURRENT_SUB_PROGRESS, object.getCurrentSubProgress() == null ? null : object.getCurrentSubProgress().name());
        result.put((Object)CURRENT_SUB_PROGRESS_PERCENT, (Object)object.getCurrentSubProgressPct());
        if (object.getResult() != null) {
            JSONObject counts = new JSONObject();
            result.put((Object)RESULT, (Object)counts);
            counts.put((Object)LEADERBOARD_COUNT, (Object)object.getResult().getLeaderboardCount());
            counts.put((Object)LEADERBOARD_GROUP_COUNT, (Object)object.getResult().getLeaderboardGroupCount());
            counts.put((Object)EVENT_COUNT, (Object)object.getResult().getEventCount());
            counts.put((Object)REGATTA_COUNT, (Object)object.getResult().getRegattaCount());
            counts.put((Object)MEDIA_TRACK_COUNT, (Object)object.getResult().getMediaTrackCount());
            JSONArray overwrittenRegattaNames = new JSONArray();
            if (object.getResult().getNamesOfOverwrittenRegattaNames() != null) {
                for (String overwrittenRegattaName : object.getResult().getNamesOfOverwrittenRegattaNames()) {
                    overwrittenRegattaNames.add((Object)overwrittenRegattaName);
                }
                counts.put((Object)OVERWRITTEN_REGATTA_NAMES, (Object)overwrittenRegattaNames);
            }
            counts.put((Object)TRACKED_RACES_COUNT, (Object)object.getResult().getTrackedRacesCount());
        }
        result.put((Object)OPERATION_ID, (Object)object.getOperationId().toString());
        result.put((Object)FAILED, (Object)object.failed());
        result.put((Object)ERROR_MESSAGE, (Object)object.getErrorMessage());
        return result;
    }
}

