/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.server.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.coursetemplate.CommonMarkProperties;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkPropertiesBuilder;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.Positioning;
import com.sap.sailing.domain.coursetemplate.WaypointTemplate;
import com.sap.sailing.domain.coursetemplate.impl.CommonMarkPropertiesImpl;
import com.sap.sailing.domain.coursetemplate.impl.CourseTemplateImpl;
import com.sap.sailing.domain.coursetemplate.impl.FixedPositioningImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkPropertiesImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkRoleImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkTemplateImpl;
import com.sap.sailing.domain.coursetemplate.impl.TrackingDeviceBasedPositioningImpl;
import com.sap.sailing.shared.persistence.DomainObjectFactory;
import com.sap.sailing.shared.persistence.MongoObjectFactory;
import com.sap.sailing.shared.persistence.device.DeviceIdentifierMongoHandler;
import com.sap.sailing.shared.server.impl.ReplicatingSharedSailingData;
import com.sap.sailing.shared.server.operations.CreateCourseTemplateOperation;
import com.sap.sailing.shared.server.operations.CreateMarkPropertiesOperation;
import com.sap.sailing.shared.server.operations.CreateMarkRoleOperation;
import com.sap.sailing.shared.server.operations.CreateMarkTemplateOperation;
import com.sap.sailing.shared.server.operations.DeleteCourseTemplateOperation;
import com.sap.sailing.shared.server.operations.DeleteMarkPropertiesOperation;
import com.sap.sailing.shared.server.operations.RecordUsageForMarkRoleOperation;
import com.sap.sailing.shared.server.operations.RecordUsageForMarkTemplateOperation;
import com.sap.sailing.shared.server.operations.SetPositioningInformationForMarkPropertiesOperation;
import com.sap.sailing.shared.server.operations.UpdateCourseTemplateOperation;
import com.sap.sailing.shared.server.operations.UpdateMarkPropertiesOperation;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.interfaces.impl.AbstractReplicableWithObjectInputStream;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.util.ClearStateTestSupport;
import com.sap.sse.util.ObjectInputStreamResolvingAgainstCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class SharedSailingDataImpl
extends AbstractReplicableWithObjectInputStream<ReplicatingSharedSailingData, OperationWithResult<ReplicatingSharedSailingData, ?>>
implements ReplicatingSharedSailingData,
ClearStateTestSupport {
    private final DomainObjectFactory domainObjectFactory;
    private final MongoObjectFactory mongoObjectFactory;
    private final Map<UUID, MarkProperties> markPropertiesById = new ConcurrentHashMap<UUID, MarkProperties>();
    private final Map<UUID, MarkTemplate> markTemplatesById = new ConcurrentHashMap<UUID, MarkTemplate>();
    private final Map<UUID, CourseTemplate> courseTemplatesById = new ConcurrentHashMap<UUID, CourseTemplate>();
    private final Map<UUID, MarkRole> markRolesById = new ConcurrentHashMap<UUID, MarkRole>();
    private final TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder;
    private final FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;

    public SharedSailingDataImpl(DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory, TypeBasedServiceFinderFactory serviceFinderFactory, FullyInitializedReplicableTracker<SecurityService> securityServiceTracker) {
        this.domainObjectFactory = domainObjectFactory;
        this.mongoObjectFactory = mongoObjectFactory;
        this.deviceIdentifierServiceFinder = serviceFinderFactory.createServiceFinder(DeviceIdentifierMongoHandler.class);
        this.securityServiceTracker = securityServiceTracker;
        this.load();
    }

    private void load() {
        this.domainObjectFactory.loadAllMarkTemplates().forEach(m -> {
            MarkTemplate markTemplate = this.markTemplatesById.put(m.getId(), (MarkTemplate)m);
        });
        this.domainObjectFactory.loadAllMarkRoles().forEach(m -> {
            MarkRole markRole = this.markRolesById.put(m.getId(), (MarkRole)m);
        });
        this.domainObjectFactory.loadAllMarkProperties(this.markTemplatesById::get, this.markRolesById::get).forEach(m -> {
            MarkProperties markProperties = this.markPropertiesById.put(m.getId(), (MarkProperties)m);
        });
        this.domainObjectFactory.loadAllCourseTemplates(this.markTemplatesById::get, this.markRolesById::get).forEach(c -> {
            CourseTemplate courseTemplate = this.courseTemplatesById.put(c.getId(), (CourseTemplate)c);
        });
    }

    public void clearState() throws Exception {
        this.markPropertiesById.keySet().forEach(arg_0 -> ((MongoObjectFactory)this.mongoObjectFactory).removeMarkProperties(arg_0));
        this.markTemplatesById.keySet().forEach(arg_0 -> ((MongoObjectFactory)this.mongoObjectFactory).removeMarkTemplate(arg_0));
        this.courseTemplatesById.keySet().forEach(arg_0 -> ((MongoObjectFactory)this.mongoObjectFactory).removeCourseTemplate(arg_0));
        this.markRolesById.keySet().forEach(arg_0 -> ((MongoObjectFactory)this.mongoObjectFactory).removeMarkRole(arg_0));
        this.removeAll();
    }

    private void removeAll() {
        this.markPropertiesById.clear();
        this.markTemplatesById.clear();
        this.courseTemplatesById.clear();
        this.markRolesById.clear();
    }

    public SecurityService getSecurityService() {
        try {
            return (SecurityService)this.securityServiceTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<MarkProperties> getAllMarkProperties(Iterable<String> tagsToFilterFor) {
        return this.markPropertiesById.values().stream().filter(m -> this.containsAny(m.getTags(), tagsToFilterFor)).filter(arg_0 -> ((SecurityService)this.getSecurityService()).hasCurrentUserReadPermission(arg_0)).collect(Collectors.toList());
    }

    private <T> boolean containsAny(Iterable<T> iterable, Iterable<T> search) {
        if (Util.isEmpty(search)) {
            return true;
        }
        for (T t : search) {
            if (!Util.contains(iterable, t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<MarkTemplate> getAllMarkTemplates() {
        return this.markTemplatesById.values().stream().filter(arg_0 -> ((SecurityService)this.getSecurityService()).hasCurrentUserReadPermission(arg_0)).collect(Collectors.toList());
    }

    @Override
    public Iterable<CourseTemplate> getAllCourseTemplates(Iterable<String> tagsToFilterFor) {
        return this.courseTemplatesById.values().stream().filter(c -> this.containsAny(c.getTags(), tagsToFilterFor)).filter(arg_0 -> ((SecurityService)this.getSecurityService()).hasCurrentUserReadPermission(arg_0)).collect(Collectors.toList());
    }

    @Override
    public Iterable<CourseTemplate> getAllCourseTemplates() {
        return this.courseTemplatesById.values().stream().filter(arg_0 -> ((SecurityService)this.getSecurityService()).hasCurrentUserReadPermission(arg_0)).collect(Collectors.toList());
    }

    @Override
    public Iterable<MarkProperties> getAllMarkProperties() {
        return this.markPropertiesById.values().stream().filter(arg_0 -> ((SecurityService)this.getSecurityService()).hasCurrentUserReadPermission(arg_0)).collect(Collectors.toList());
    }

    @Override
    public Iterable<MarkRole> getAllMarkRoles() {
        return this.markRolesById.values().stream().filter(arg_0 -> ((SecurityService)this.getSecurityService()).hasCurrentUserReadPermission(arg_0)).collect(Collectors.toList());
    }

    @Override
    public MarkRole createMarkRole(String name, String shortName) {
        UUID idOfNewMarkRole = UUID.randomUUID();
        this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.MARK_ROLE, MarkRole.getTypeRelativeObjectIdentifier((UUID)idOfNewMarkRole), idOfNewMarkRole + "/" + name, () -> {
            UUID idOfNewMarkRoleForReplication = idOfNewMarkRole;
            String nameForReplication = name;
            this.apply(new CreateMarkRoleOperation(idOfNewMarkRoleForReplication, nameForReplication, shortName));
        });
        return this.getMarkRoleById(idOfNewMarkRole);
    }

    @Override
    public Void internalCreateMarkRole(UUID idOfNewMarkRole, String name, String shortName) {
        MarkRoleImpl markRole = new MarkRoleImpl(idOfNewMarkRole, name, shortName);
        this.mongoObjectFactory.storeMarkRole((MarkRole)markRole);
        this.markRolesById.put(markRole.getId(), (MarkRole)markRole);
        return null;
    }

    @Override
    public MarkRole getMarkRoleById(UUID id) {
        if (id == null) {
            return null;
        }
        MarkRole markRole = this.markRolesById.get(id);
        if (markRole != null) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)markRole);
        }
        return markRole;
    }

    @Override
    public MarkProperties createMarkProperties(CommonMarkProperties properties, Iterable<String> tags, Optional<UserGroup> optionalNonDefaultGroupOwnership) {
        UUID idOfNewMarkProperties = UUID.randomUUID();
        optionalNonDefaultGroupOwnership.ifPresent(userGroup -> {
            Ownership ownership = this.getSecurityService().setOwnership(SecuredDomainType.MARK_PROPERTIES.getQualifiedObjectIdentifier(MarkProperties.getTypeRelativeObjectIdentifier((UUID)idOfNewMarkProperties)), this.getSecurityService().getCurrentUser(), userGroup);
        });
        this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.MARK_PROPERTIES, MarkProperties.getTypeRelativeObjectIdentifier((UUID)idOfNewMarkProperties), idOfNewMarkProperties + "/" + properties.getName(), () -> {
            UUID idOfNewMarkPropertiesForReplication = idOfNewMarkProperties;
            CommonMarkPropertiesImpl propertiesForReplication = new CommonMarkPropertiesImpl(properties);
            Iterable tagsForReplication = tags;
            this.apply(new CreateMarkPropertiesOperation(idOfNewMarkPropertiesForReplication, (CommonMarkProperties)propertiesForReplication, tagsForReplication));
        });
        return this.getMarkPropertiesById(idOfNewMarkProperties);
    }

    @Override
    public MarkProperties updateMarkProperties(UUID uuid, CommonMarkProperties properties, Positioning positioningInformation, Iterable<String> tags) {
        MarkProperties markProperties = this.updateMarkProperties(uuid, properties, tags);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)markProperties);
        if (positioningInformation != null && markProperties != properties) {
            this.apply(new SetPositioningInformationForMarkPropertiesOperation(uuid, positioningInformation));
        }
        return this.getMarkPropertiesById(uuid);
    }

    @Override
    public MarkProperties updateMarkProperties(UUID uuid, CommonMarkProperties properties, Iterable<String> tags) {
        MarkProperties markProperties = this.markPropertiesById.get(uuid);
        if (markProperties == null) {
            throw new NullPointerException(String.format("Could not find mark properties with id %s", uuid.toString()));
        }
        if (markProperties != properties) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)markProperties);
            CommonMarkPropertiesImpl commonMarkPropertiesForSerialization = new CommonMarkPropertiesImpl(properties);
            this.apply(new UpdateMarkPropertiesOperation(uuid, (CommonMarkProperties)commonMarkPropertiesForSerialization, tags));
        }
        return this.getMarkPropertiesById(uuid);
    }

    @Override
    public Void internalUpdateMarkProperties(UUID idOfMarkProperties, CommonMarkProperties properties, Iterable<String> tags) {
        MarkPropertiesImpl markProperties = (MarkPropertiesImpl)this.markPropertiesById.get(idOfMarkProperties);
        if (markProperties != properties) {
            markProperties.setName(properties.getName());
            markProperties.setColor(properties.getColor());
            markProperties.setPattern(properties.getPattern());
            markProperties.setShape(properties.getShape());
            markProperties.setShortName(properties.getShortName());
            markProperties.setType(properties.getType());
            markProperties.setTags(tags);
            this.mongoObjectFactory.storeMarkProperties(this.deviceIdentifierServiceFinder, (MarkProperties)markProperties);
            this.markPropertiesById.put(idOfMarkProperties, (MarkProperties)markProperties);
        }
        return null;
    }

    @Override
    public Void internalCreateMarkProperties(UUID idOfNewMarkProperties, CommonMarkProperties properties, Iterable<String> tags) {
        MarkProperties markProperties = new MarkPropertiesBuilder(idOfNewMarkProperties, properties.getName(), properties.getShortName(), properties.getColor(), properties.getShape(), properties.getPattern(), properties.getType()).withTags(tags).build();
        this.mongoObjectFactory.storeMarkProperties(this.deviceIdentifierServiceFinder, markProperties);
        this.markPropertiesById.put(markProperties.getId(), markProperties);
        return null;
    }

    @Override
    public void clearPositioningForMarkProperties(MarkProperties markProperties) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)markProperties);
        UUID markPropertiesUUID = markProperties.getId();
        this.apply(new SetPositioningInformationForMarkPropertiesOperation(markPropertiesUUID, null));
    }

    @Override
    public void setFixedPositionForMarkProperties(MarkProperties markProperties, Position position) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)markProperties);
        UUID markPropertiesUUID = markProperties.getId();
        this.apply(new SetPositioningInformationForMarkPropertiesOperation(markPropertiesUUID, (Positioning)new FixedPositioningImpl(position)));
    }

    @Override
    public MarkProperties getMarkPropertiesById(UUID id) {
        MarkProperties markProperties;
        if (id == null) {
            markProperties = null;
        } else {
            markProperties = this.markPropertiesById.get(id);
            if (markProperties != null) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)markProperties);
            }
        }
        return markProperties;
    }

    @Override
    public void setTrackingDeviceIdentifierForMarkProperties(MarkProperties markProperties, DeviceIdentifier deviceIdentifier) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)markProperties);
        UUID markPropertiesUUID = markProperties.getId();
        this.apply(new SetPositioningInformationForMarkPropertiesOperation(markPropertiesUUID, (Positioning)new TrackingDeviceBasedPositioningImpl(deviceIdentifier)));
    }

    @Override
    public Void internalSetPositioningInformationForMarkProperties(UUID markPropertiesId, Positioning positioningInformation) {
        MarkProperties markProperties = this.markPropertiesById.get(markPropertiesId);
        if (markProperties == null) {
            logger.warning("Could not find mark properties for ID " + markPropertiesId + "; not setting positioning information");
        } else {
            markProperties.setPositioningInformation(positioningInformation);
            this.mongoObjectFactory.storeMarkProperties(this.deviceIdentifierServiceFinder, markProperties);
        }
        return null;
    }

    @Override
    public MarkTemplate createMarkTemplate(CommonMarkProperties properties) {
        UUID idOfNewMarkTemplate = UUID.randomUUID();
        this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.MARK_TEMPLATE, MarkTemplate.getTypeRelativeObjectIdentifier((UUID)idOfNewMarkTemplate), idOfNewMarkTemplate + "/" + properties.getName(), () -> {
            UUID idOfNewMarkTemplateForReplication = idOfNewMarkTemplate;
            CommonMarkPropertiesImpl propertiesForReplication = new CommonMarkPropertiesImpl(properties);
            this.apply(new CreateMarkTemplateOperation(idOfNewMarkTemplateForReplication, (CommonMarkProperties)propertiesForReplication));
        });
        return this.getMarkTemplateById(idOfNewMarkTemplate);
    }

    @Override
    public Void internalCreateMarkTemplate(UUID idOfNewMarkTemplate, CommonMarkProperties properties) {
        MarkTemplateImpl markTemplate = new MarkTemplateImpl(idOfNewMarkTemplate, properties);
        this.mongoObjectFactory.storeMarkTemplate((MarkTemplate)markTemplate);
        this.markTemplatesById.put(markTemplate.getId(), (MarkTemplate)markTemplate);
        return null;
    }

    @Override
    public MarkTemplate getMarkTemplateById(UUID id) {
        MarkTemplate markTemplate = this.markTemplatesById.get(id);
        if (markTemplate != null) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)markTemplate);
        }
        return markTemplate;
    }

    @Override
    public CourseTemplate createCourseTemplate(String courseTemplateName, String courseTemplateShortName, Iterable<MarkTemplate> marks, Iterable<WaypointTemplate> waypoints, Map<MarkTemplate, MarkRole> defaultRolesForMarkTemplates, Map<MarkRole, MarkTemplate> defaultMarkTemplatesForMarkRoles, RepeatablePart optionalRepeatablePart, Iterable<String> tags, URL optionalImageURL, Integer defaultNumberOfLaps) {
        HashSet<MarkRole> rolesAlreadyChecked = new HashSet<MarkRole>();
        for (WaypointTemplate waypoint : waypoints) {
            for (MarkRole markRole : waypoint.getControlPointTemplate().getMarkRoles()) {
                if (rolesAlreadyChecked.contains(markRole)) continue;
                if (!defaultMarkTemplatesForMarkRoles.containsKey(markRole)) {
                    throw new IllegalArgumentException("All mark roles contained in the sequence are expected to have a mapping to a mark template");
                }
                MarkTemplate mark = defaultMarkTemplatesForMarkRoles.get(markRole);
                if (!Util.contains(marks, (Object)mark)) {
                    throw new IllegalArgumentException("All marks contained in the sequence are expected to be part of the course template");
                }
                rolesAlreadyChecked.add(markRole);
            }
        }
        UUID idOfNewCourseTemplate = UUID.randomUUID();
        this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.COURSE_TEMPLATE, CourseTemplate.getTypeRelativeObjectIdentifier((UUID)idOfNewCourseTemplate), idOfNewCourseTemplate + "/" + courseTemplateName, () -> {
            UUID idOfNewCourseTemplateForReplication = idOfNewCourseTemplate;
            String courseTemplateNameForReplication = courseTemplateName;
            Iterable marksForReplication = marks;
            Iterable waypointsForReplication = waypoints;
            Map effectiveAssociatedRolesForReplication = defaultRolesForMarkTemplates;
            RepeatablePart optionalRepeatablePartForReplication = optionalRepeatablePart;
            Iterable tagsForReplication = tags;
            URL optionalImageURLForReplication = optionalImageURL;
            Integer defaultNumberOfLapsForReplication = defaultNumberOfLaps;
            this.apply(new CreateCourseTemplateOperation(idOfNewCourseTemplateForReplication, courseTemplateNameForReplication, courseTemplateShortName, marksForReplication, waypointsForReplication, effectiveAssociatedRolesForReplication, defaultMarkTemplatesForMarkRoles, optionalRepeatablePartForReplication, tagsForReplication, optionalImageURLForReplication, defaultNumberOfLapsForReplication));
        });
        return this.getCourseTemplateById(idOfNewCourseTemplate);
    }

    @Override
    public CourseTemplate updateCourseTemplate(UUID uuid, String name, String shortName, URL optionalImageURL, ArrayList<String> tags, Integer defaultNumberOfLaps) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.courseTemplatesById.get(uuid));
        this.apply(new UpdateCourseTemplateOperation(uuid, name, shortName, optionalImageURL, tags, defaultNumberOfLaps));
        return this.getCourseTemplateById(uuid);
    }

    @Override
    public Void internalUpdateCourseTemplate(UUID uuid, String name, String shortName, URL optionalImageURL, ArrayList<String> tags, Integer defaultNumberOfLaps) {
        CourseTemplate existingCourseTemplate = this.courseTemplatesById.get(uuid);
        CourseTemplateImpl courseTemplate = new CourseTemplateImpl(uuid, name, shortName, existingCourseTemplate.getMarkTemplates(), existingCourseTemplate.getWaypointTemplates(), existingCourseTemplate.getDefaultMarkTemplatesForMarkRoles(), existingCourseTemplate.getDefaultMarkRolesForMarkTemplates(), optionalImageURL, existingCourseTemplate.getRepeatablePart(), defaultNumberOfLaps);
        courseTemplate.setTags(tags);
        this.mongoObjectFactory.storeCourseTemplate((CourseTemplate)courseTemplate);
        this.courseTemplatesById.put(courseTemplate.getId(), (CourseTemplate)courseTemplate);
        return null;
    }

    @Override
    public Void internalCreateCourseTemplate(UUID idOfNewCourseTemplate, String courseTemplateName, String courseTemplateShortName, Iterable<MarkTemplate> marks, Iterable<WaypointTemplate> waypoints, Map<MarkTemplate, MarkRole> defaultMarkRolesForMarkTemplates, Map<MarkRole, MarkTemplate> defaultMarkTemplatesForMarkRoles, RepeatablePart optionalRepeatablePart, Iterable<String> tags, URL optionalImageURL, Integer defaultNumberOfLaps) {
        CourseTemplateImpl courseTemplate = new CourseTemplateImpl(idOfNewCourseTemplate, courseTemplateName, courseTemplateShortName, marks, waypoints, defaultMarkTemplatesForMarkRoles, defaultMarkRolesForMarkTemplates, optionalImageURL, optionalRepeatablePart, defaultNumberOfLaps);
        courseTemplate.setTags(tags);
        this.mongoObjectFactory.storeCourseTemplate((CourseTemplate)courseTemplate);
        this.courseTemplatesById.put(courseTemplate.getId(), (CourseTemplate)courseTemplate);
        return null;
    }

    @Override
    public CourseTemplate getCourseTemplateById(UUID id) {
        CourseTemplate courseTemplate = this.courseTemplatesById.get(id);
        if (courseTemplate != null) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)courseTemplate);
        }
        return courseTemplate;
    }

    @Override
    public Void internalRecordUsage(UUID markTemplateId, UUID markPropertiesId) {
        MarkProperties markProperties = this.markPropertiesById.get(markPropertiesId);
        MarkTemplate markTemplate = this.markTemplatesById.get(markTemplateId);
        markProperties.addMarkTemplateUsage(markTemplate, MillisecondsTimePoint.now());
        this.mongoObjectFactory.storeMarkProperties(this.deviceIdentifierServiceFinder, markProperties);
        return null;
    }

    @Override
    public void recordUsage(MarkTemplate markTemplate, MarkProperties markProperties) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)markProperties);
        UUID markPropertiesId = markProperties.getId();
        UUID markTemplateId = markTemplate.getId();
        this.apply(new RecordUsageForMarkTemplateOperation(markTemplateId, markPropertiesId));
    }

    @Override
    public Void internalRecordUsage(UUID markPropertiesId, MarkRole markRole) {
        MarkProperties markProperties = this.markPropertiesById.get(markPropertiesId);
        markProperties.addMarkRoleUsage(markRole, MillisecondsTimePoint.now());
        this.mongoObjectFactory.storeMarkProperties(this.deviceIdentifierServiceFinder, markProperties);
        return null;
    }

    @Override
    public void recordUsage(MarkProperties markProperties, MarkRole markRole) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)markProperties);
        UUID markPropertiesId = markProperties.getId();
        this.apply(new RecordUsageForMarkRoleOperation(markPropertiesId, markRole));
    }

    @Override
    public Map<MarkProperties, TimePoint> getUsedMarkProperties(MarkTemplate markTemplate) {
        HashMap<MarkProperties, TimePoint> recordedUsage = new HashMap<MarkProperties, TimePoint>();
        for (MarkProperties mp : this.markPropertiesById.values()) {
            if (!mp.getLastUsedMarkTemplate().containsKey(markTemplate)) continue;
            recordedUsage.put(mp, (TimePoint)mp.getLastUsedMarkTemplate().get(markTemplate));
        }
        return recordedUsage;
    }

    @Override
    public Map<MarkProperties, TimePoint> getUsedMarkProperties(MarkRole roleName) {
        HashMap<MarkProperties, TimePoint> recordedUsage = new HashMap<MarkProperties, TimePoint>();
        for (MarkProperties mp : this.markPropertiesById.values()) {
            if (!mp.getLastUsedMarkRole().containsKey(roleName)) continue;
            recordedUsage.put(mp, (TimePoint)mp.getLastUsedMarkRole().get(roleName));
        }
        return recordedUsage;
    }

    @Override
    public void deleteMarkProperties(MarkProperties markProperties) {
        UUID id = markProperties.getId();
        this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)markProperties, () -> this.apply(new DeleteMarkPropertiesOperation(id)));
    }

    @Override
    public Void internalDeleteMarkProperties(UUID markPropertiesUUID) {
        if (this.markPropertiesById.remove(markPropertiesUUID) == null) {
            throw new NullPointerException(String.format("Did not find a mark properties with ID %s", markPropertiesUUID));
        }
        this.mongoObjectFactory.removeMarkProperties(markPropertiesUUID);
        return null;
    }

    @Override
    public void deleteCourseTemplate(CourseTemplate courseTemplate) {
        UUID id = courseTemplate.getId();
        this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)courseTemplate, () -> this.apply(new DeleteCourseTemplateOperation(id)));
    }

    @Override
    public Void internalDeleteCourseTemplate(UUID courseTemplateUUID) {
        if (this.courseTemplatesById.remove(courseTemplateUUID) == null) {
            throw new NullPointerException(String.format("Did not find a course template with ID %s", courseTemplateUUID));
        }
        this.mongoObjectFactory.removeCourseTemplate(courseTemplateUUID);
        return null;
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        return new ObjectInputStreamResolvingAgainstCache<MarkTemplate.MarkTemplateResolver>(is, mt -> this.markTemplatesById.computeIfAbsent(mt.getId(), id -> mt), null, classLoaderCache){};
    }

    public synchronized void initiallyFillFromInternal(ObjectInputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        this.markTemplatesById.putAll((Map)is.readObject());
        this.markRolesById.putAll((Map)is.readObject());
        this.markPropertiesById.putAll((Map)is.readObject());
        this.courseTemplatesById.putAll((Map)is.readObject());
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.markTemplatesById);
        objectOutputStream.writeObject(this.markRolesById);
        objectOutputStream.writeObject(this.markPropertiesById);
        objectOutputStream.writeObject(this.courseTemplatesById);
    }

    public synchronized void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
        this.removeAll();
    }
}

