/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRaceOperation;
import java.util.logging.Logger;

public class UpdateWindAveragingTime
extends AbstractRaceOperation<Void> {
    private static final long serialVersionUID = -3143003305202654846L;
    private static final Logger logger = Logger.getLogger(UpdateWindAveragingTime.class.getName());
    private final long newMillisecondsOverWhichToAverageWind;

    public UpdateWindAveragingTime(RegattaAndRaceIdentifier raceIdentifier, long newMillisecondsOverWhichToAverageWind) {
        super(raceIdentifier);
        this.newMillisecondsOverWhichToAverageWind = newMillisecondsOverWhichToAverageWind;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        DynamicTrackedRace trackedRace = toState.getExistingTrackedRace(this.getRaceIdentifier());
        if (trackedRace != null) {
            trackedRace.setMillisecondsOverWhichToAverageWind(this.newMillisecondsOverWhichToAverageWind);
        } else {
            logger.warning("Tracked race for " + this.getRaceIdentifier() + " has disappeared");
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

