/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardColumnOperation;
import java.util.logging.Logger;

public class ConnectTrackedRaceToLeaderboardColumn
extends AbstractLeaderboardColumnOperation<Boolean> {
    private static final Logger logger = Logger.getLogger(ConnectTrackedRaceToLeaderboardColumn.class.getName());
    private static final long serialVersionUID = -1336511401516212508L;
    private final RegattaAndRaceIdentifier raceToConnect;
    private final String fleetName;

    public ConnectTrackedRaceToLeaderboardColumn(String leaderboardName, String columnName, String fleetName, RegattaAndRaceIdentifier raceToConnect) {
        super(leaderboardName, columnName);
        this.raceToConnect = raceToConnect;
        this.fleetName = fleetName;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    public Boolean internalApplyTo(RacingEventService toState) {
        boolean success = false;
        Leaderboard leaderboard = toState.getLeaderboardByName(this.getLeaderboardName());
        if (leaderboard != null) {
            RaceColumn raceColumn = leaderboard.getRaceColumnByName(this.getColumnName());
            if (raceColumn != null) {
                DynamicTrackedRace trackedRace = toState.getExistingTrackedRace(this.raceToConnect);
                if (trackedRace != null) {
                    raceColumn.setTrackedRace(raceColumn.getFleetByName(this.fleetName), (TrackedRace)trackedRace);
                } else {
                    raceColumn.setRaceIdentifier(raceColumn.getFleetByName(this.fleetName), (RaceIdentifier)this.raceToConnect);
                }
                success = true;
                this.updateDB(toState, leaderboard, raceColumn);
            } else {
                String leaderboardAsString = String.valueOf(leaderboard.getName()) + (leaderboard instanceof RegattaLeaderboard ? " for regatta " + ((RegattaLeaderboard)leaderboard).getRegatta().getName() + " (" + ((RegattaLeaderboard)leaderboard).getRegatta().hashCode() + ")" : "");
                logger.info("unable to find race column " + this.getColumnName() + " in leaderboard " + leaderboardAsString);
            }
        } else {
            logger.info("unable to find leaderboard " + this.getLeaderboardName() + " in server " + toState);
        }
        return success;
    }
}

