/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LastEventOfTypeFinder;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogCourseDesignChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogDenoteForTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogStartTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RaceLogTrackingStateAnalyzer;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogDenoteForTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogStartTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDefineMarkEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceMarkMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDefinedMarkAnalyzer;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDeviceMarkMappingFinder;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.MailInvitationType;
import com.sap.sailing.domain.common.NotFoundException;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.common.racelog.tracking.CompetitorRegistrationOnRaceLogDisabledException;
import com.sap.sailing.domain.common.racelog.tracking.DeviceMappingConstants;
import com.sap.sailing.domain.common.racelog.tracking.NotDenotableForRaceLogTrackingException;
import com.sap.sailing.domain.common.racelog.tracking.NotDenotedForRaceLogTrackingException;
import com.sap.sailing.domain.common.racelog.tracking.RaceLogRaceTrackerExistsException;
import com.sap.sailing.domain.common.racelog.tracking.RaceLogTrackingState;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.racelogtracking.DeviceMappingWithRegattaLogEvent;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapter;
import com.sap.sailing.domain.racelogtracking.impl.Activator;
import com.sap.sailing.domain.racelogtracking.impl.BranchIORaceLogTrackingInvitationMailBuilder;
import com.sap.sailing.domain.racelogtracking.impl.LegacyRaceLogTrackingInvitationMailBuilder;
import com.sap.sailing.domain.racelogtracking.impl.PingDeviceIdentifierImpl;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogConnectivityParams;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogTrackingI18n;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogTrackingInvitationMailBuilder;
import com.sap.sailing.domain.regattalike.LeaderboardThatHasRegattaLike;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.mail.MailException;
import com.sap.sse.common.util.UrlHelper;
import com.sap.sse.mail.MailService;
import com.sap.sse.shared.util.impl.NonGwtUrlHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import javax.mail.MessagingException;
import org.osgi.framework.ServiceReference;

public class RaceLogTrackingAdapterImpl
implements RaceLogTrackingAdapter {
    private static final Logger logger = Logger.getLogger(RaceLogTrackingAdapterImpl.class.getName());
    private final DomainFactory domainFactory;
    private final long delayToLiveInMillis;

    public RaceLogTrackingAdapterImpl(DomainFactory domainFactory) {
        this.domainFactory = domainFactory;
        this.delayToLiveInMillis = 5000L;
    }

    @Override
    public RaceHandle startTracking(RacingEventService service, Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, boolean trackWind, boolean correctWindDirectionByMagneticDeclination, RaceTrackingHandler raceTrackingHandler) throws NotDenotedForRaceLogTrackingException, Exception {
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        RaceLogTrackingState raceLogTrackingState = (RaceLogTrackingState)new RaceLogTrackingStateAnalyzer(raceLog).analyze();
        if (!raceLogTrackingState.isForTracking()) {
            throw new NotDenotedForRaceLogTrackingException();
        }
        RegattaIdentifier regatta = ((RegattaLeaderboard)leaderboard).getRegatta().getRegattaIdentifier();
        if (raceLogTrackingState != RaceLogTrackingState.TRACKING) {
            RaceLogStartTrackingEventImpl event = new RaceLogStartTrackingEventImpl(MillisecondsTimePoint.now(), service.getServerAuthor(), raceLog.getCurrentPassId());
            raceLog.add((AbstractLogEvent)event);
        }
        RaceHandle result = !this.isRaceLogRaceTrackerAttached(service, raceLog) ? this.addTracker(service, regatta, leaderboard, raceColumn, fleet, -1L, trackWind, correctWindDirectionByMagneticDeclination, raceTrackingHandler) : null;
        return result;
    }

    private RaceHandle addTracker(RacingEventService service, RegattaIdentifier regattaToAddTo, Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, long timeoutInMilliseconds, boolean trackWind, boolean correctWindDirectionByMagneticDeclination, RaceTrackingHandler raceTrackingHandler) throws RaceLogRaceTrackerExistsException, Exception {
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        assert (!this.isRaceLogRaceTrackerAttached(service, raceLog)) : new RaceLogRaceTrackerExistsException(String.valueOf(leaderboard.getName()) + " - " + raceColumn.getName() + " - " + fleet.getName());
        Regatta regatta = regattaToAddTo == null ? null : service.getRegatta(regattaToAddTo);
        RaceLogConnectivityParams params = new RaceLogConnectivityParams(service.getServerAuthor(), regatta, raceColumn, fleet, leaderboard, this.delayToLiveInMillis, this.domainFactory, trackWind, correctWindDirectionByMagneticDeclination);
        return service.addRace(regattaToAddTo, (RaceTrackingConnectivityParameters)params, timeoutInMilliseconds, raceTrackingHandler);
    }

    @Override
    public boolean denoteRaceForRaceLogTracking(RacingEventService service, Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, String raceName) throws NotDenotableForRaceLogTrackingException {
        boolean result;
        RaceLog raceLog;
        BoatClass boatClass;
        if (leaderboard instanceof RegattaLeaderboard) {
            RegattaLeaderboard rLeaderboard = (RegattaLeaderboard)leaderboard;
            boatClass = rLeaderboard.getRegatta().getBoatClass();
        } else if (!Util.isEmpty(raceColumn.getAllCompetitorsAndTheirBoats(fleet).values())) {
            boatClass = this.findDominatingBoatClass(raceColumn.getAllCompetitorsAndTheirBoats(fleet).values());
        } else if (!Util.isEmpty(raceColumn.getAllCompetitorsAndTheirBoats().values())) {
            boatClass = this.findDominatingBoatClass(raceColumn.getAllCompetitorsAndTheirBoats().values());
        } else if (!Util.isEmpty((Iterable)leaderboard.getAllCompetitors())) {
            boatClass = leaderboard.getBoatClass();
        } else {
            throw new NotDenotableForRaceLogTrackingException("Couldn't infer boat class, no competitors on race and leaderboard");
        }
        if (raceName == null) {
            raceName = String.valueOf(leaderboard.getName()) + " " + raceColumn.getName() + " " + fleet.getName();
        }
        if ((raceLog = raceColumn.getRaceLog(fleet)) == null) {
            throw new NotDenotableForRaceLogTrackingException("No RaceLog found in place");
        }
        if (((RaceLogTrackingState)new RaceLogTrackingStateAnalyzer(raceLog).analyze()).isForTracking()) {
            result = false;
        } else {
            RaceLogDenoteForTrackingEventImpl event = new RaceLogDenoteForTrackingEventImpl(MillisecondsTimePoint.now(), service.getServerAuthor(), raceLog.getCurrentPassId(), raceName, boatClass, (Serializable)UUID.randomUUID());
            raceLog.add((AbstractLogEvent)event);
            result = true;
        }
        return result;
    }

    private BoatClass findDominatingBoatClass(Iterable<Boat> allBoats) {
        return (BoatClass)Util.getDominantObject(() -> StreamSupport.stream(allBoats.spliterator(), false).map(b -> b.getBoatClass()).iterator());
    }

    @Override
    public void denoteAllRacesForRaceLogTracking(RacingEventService service, Leaderboard leaderboard, String prefix) throws NotDenotableForRaceLogTrackingException {
        int fleetcount = 1;
        for (RaceColumn column : leaderboard.getRaceColumns()) {
            for (Fleet fleet : column.getFleets()) {
                if (prefix != null) {
                    this.denoteRaceForRaceLogTracking(service, leaderboard, column, fleet, String.valueOf(prefix) + fleetcount);
                } else {
                    this.denoteRaceForRaceLogTracking(service, leaderboard, column, fleet, null);
                }
                ++fleetcount;
            }
        }
    }

    @Override
    public boolean isRaceLogRaceTrackerAttached(RacingEventService service, RaceLog raceLog) {
        return service.getRaceTrackerById((Object)raceLog.getId()) != null;
    }

    @Override
    public RaceLogTrackingState getRaceLogTrackingState(RacingEventService service, RaceColumn raceColumn, Fleet fleet) {
        return (RaceLogTrackingState)new RaceLogTrackingStateAnalyzer(raceColumn.getRaceLog(fleet)).analyze();
    }

    @Override
    public void copyCourse(RaceLog fromRaceLog, LeaderboardThatHasRegattaLike fromLeaderboard, Set<RaceLog> toRaceLogs, LeaderboardThatHasRegattaLike toLeaderboard, boolean copyMarkDeviceMappings, SharedDomainFactory<?> baseDomainFactory, RacingEventService service, int priority) {
        CourseBase course = (CourseBase)new LastPublishedCourseDesignFinder(fromRaceLog, true).analyze();
        HashSet marks = new HashSet();
        if (course != null) {
            course.getWaypoints().forEach(wp -> {
                Collection collection = Util.addAll((Iterable)wp.getMarks(), (Collection)marks);
            });
        }
        RegattaLog toLeaderboardRegattaLog = toLeaderboard.getRegattaLike().getRegattaLog();
        Collection marksAlreadyDefinedInTarget = (Collection)new RegattaLogDefinedMarkAnalyzer(toLeaderboardRegattaLog).analyze();
        for (Mark mark : marks) {
            if (marksAlreadyDefinedInTarget.contains(mark)) continue;
            toLeaderboardRegattaLog.add((AbstractLogEvent)new RegattaLogDefineMarkEventImpl(TimePoint.now(), service.getServerAuthor(), TimePoint.now(), (Serializable)UUID.randomUUID(), mark));
        }
        if (copyMarkDeviceMappings) {
            for (Map.Entry entry : ((Map)new RegattaLogDeviceMarkMappingFinder(fromLeaderboard.getRegattaLike().getRegattaLog()).analyze()).entrySet()) {
                for (DeviceMappingWithRegattaLogEvent markDeviceMappingWithRegattaLogEvent : (List)entry.getValue()) {
                    toLeaderboardRegattaLog.add((AbstractLogEvent)markDeviceMappingWithRegattaLogEvent.getRegattaLogEvent());
                }
            }
        }
        for (RaceLog raceLog : toRaceLogs) {
            if (!((RaceLogTrackingState)new RaceLogTrackingStateAnalyzer(raceLog).analyze()).isForTracking() || course == null) continue;
            CourseDataImpl newCourse = new CourseDataImpl(course.getName(), course.getOriginatingCourseTemplateIdOrNull());
            TimePoint now = MillisecondsTimePoint.now();
            int i = 0;
            for (Waypoint oldWaypoint : course.getWaypoints()) {
                newCourse.addWaypoint(i++, oldWaypoint);
            }
            int passId = raceLog.getCurrentPassId();
            RaceLogCourseDesignChangedEventImpl newCourseEvent = new RaceLogCourseDesignChangedEventImpl(now, (AbstractLogEventAuthor)new LogEventAuthorImpl(service.getServerAuthor().getName(), priority), passId, (CourseBase)newCourse, CourseDesignerMode.ADMIN_CONSOLE);
            raceLog.add((AbstractLogEvent)newCourseEvent);
        }
    }

    @Override
    public void copyCompetitors(RaceColumn fromRaceColumn, Fleet fromFleet, Iterable<Util.Pair<RaceColumn, Fleet>> toRaces) {
        Map competitorsAndBoatsToCopy = fromRaceColumn.getAllCompetitorsAndTheirBoats(fromFleet);
        for (Util.Pair<RaceColumn, Fleet> toRace : toRaces) {
            RaceColumn toRaceColumn = (RaceColumn)toRace.getA();
            Fleet toFleet = (Fleet)toRace.getB();
            try {
                if (toRaceColumn.isCompetitorRegistrationInRacelogEnabled(toFleet)) {
                    toRaceColumn.registerCompetitors(competitorsAndBoatsToCopy, toFleet);
                    continue;
                }
                toRaceColumn.enableCompetitorRegistrationOnRaceLog(toFleet);
                toRaceColumn.registerCompetitors(competitorsAndBoatsToCopy, toFleet);
            }
            catch (CompetitorRegistrationOnRaceLogDisabledException e1) {
                logger.log(Level.WARNING, "Internal error: race column " + toRaceColumn.getName() + " does not accept competitor registration although it should", e1);
            }
        }
    }

    @Override
    public void pingMark(RegattaLog log, Mark mark, GPSFix gpsFix, RacingEventService service) {
        PingDeviceIdentifierImpl device = new PingDeviceIdentifierImpl();
        TimePoint timePoint = gpsFix.getTimePoint();
        TimePoint now = MillisecondsTimePoint.now();
        RegattaLogDeviceMarkMappingEventImpl mapping = new RegattaLogDeviceMarkMappingEventImpl(now, now, service.getServerAuthor(), (Serializable)UUID.randomUUID(), mark, (DeviceIdentifier)device, timePoint, timePoint);
        log.add((AbstractLogEvent)mapping);
        try {
            service.getSensorFixStore().storeFix((DeviceIdentifier)device, (Timed)gpsFix);
        }
        catch (NoCorrespondingServiceRegisteredException e) {
            logger.log(Level.WARNING, "Could not ping mark " + mark);
        }
    }

    @Override
    public void removeDenotationForRaceLogTracking(RacingEventService service, RaceLog raceLog) {
        RaceLogEvent denoteForTrackingEvent = (RaceLogEvent)new LastEventOfTypeFinder((AbstractLog)raceLog, true, RaceLogDenoteForTrackingEvent.class).analyze();
        RaceLogEvent startTrackingEvent = (RaceLogEvent)new LastEventOfTypeFinder((AbstractLog)raceLog, true, RaceLogStartTrackingEvent.class).analyze();
        if (denoteForTrackingEvent != null) {
            try {
                raceLog.revokeEvent(service.getServerAuthor(), (AbstractLogEvent)denoteForTrackingEvent, "remove denotation");
                if (startTrackingEvent != null) {
                    raceLog.revokeEvent(service.getServerAuthor(), (AbstractLogEvent)startTrackingEvent, "reset start tracking time upon removing denotation");
                }
            }
            catch (NotRevokableException e) {
                logger.log(Level.WARNING, "could not remove denotation by adding RevokeEvents", e);
            }
        }
    }

    private MailService getMailService() {
        ServiceReference ref = Activator.getContext().getServiceReference(MailService.class);
        if (ref == null) {
            logger.warning("No mail service registered");
            return null;
        }
        return (MailService)Activator.getContext().getService(ref);
    }

    @Override
    public void inviteCompetitorsForTrackingViaEmail(Event event, Leaderboard leaderboard, Regatta regatta, String serverUrlWithoutTrailingSlash, Set<Competitor> competitors, String legacyIOSAppUrl, String legacyAndroidAppUrl, Locale locale, MailInvitationType type) throws MailException {
        StringBuilder occuredExceptions = new StringBuilder();
        for (Competitor competitor : competitors) {
            String toAddress = competitor.getEmail();
            if (toAddress == null || toAddress.isEmpty()) continue;
            try {
                String url = DeviceMappingConstants.getDeviceMappingForRegattaLogUrl((String)serverUrlWithoutTrailingSlash, (String)event.getId().toString(), (String)leaderboard.getName(), (String)"competitor_id", (String)competitor.getId().toString(), (String)regatta.getRegistrationLinkSecret(), (UrlHelper)NonGwtUrlHelper.INSTANCE);
                RaceLogTrackingInvitationMailBuilder mail = this.getMailBuilder(type, locale);
                mail.withSubject(competitor.getName()).addEventLogo(event).addHeadline(event, leaderboard).addSailInSightIntroductoryText(competitor.getName()).addSailInsightDeeplink(url, legacyIOSAppUrl, legacyAndroidAppUrl);
                this.getMailService().sendMail(toAddress, mail.getSubject(), mail.getMultipartSupplier());
            }
            catch (MailException | IOException | MessagingException e) {
                logger.log(Level.SEVERE, "Error while trying to send invitation mail to competitor" + competitor.getName() + " with e-mail address " + toAddress + "!", e);
                occuredExceptions.append(String.valueOf(e.getMessage()) + "\r\n");
            }
        }
        if (occuredExceptions.length() != 0) {
            throw new MailException(occuredExceptions.toString());
        }
    }

    @Override
    public void inviteBuoyTenderViaEmail(Event event, Leaderboard leaderboard, Regatta regatta, String serverUrlWithoutTrailingSlash, String emails, String legacyIOSAppUrl, String legacyAndroidAppUrl, Locale locale, MailInvitationType type) throws MailException {
        StringBuilder occuredExceptions = new StringBuilder();
        String[] emailArray = emails.split(",");
        String url = DeviceMappingConstants.getBuoyTenderInvitationUrl((String)serverUrlWithoutTrailingSlash, (String)leaderboard.getName(), (String)event.getId().toString(), (String)regatta.getRegistrationLinkSecret(), (UrlHelper)NonGwtUrlHelper.INSTANCE);
        String[] stringArray = emailArray;
        int n = emailArray.length;
        int n2 = 0;
        while (n2 < n) {
            String toAddress = stringArray[n2];
            try {
                String buoyTender = RaceLogTrackingI18n.buoyTender(locale);
                RaceLogTrackingInvitationMailBuilder mail = this.getMailBuilder(type, locale);
                mail.withSubject(buoyTender).addEventLogo(event).addHeadline(event, leaderboard).addBuoyPingerIntroductoryText(buoyTender).addBuoyPingerDeeplink(url, legacyIOSAppUrl, legacyAndroidAppUrl);
                this.getMailService().sendMail(toAddress, mail.getSubject(), mail.getMultipartSupplier());
            }
            catch (MailException | IOException | MessagingException e) {
                logger.log(Level.SEVERE, "Error while trying to send invitation mail to buoy tender with e-mail address " + toAddress + "!", e);
                occuredExceptions.append(String.valueOf(e.getMessage()) + "\r\n");
            }
            ++n2;
        }
        if (occuredExceptions.length() != 0) {
            throw new MailException(occuredExceptions.toString());
        }
    }

    private RaceLogTrackingInvitationMailBuilder getMailBuilder(MailInvitationType type, Locale locale) {
        RaceLogTrackingInvitationMailBuilder mail;
        switch (type) {
            case LEGACY: {
                mail = new LegacyRaceLogTrackingInvitationMailBuilder(locale);
                break;
            }
            case SailInsight1: 
            case SailInsight2: 
            case SailInsight3: {
                mail = new BranchIORaceLogTrackingInvitationMailBuilder(locale, type);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled mail type");
            }
        }
        return mail;
    }

    @Override
    public void copyPairingListFromOtherLeaderboard(RegattaLeaderboard sourceLeaderboard, RegattaLeaderboard targetLeaderboard, String fromRaceColumnName, String toRaceColumnInclusiveName) throws NotFoundException {
        RaceColumn fromColumn = sourceLeaderboard.getRaceColumnByName(fromRaceColumnName);
        if (fromColumn == null) {
            throw new NotFoundException("Race column from which to start copying pairings " + fromRaceColumnName + " not found in source leaderboard " + sourceLeaderboard.getName());
        }
        RaceColumn toColumn = sourceLeaderboard.getRaceColumnByName(toRaceColumnInclusiveName);
        if (toColumn == null) {
            throw new NotFoundException("Race column up to which to copy pairings " + toColumn + " not found in source leaderboard " + targetLeaderboard.getName());
        }
        Iterable targetBoats = targetLeaderboard.getAllBoats();
        for (Boat sourceBoat : sourceLeaderboard.getAllBoats()) {
            if (Util.contains((Iterable)targetBoats, (Object)sourceBoat)) continue;
            targetLeaderboard.registerBoat(sourceBoat);
        }
        boolean inSequence = false;
        Iterator targetRaceColumnIterator = targetLeaderboard.getRaceColumns().iterator();
        for (RaceColumn sourceRaceColumn : sourceLeaderboard.getRaceColumns()) {
            RaceColumnInSeries sourceRaceColumnInSeries = (RaceColumnInSeries)sourceRaceColumn;
            if (sourceRaceColumn == fromColumn) {
                inSequence = true;
            }
            if (!inSequence) continue;
            if (!targetRaceColumnIterator.hasNext()) {
                throw new IllegalArgumentException("Target leaderboard " + targetLeaderboard.getName() + " doesn't have enough race columns to copy pairings from source leaderboard");
            }
            this.copyPairingsFromRaceColumn(sourceLeaderboard, targetLeaderboard, sourceRaceColumnInSeries, (RaceColumnInSeries)targetRaceColumnIterator.next());
            if (sourceRaceColumn != toColumn) continue;
            inSequence = false;
        }
    }

    private void copyPairingsFromRaceColumn(RegattaLeaderboard sourceLeaderboard, RegattaLeaderboard targetLeaderboard, RaceColumnInSeries sourceRaceColumn, RaceColumnInSeries targetRaceColumn) throws IllegalArgumentException {
        Series sourceSeries = sourceRaceColumn.getSeries();
        Series targetSeries = targetRaceColumn.getSeries();
        if (Util.size((Iterable)sourceSeries.getFleets()) != Util.size((Iterable)targetSeries.getFleets())) {
            throw new IllegalArgumentException("Source series has " + Util.size((Iterable)sourceSeries.getFleets()) + " fleets, but target series has " + Util.size((Iterable)targetSeries.getFleets()));
        }
        Iterator targetFleetIterator = targetSeries.getFleets().iterator();
        for (Fleet sourceFleet : sourceRaceColumn.getFleets()) {
            Fleet targetFleet = (Fleet)targetFleetIterator.next();
            Iterable targetCompetitors = targetRaceColumn.getAllCompetitors(targetFleet);
            for (Competitor sourceCompetitor : sourceRaceColumn.getAllCompetitors(sourceFleet)) {
                if (Util.contains((Iterable)targetCompetitors, (Object)sourceCompetitor)) continue;
                targetLeaderboard.registerCompetitor(sourceCompetitor);
            }
            this.copyCompetitors((RaceColumn)sourceRaceColumn, sourceFleet, Collections.singleton(new Util.Pair((Object)targetRaceColumn, (Object)targetFleet)));
        }
    }
}

