/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector.persistence.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.sap.sailing.expeditionconnector.ExpeditionDeviceConfiguration;
import com.sap.sailing.expeditionconnector.persistence.MongoObjectFactory;
import com.sap.sailing.expeditionconnector.persistence.impl.CollectionNames;
import com.sap.sailing.expeditionconnector.persistence.impl.FieldNames;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private static final Logger logger = Logger.getLogger(MongoObjectFactoryImpl.class.getName());
    private final MongoCollection<Document> expeditionDeviceConfigurationsCollection;

    public MongoObjectFactoryImpl(MongoDatabase db) {
        this.expeditionDeviceConfigurationsCollection = db.getCollection(CollectionNames.EXPEDITION_DEVICE_CONFIGURATIONS.name());
        BasicDBObject index = new BasicDBObject();
        index.put((Object)FieldNames.EXPEDITION_DEVICE_CONFIGURATION_UUID.name(), (Object)1);
        this.expeditionDeviceConfigurationsCollection.createIndex((Bson)index, new IndexOptions().name("uuidindex").unique(true).background(false));
    }

    private Document getExpeditionDeviceConfigurationDBKey(UUID expeditionDeviceConfigurationId) {
        Document basicDBObject = new Document(FieldNames.EXPEDITION_DEVICE_CONFIGURATION_UUID.name(), (Object)expeditionDeviceConfigurationId);
        return basicDBObject;
    }

    @Override
    public void storeExpeditionDeviceConfiguration(ExpeditionDeviceConfiguration expeditionDeviceConfiguration) {
        Document key = this.getExpeditionDeviceConfigurationDBKey(expeditionDeviceConfiguration.getDeviceUuid());
        Document expeditionDeviceConfigurationDBObject = new Document();
        expeditionDeviceConfigurationDBObject.put(FieldNames.EXPEDITION_DEVICE_CONFIGURATION_UUID.name(), (Object)expeditionDeviceConfiguration.getDeviceUuid());
        expeditionDeviceConfigurationDBObject.put(FieldNames.EXPEDITION_DEVICE_CONFIGURATION_NAME.name(), (Object)expeditionDeviceConfiguration.getName());
        expeditionDeviceConfigurationDBObject.put(FieldNames.EXPEDITION_DEVICE_CONFIGURATION_BOAT_ID.name(), (Object)expeditionDeviceConfiguration.getExpeditionBoatId());
        boolean success = false;
        int attempt = 0;
        Exception lastException = null;
        while (attempt < 5 && !success) {
            try {
                this.expeditionDeviceConfigurationsCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)key, (Object)expeditionDeviceConfigurationDBObject, new ReplaceOptions().upsert(true));
                success = true;
                ++attempt;
            }
            catch (Exception e) {
                lastException = e;
                logger.log(Level.WARNING, "Exception trying to write Expedition device configuration. Trying again", e);
            }
        }
        if (!success) {
            throw new RuntimeException("Couldn't store Expedition device configuration " + expeditionDeviceConfiguration, lastException);
        }
    }

    @Override
    public void removeExpeditionDeviceConfiguration(UUID expeditionDeviceConfigurationId) {
        this.expeditionDeviceConfigurationsCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteOne((Bson)this.getExpeditionDeviceConfigurationDBKey(expeditionDeviceConfigurationId));
    }
}

