/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.coursetemplate;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.coursetemplate.HasTags;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.WaypointTemplate;
import com.sap.sse.common.NamedWithUUID;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithOptionalRepeatablePart;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;

public interface CourseTemplate
extends WithOptionalRepeatablePart,
NamedWithUUID,
HasTags,
WithQualifiedObjectIdentifier {
    public String getShortName();

    public Iterable<MarkTemplate> getMarkTemplates();

    default public Iterable<MarkTemplate> getMarkTemplatesNotIncludedInCourse() {
        HashSet<MarkTemplate> result = new HashSet<MarkTemplate>();
        Util.addAll(this.getMarkTemplates(), result);
        for (MarkRole markRole : this.getMarkRoles()) {
            result.remove(this.getDefaultMarkTemplateForMarkRole(markRole));
        }
        return result;
    }

    default public Iterable<MarkRole> getMarkRoles() {
        HashSet<MarkRole> result = new HashSet<MarkRole>();
        for (WaypointTemplate wpt : this.getWaypointTemplates()) {
            for (MarkRole markRole : wpt.getControlPointTemplate().getMarkRoles()) {
                result.add(markRole);
            }
        }
        return result;
    }

    public MarkTemplate getMarkTemplateByIdIfContainedInCourseTemplate(UUID var1);

    public Iterable<WaypointTemplate> getWaypointTemplates(int var1);

    public Iterable<WaypointTemplate> getWaypointTemplates();

    public Map<MarkTemplate, MarkRole> getDefaultMarkRolesForMarkTemplates();

    public MarkRole getOptionalAssociatedRole(MarkTemplate var1);

    public Map<MarkRole, MarkTemplate> getDefaultMarkTemplatesForMarkRoles();

    public MarkTemplate getDefaultMarkTemplateForMarkRole(MarkRole var1);

    public MarkRole getMarkRoleByIdIfContainedInCourseTemplate(UUID var1);

    public URL getOptionalImageURL();

    public Integer getDefaultNumberOfLaps();

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(UUID courseTemplateUUID) {
        return new TypeRelativeObjectIdentifier(new String[]{courseTemplateUUID.toString()});
    }

    default public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(CourseTemplate.getTypeRelativeObjectIdentifier(this.getId()));
    }

    default public HasPermissions getPermissionType() {
        return SecuredDomainType.COURSE_TEMPLATE;
    }
}

