/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.CountryCodeFactory;

public class NationalityImpl
implements Nationality {
    private static final long serialVersionUID = 238906193483424259L;
    private final String threeLetterIOCAcronym;

    public NationalityImpl(String threeLetterIOCAcronym) {
        if (threeLetterIOCAcronym.length() != 3) {
            throw new IllegalArgumentException("Three-letter IOC nationality acronym \"" + threeLetterIOCAcronym + "\" doesn't have three letters.");
        }
        this.threeLetterIOCAcronym = threeLetterIOCAcronym;
    }

    public String getName() {
        return this.getCountryCode() == null ? this.getThreeLetterIOCAcronym() : this.getCountryCode().getName();
    }

    @Override
    public String getThreeLetterIOCAcronym() {
        return this.threeLetterIOCAcronym;
    }

    @Override
    public CountryCode getCountryCode() {
        return CountryCodeFactory.INSTANCE.getFromThreeLetterIOCName(this.getThreeLetterIOCAcronym());
    }

    public Nationality resolve(SharedDomainFactory<?> domainFactory) {
        return domainFactory.getOrCreateNationality(this.getThreeLetterIOCAcronym());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.threeLetterIOCAcronym == null ? 0 : this.threeLetterIOCAcronym.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NationalityImpl other = (NationalityImpl)obj;
        return !(this.threeLetterIOCAcronym == null ? other.threeLetterIOCAcronym != null : !this.threeLetterIOCAcronym.equals(other.threeLetterIOCAcronym));
    }

    public String toString() {
        return this.getThreeLetterIOCAcronym();
    }
}

