/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Collections;
import java.util.UUID;

public class StartTimeFinderResult {
    private final Iterable<SimpleRaceLogIdentifier> dependingOnRaces;
    private final TimePoint startTime;
    private final UUID courseAreaId;
    private final ResolutionFailed resolutionFailed;
    private Duration startTimeDiff;

    public StartTimeFinderResult(Iterable<SimpleRaceLogIdentifier> racesDependingOn, TimePoint startTime, Duration startTimeDiff, UUID courseAreaId) {
        this(racesDependingOn, startTime, startTimeDiff, null, courseAreaId);
    }

    public StartTimeFinderResult(Iterable<SimpleRaceLogIdentifier> racesDependingOn, Duration startTimeDiff, ResolutionFailed resolutionFailed, UUID courseAreaId) {
        this(racesDependingOn, null, startTimeDiff, resolutionFailed, courseAreaId);
    }

    public StartTimeFinderResult(Iterable<SimpleRaceLogIdentifier> dependingOnRaces, TimePoint startTime, Duration startTimeDiff, ResolutionFailed resolutionFailed, UUID courseAreaId) {
        this.startTime = startTime;
        this.startTimeDiff = startTimeDiff;
        this.dependingOnRaces = dependingOnRaces;
        this.resolutionFailed = resolutionFailed;
        this.courseAreaId = courseAreaId;
    }

    public StartTimeFinderResult(TimePoint startTime, Duration startTimeDiff, UUID courseAreaId) {
        this(Collections.emptyList(), startTime, startTimeDiff, courseAreaId);
    }

    public ResolutionFailed getResolutionFailed() {
        return this.resolutionFailed;
    }

    public Iterable<SimpleRaceLogIdentifier> getDependingOnRaces() {
        return this.dependingOnRaces;
    }

    public TimePoint getStartTime() {
        return this.startTime;
    }

    public Duration getStartTimeDiff() {
        return this.startTimeDiff;
    }

    public void setStartTimeDiff(Duration startTimeDiff) {
        this.startTimeDiff = startTimeDiff;
    }

    public boolean isDependentStartTime() {
        return this.dependingOnRaces != null && !Util.isEmpty(this.dependingOnRaces);
    }

    public UUID getCourseAreaId() {
        return this.courseAreaId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dependingOnRaces == null ? 0 : this.dependingOnRaces.hashCode());
        result = 31 * result + (this.resolutionFailed == null ? 0 : this.resolutionFailed.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + (this.startTimeDiff == null ? 0 : this.startTimeDiff.hashCode());
        result = 31 * result + (this.courseAreaId == null ? 0 : this.courseAreaId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StartTimeFinderResult other = (StartTimeFinderResult)obj;
        if (this.dependingOnRaces == null ? other.dependingOnRaces != null : !this.dependingOnRaces.equals(other.dependingOnRaces)) {
            return false;
        }
        if (this.resolutionFailed != other.resolutionFailed) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        if (this.startTimeDiff == null ? other.startTimeDiff != null : !this.startTimeDiff.equals(other.startTimeDiff)) {
            return false;
        }
        return !(this.courseAreaId == null ? other.courseAreaId != null : !this.courseAreaId.equals(other.courseAreaId));
    }

    public static enum ResolutionFailed {
        RACE_LOG_UNRESOLVED,
        CYCLIC_DEPENDENCY,
        NO_START_TIME_SET;

    }
}

