/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.shared.dto;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.data.ReportParameterToDimensionFilterBindings;
import com.sap.sse.datamining.shared.dto.FilterDimensionIdentifier;
import com.sap.sse.datamining.shared.dto.FilterDimensionParameter;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.parameters.ParameterModelListener;
import java.io.Serializable;
import java.util.Map;
import java.util.stream.StreamSupport;

public interface DataMiningReportDTO
extends Serializable {
    public Iterable<FilterDimensionParameter> getParameters();

    public FilterDimensionParameter createParameter(String var1, String var2, Iterable<? extends Serializable> var3);

    public void removeParameter(FilterDimensionParameter var1);

    public Iterable<StatisticQueryDefinitionDTO> getQueryDefinitions();

    default public void addQueryDefinition(ModifiableStatisticQueryDefinitionDTO queryDefinition) {
        this.addQueryDefinition(Util.size(this.getQueryDefinitions()), queryDefinition);
    }

    public void addQueryDefinition(int var1, ModifiableStatisticQueryDefinitionDTO var2);

    default public void replaceQueryDefinition(StatisticQueryDefinitionDTO toReplace, ModifiableStatisticQueryDefinitionDTO replaceWith, ReportParameterToDimensionFilterBindings parameterBindings) {
        int i;
        int index = toReplace != null ? ((i = this.removeQueryDefinition(toReplace)) < 0 ? Util.size(this.getQueryDefinitions()) : i) : Util.size(this.getQueryDefinitions());
        this.addQueryDefinition(index, replaceWith);
        if (parameterBindings != null) {
            for (Map.Entry<FilterDimensionIdentifier, FilterDimensionParameter> e : parameterBindings) {
                this.addParameterUsage(replaceWith, e.getKey(), e.getValue());
            }
        }
    }

    public int removeQueryDefinition(StatisticQueryDefinitionDTO var1);

    public void addParameterUsage(StatisticQueryDefinitionDTO var1, FilterDimensionIdentifier var2, FilterDimensionParameter var3);

    public void removeParameterUsage(StatisticQueryDefinitionDTO var1, FilterDimensionIdentifier var2, FilterDimensionParameter var3);

    public Iterable<Util.Pair<StatisticQueryDefinitionDTO, FilterDimensionIdentifier>> getParameterUsages(FilterDimensionParameter var1);

    public ReportParameterToDimensionFilterBindings getParameterUsages(StatisticQueryDefinitionDTO var1);

    public FilterDimensionParameter getUsedParameter(StatisticQueryDefinitionDTO var1, FilterDimensionIdentifier var2);

    default public Iterable<FilterDimensionParameter> getParametersForTypeName(String typeName) {
        return StreamSupport.stream(this.getParameters().spliterator(), false).filter(parameter -> Util.equalsWithNull((Object)parameter.getTypeName(), (Object)typeName))::iterator;
    }

    public void addParamterModelListener(ParameterModelListener var1);

    public void removeParameterModelListener(ParameterModelListener var1);
}

