/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.settings;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.gwt.client.shared.settings.OnSettingsLoadedCallback;
import com.sap.sse.gwt.client.shared.settings.OnSettingsStoredCallback;
import com.sap.sse.gwt.client.shared.settings.SettingsStorageManager;
import com.sap.sse.gwt.client.shared.settings.StorableRepresentationOfDocumentAndUserSettings;
import com.sap.sse.gwt.client.shared.settings.StorableSettingsRepresentation;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorage;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.settings.StoredSettingsLocation;
import com.sap.sse.security.ui.settings.UserSettingsStorageManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;

public class UserSettingsStorageManager
implements SettingsStorageManager {
    private final String storageKeyForUserSettings;
    private final String storageKeyForDocumentSettings;
    private UserService userService;
    private boolean initialized = false;
    private boolean userWasAlreadyLoggedIn = false;
    private UserStatusEventHandler userStatusEventHandler = null;
    private Queue<OnSettingsLoadedCallback<StorableRepresentationOfDocumentAndUserSettings>> retrieveSettingsCallbacksQueue = new LinkedList();

    public UserSettingsStorageManager(UserService userService, StoredSettingsLocation storageDefinitionId) {
        this.userService = userService;
        this.storageKeyForUserSettings = storageDefinitionId.generateStorageKeyForUserSettings();
        this.storageKeyForDocumentSettings = storageDefinitionId.generateStorageKeyForDocumentSettings();
    }

    public void storeSettingsRepresentations(StorableRepresentationOfDocumentAndUserSettings settingsRepresentations, OnSettingsStoredCallback onSettingsStoredCallback) {
        this.storeSettingsRepresentationsOnLocalStorage(settingsRepresentations);
        if (this.userService.getCurrentUser() != null) {
            this.storeSettingsRepresentationsOnServer(settingsRepresentations, onSettingsStoredCallback);
        } else {
            onSettingsStoredCallback.onSuccess();
        }
    }

    private void storeSettingsRepresentationsOnLocalStorage(StorableRepresentationOfDocumentAndUserSettings settingsRepresentations) {
        String settingsString;
        CrossDomainStorage storage = this.userService.getStorage();
        if (settingsRepresentations.hasStoredUserSettings()) {
            settingsString = settingsRepresentations.getUserSettingsRepresentation().asString();
            if (settingsString != null) {
                storage.setItem(this.storageKeyForUserSettings, settingsString, null);
            } else {
                storage.removeItem(this.storageKeyForUserSettings, null);
            }
        }
        if (settingsRepresentations.hasStoredDocumentSettings()) {
            settingsString = settingsRepresentations.getDocumentSettingsRepresentation().asString();
            if (settingsString != null) {
                storage.setItem(this.storageKeyForDocumentSettings, settingsString, null);
            } else {
                storage.removeItem(this.storageKeyForDocumentSettings, null);
            }
        }
    }

    private void storeSettingsRepresentationsOnServer(StorableRepresentationOfDocumentAndUserSettings settingsRepresentations, OnSettingsStoredCallback onSettingsStoredCallback) {
        2 asyncCallback = new /* Unavailable Anonymous Inner Class!! */;
        if (!settingsRepresentations.hasStoredDocumentSettings() || !settingsRepresentations.hasStoredUserSettings()) {
            if (settingsRepresentations.hasStoredDocumentSettings()) {
                this.userService.setPreference(this.storageKeyForDocumentSettings, settingsRepresentations.getDocumentSettingsRepresentation().asString(), (AsyncCallback)asyncCallback);
            }
            if (settingsRepresentations.hasStoredUserSettings()) {
                this.userService.setPreference(this.storageKeyForUserSettings, settingsRepresentations.getUserSettingsRepresentation().asString(), (AsyncCallback)asyncCallback);
            }
        } else {
            HashMap<String, String> keyValuePairs = new HashMap<String, String>();
            if (settingsRepresentations.hasStoredUserSettings()) {
                keyValuePairs.put(this.storageKeyForUserSettings, settingsRepresentations.getUserSettingsRepresentation().asString());
            }
            if (settingsRepresentations.hasStoredDocumentSettings()) {
                keyValuePairs.put(this.storageKeyForDocumentSettings, settingsRepresentations.getDocumentSettingsRepresentation().asString());
            }
            this.userService.setPreferences(keyValuePairs, (AsyncCallback)asyncCallback);
        }
    }

    public void dispose() {
        if (this.userStatusEventHandler != null) {
            this.userService.removeUserStatusEventHandler(this.userStatusEventHandler);
        }
    }

    private StorableRepresentationOfDocumentAndUserSettings convertStringsToSettingsRepresentations(String userSettings, String documentSettings) {
        StorableSettingsRepresentation userSettingsRepresentation = userSettings == null ? null : new StorableSettingsRepresentation(userSettings);
        StorableSettingsRepresentation documentSettingsRepresentation = documentSettings == null ? null : new StorableSettingsRepresentation(documentSettings);
        return new StorableRepresentationOfDocumentAndUserSettings(userSettingsRepresentation, documentSettingsRepresentation);
    }

    private void retrieveSettingsRepresentationsFromLocalStorage(Iterable<Consumer<StorableRepresentationOfDocumentAndUserSettings>> resultCallbacks) {
        CrossDomainStorage localStorage = this.userService.getStorage();
        localStorage.getItem(this.storageKeyForUserSettings, userSettings -> localStorage.getItem(this.storageKeyForDocumentSettings, documentSettings -> resultCallbacks.forEach(resultCallback -> resultCallback.accept(this.convertStringsToSettingsRepresentations(userSettings, documentSettings)))));
    }

    private void retrieveSettingsRepresentationsFromServer(AsyncCallback<StorableRepresentationOfDocumentAndUserSettings> asyncCallback) {
        ArrayList<String> keys = new ArrayList<String>(2);
        keys.add(this.storageKeyForUserSettings);
        keys.add(this.storageKeyForDocumentSettings);
        this.userService.getPreferences(keys, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void retrieveSettingsRepresentation(OnSettingsLoadedCallback<StorableRepresentationOfDocumentAndUserSettings> callback) {
        this.retrieveSettingsCallbacksQueue.add(callback);
        if (this.userStatusEventHandler == null) {
            this.userStatusEventHandler = new /* Unavailable Anonymous Inner Class!! */;
            this.userService.addUserStatusEventHandler(this.userStatusEventHandler, true);
        } else if (this.initialized) {
            this.retrieveSettingsRepresentationsFromServerOrLocalStorage();
        }
    }

    private void retrieveSettingsRepresentationsFromServerOrLocalStorage() {
        if (this.userService.getCurrentUser() == null) {
            this.retrieveSettingsRepresentationsFromLocalStorage((Iterable)this.getQueuedSettingsCallbacks());
        } else {
            this.userWasAlreadyLoggedIn = true;
            this.retrieveSettingsRepresentationsFromServer((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private List<Consumer<StorableRepresentationOfDocumentAndUserSettings>> getQueuedSettingsCallbacks() {
        OnSettingsLoadedCallback callback;
        LinkedList<Consumer<StorableRepresentationOfDocumentAndUserSettings>> callbacks = new LinkedList<Consumer<StorableRepresentationOfDocumentAndUserSettings>>();
        while ((callback = (OnSettingsLoadedCallback)this.retrieveSettingsCallbacksQueue.poll()) != null) {
            OnSettingsLoadedCallback finalCallback = callback;
            callbacks.add(settingsRepresentations -> finalCallback.onSuccess(settingsRepresentations));
        }
        return callbacks;
    }

    private void syncLocalStorageAndServer(StorableRepresentationOfDocumentAndUserSettings serverSettingsRepresentations, Iterable<Consumer<StorableRepresentationOfDocumentAndUserSettings>> resultCallbacks) {
        if (!serverSettingsRepresentations.hasStoredUserSettings() && !serverSettingsRepresentations.hasStoredDocumentSettings()) {
            this.retrieveSettingsRepresentationsFromLocalStorage(Collections.singleton(localStorageSettingsRepresentations -> {
                if (localStorageSettingsRepresentations.hasStoredUserSettings() || localStorageSettingsRepresentations.hasStoredDocumentSettings()) {
                    this.storeSettingsRepresentationsOnServer(localStorageSettingsRepresentations, (OnSettingsStoredCallback)new /* Unavailable Anonymous Inner Class!! */);
                }
                resultCallbacks.forEach(resultCallback -> resultCallback.accept(localStorageSettingsRepresentations));
            }));
        } else {
            this.storeSettingsRepresentationsOnLocalStorage(serverSettingsRepresentations);
            resultCallbacks.forEach(resultCallback -> resultCallback.accept(serverSettingsRepresentations));
        }
    }

    static /* synthetic */ String access$0(UserSettingsStorageManager userSettingsStorageManager) {
        return userSettingsStorageManager.storageKeyForUserSettings;
    }

    static /* synthetic */ String access$1(UserSettingsStorageManager userSettingsStorageManager) {
        return userSettingsStorageManager.storageKeyForDocumentSettings;
    }

    static /* synthetic */ StorableRepresentationOfDocumentAndUserSettings access$2(UserSettingsStorageManager userSettingsStorageManager, String string, String string2) {
        return userSettingsStorageManager.convertStringsToSettingsRepresentations(string, string2);
    }

    static /* synthetic */ boolean access$3(UserSettingsStorageManager userSettingsStorageManager) {
        return userSettingsStorageManager.initialized;
    }

    static /* synthetic */ UserService access$4(UserSettingsStorageManager userSettingsStorageManager) {
        return userSettingsStorageManager.userService;
    }

    static /* synthetic */ boolean access$5(UserSettingsStorageManager userSettingsStorageManager) {
        return userSettingsStorageManager.userWasAlreadyLoggedIn;
    }

    static /* synthetic */ void access$6(UserSettingsStorageManager userSettingsStorageManager, boolean bl) {
        userSettingsStorageManager.initialized = bl;
    }

    static /* synthetic */ void access$7(UserSettingsStorageManager userSettingsStorageManager) {
        userSettingsStorageManager.retrieveSettingsRepresentationsFromServerOrLocalStorage();
    }

    static /* synthetic */ List access$8(UserSettingsStorageManager userSettingsStorageManager) {
        return userSettingsStorageManager.getQueuedSettingsCallbacks();
    }

    static /* synthetic */ void access$9(UserSettingsStorageManager userSettingsStorageManager, StorableRepresentationOfDocumentAndUserSettings storableRepresentationOfDocumentAndUserSettings, Iterable iterable) {
        userSettingsStorageManager.syncLocalStorageAndServer(storableRepresentationOfDocumentAndUserSettings, iterable);
    }

    static /* synthetic */ void access$10(UserSettingsStorageManager userSettingsStorageManager, Iterable iterable) {
        userSettingsStorageManager.retrieveSettingsRepresentationsFromLocalStorage(iterable);
    }
}

