/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.usermanagement;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.TimePoint;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapper;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import com.sap.sse.security.ui.client.usermanagement.UserEditDialog;
import com.sap.sse.security.ui.client.usermanagement.UserTableWrapper;
import java.util.Comparator;
import java.util.function.Consumer;

public class UserTableWrapper<S extends RefreshableSelectionModel<UserDTO>, TR extends CellTableWithCheckboxResources>
extends TableWrapper<UserDTO, S, com.sap.sse.security.ui.client.i18n.StringMessages, TR> {
    private final LabeledAbstractFilterablePanel<UserDTO> filterField;
    private final UserService userService;

    public UserTableWrapper(UserService userService, com.sap.sse.security.ui.client.i18n.StringMessages stringMessages, ErrorReporter errorReporter, boolean multiSelection, boolean enablePager, TR tableResources) {
        super((StringMessages)stringMessages, errorReporter, multiSelection, enablePager, (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, tableResources);
        this.userService = userService;
        ColumnSortEvent.ListHandler userColumnListHandler = this.getColumnSortHandler();
        AbstractSortableTextColumn usernameColumn = new AbstractSortableTextColumn(user -> user.getName(), userColumnListHandler);
        AbstractSortableTextColumn fullNameColumn = new AbstractSortableTextColumn(user -> user.getFullName(), userColumnListHandler);
        AbstractSortableTextColumn emailColumn = new AbstractSortableTextColumn(user -> user.getEmail(), userColumnListHandler);
        AbstractSortableTextColumn emailValidatedColumn = new AbstractSortableTextColumn(user -> user.isEmailValidated() ? stringMessages.yes() : stringMessages.no(), userColumnListHandler);
        AbstractSortableTextColumn companyColumn = new AbstractSortableTextColumn(user -> user.getCompany(), userColumnListHandler);
        2 groupsColumn = new /* Unavailable Anonymous Inner Class!! */;
        groupsColumn.setSortable(true);
        userColumnListHandler.setComparator((Column)groupsColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        4 permissionsColumn = new /* Unavailable Anonymous Inner Class!! */;
        permissionsColumn.setSortable(true);
        userColumnListHandler.setComparator((Column)permissionsColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        6 rolesColumn = new /* Unavailable Anonymous Inner Class!! */;
        rolesColumn.setSortable(true);
        userColumnListHandler.setComparator((Column)rolesColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        AbstractSortableTextColumn lockedUntilColumn = new AbstractSortableTextColumn(user -> user.getLockedUntil() != null && user.getLockedUntil().after(TimePoint.now()) ? DateAndTimeFormatterUtil.dateTimeMedium.render(user.getLockedUntil().asDate()) : "", userColumnListHandler);
        AccessControlledActionsColumn userActionColumn = this.composeUserActionColumn(stringMessages, errorReporter);
        this.filterField = new /* Unavailable Anonymous Inner Class!! */;
        this.registerSelectionModelOnNewDataProvider(this.filterField.getAllListDataProvider());
        this.filterField.setUpdatePermissionFilterForCheckbox(user -> userService.hasPermission((SecuredDTO)user, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        this.mainPanel.insert((Widget)this.filterField, 0);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)userColumnListHandler);
        this.table.addColumn((Column)usernameColumn, ((com.sap.sse.security.ui.client.i18n.StringMessages)this.getStringMessages()).username());
        this.table.addColumn((Column)fullNameColumn, stringMessages.name());
        this.table.addColumn((Column)emailColumn, stringMessages.email());
        this.table.addColumn((Column)emailValidatedColumn, stringMessages.validated());
        this.table.addColumn((Column)companyColumn, stringMessages.company());
        this.table.addColumn((Column)groupsColumn, stringMessages.groups());
        this.table.addColumn((Column)rolesColumn, stringMessages.roles());
        this.table.addColumn((Column)permissionsColumn, stringMessages.permissions());
        this.table.addColumn((Column)lockedUntilColumn, stringMessages.lockedUntil());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.table, (ColumnSortEvent.ListHandler)userColumnListHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        this.table.addColumn((Column)userActionColumn, stringMessages.actions());
        this.table.ensureDebugId("UsersTable");
    }

    private AccessControlledActionsColumn<UserDTO, DefaultActionsImagesBarCell> composeUserActionColumn(com.sap.sse.security.ui.client.i18n.StringMessages stringMessages, ErrorReporter errorReporter) {
        HasPermissions type = SecuredSecurityTypes.USER;
        AccessControlledActionsColumn userActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DefaultActionsImagesBarCell(stringMessages), (UserService)this.userService);
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, user -> this.editUser(user));
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, user -> {
            if (Window.confirm((String)stringMessages.doYouReallyWantToDeleteUser(user.getName()))) {
                this.getUserManagementWriteService().deleteUser(user.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)this.userService.getUserManagementWriteService(), (HasPermissions)type, user -> this.refreshUserList(null), (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)this.userService.getUserManagementWriteService(), (HasPermissions)type, user -> {
            AccessControlListDTO accessControlListDTO = user.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, u -> configACL.openDialog((SecuredDTO)u));
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_MANAGE_LOCK, (HasPermissions.Action)SecuredSecurityTypes.UserActions.MANAGE_LOCK, this.onManageLockPressed(stringMessages, errorReporter));
        return userActionColumn;
    }

    private Consumer<UserDTO> onManageLockPressed(com.sap.sse.security.ui.client.i18n.StringMessages stringMessages, ErrorReporter errorReporter) {
        return selectedUser -> {
            boolean isLocked = selectedUser.getLockedUntil().after(TimePoint.now());
            if (isLocked) {
                String userName = selectedUser.getName();
                boolean didConfirm = Window.confirm((String)stringMessages.doYouReallyWantToUnlockUser(userName));
                if (didConfirm) {
                    this.getUserManagementWriteService().unlockUser(userName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else {
                Notification.notify((String)stringMessages.userIsAlreadyUnlocked(), (Notification.NotificationType)Notification.NotificationType.INFO);
            }
        };
    }

    public Iterable<UserDTO> getAllUsers() {
        return this.filterField.getAll();
    }

    public LabeledAbstractFilterablePanel<UserDTO> getFilterField() {
        return this.filterField;
    }

    public void refreshUserList(Iterable<UserDTO> competitors) {
        this.getFilteredUsers(competitors);
    }

    public void refreshUserList(Callback<Iterable<UserDTO>, Throwable> callback, boolean clearSelection) {
        if (clearSelection) {
            this.getSelectionModel().clear();
        }
        11 myCallback = new /* Unavailable Anonymous Inner Class!! */;
        this.getUserManagementService().getUserList((AsyncCallback)myCallback);
    }

    public void refreshUserList(Callback<Iterable<UserDTO>, Throwable> callback) {
        this.refreshUserList(callback, true);
    }

    private void getFilteredUsers(Iterable<UserDTO> result) {
        this.filterField.updateAll(result);
    }

    private void editUser(UserDTO originalUser) {
        UserEditDialog dialog = new UserEditDialog(originalUser, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */, this.userService, this.errorReporter);
        dialog.ensureDebugId("UserEditDialog");
        dialog.show();
    }

    private UserManagementServiceAsync getUserManagementService() {
        return this.userService.getUserManagementService();
    }

    private UserManagementWriteServiceAsync getUserManagementWriteService() {
        return this.userService.getUserManagementWriteService();
    }

    static /* synthetic */ FlushableCellTable access$0(UserTableWrapper userTableWrapper) {
        return userTableWrapper.table;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$1(UserTableWrapper userTableWrapper) {
        return userTableWrapper.filterField;
    }

    static /* synthetic */ ErrorReporter access$2(UserTableWrapper userTableWrapper) {
        return userTableWrapper.errorReporter;
    }

    static /* synthetic */ void access$3(UserTableWrapper userTableWrapper, Iterable iterable) {
        userTableWrapper.getFilteredUsers(iterable);
    }

    static /* synthetic */ UserManagementWriteServiceAsync access$4(UserTableWrapper userTableWrapper) {
        return userTableWrapper.getUserManagementWriteService();
    }

    static /* synthetic */ StringMessages access$5(UserTableWrapper userTableWrapper) {
        return userTableWrapper.getStringMessages();
    }

    static /* synthetic */ UserService access$6(UserTableWrapper userTableWrapper) {
        return userTableWrapper.userService;
    }
}

