/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.controls.listedit.GenericStringListInlineEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.RoleDefinitionDTO;
import com.sap.sse.security.ui.client.component.AbstractRoleDefinitionDialog;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.List;
import java.util.UUID;

public abstract class AbstractRoleDefinitionDialog
extends DataEntryDialog<RoleDefinitionDTO> {
    protected final TextBox roleDefinitionNameField;
    protected final GenericStringListInlineEditorComposite<WildcardPermission> permissionsList;
    private final StringMessages stringMessages;

    public AbstractRoleDefinitionDialog(StringMessages stringMessages, Iterable<WildcardPermission> allExistingPermissions, Iterable<RoleDefinitionDTO> allOtherRoles, DataEntryDialog.DialogCallback<RoleDefinitionDTO> callback) {
        super(stringMessages.roles(), stringMessages.editRoles(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new RoleValidator(stringMessages, allOtherRoles), true, callback);
        this.stringMessages = stringMessages;
        this.roleDefinitionNameField = this.createTextBox("", 20);
        this.roleDefinitionNameField.ensureDebugId("name");
        this.permissionsList = new /* Unavailable Anonymous Inner Class!! */;
        this.permissionsList.addValueChangeHandler(e -> this.validateAndUpdate());
        this.permissionsList.ensureDebugId("permissions");
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(3, 2);
        result.setWidget(0, 0, (Widget)new Label(this.stringMessages.name()));
        result.setWidget(0, 1, (Widget)this.roleDefinitionNameField);
        result.setWidget(1, 0, (Widget)new Label(this.stringMessages.permissions()));
        result.setWidget(1, 1, (Widget)this.permissionsList);
        return result;
    }

    protected RoleDefinitionDTO getResult() {
        String newName = this.roleDefinitionNameField.getText();
        List permissions = this.permissionsList.getValue();
        return new RoleDefinitionDTO(this.getRoleDefinitionId(), newName, (Iterable)permissions);
    }

    protected abstract UUID getRoleDefinitionId();
}

