/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.media.TakedownNoticeRequestContext;
import com.sap.sse.gwt.client.ServerInfoDTO;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorage;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorageEvent;
import com.sap.sse.gwt.client.xdstorage.DelegatingCrossDomainStorageFuture;
import com.sap.sse.security.shared.AbstractOwnership;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.SecurityAccessControlList;
import com.sap.sse.security.shared.SecurityUser;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.oauth.client.util.ClientUtils;
import com.sap.sse.security.ui.shared.EssentialSecuredDTO;
import com.sap.sse.security.ui.shared.SuccessInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class UserService
implements TakedownNoticeService {
    private static final Logger logger = Logger.getLogger(UserService.class.getName());
    private static final StringMessages stringMessages = (StringMessages)GWT.create(StringMessages.class);
    private static final String LOCAL_STORAGE_UPDATE_KEY = "current-user-has-changed";
    protected static final String STORAGE_KEY_FOR_USER_LOGIN_HINT = "sse.ui.lastLoginOrSuppression";
    protected static final Duration SUPRESSION_DELAY = Duration.ONE_WEEK;
    private final UserManagementServiceAsync userManagementService;
    private final UserManagementWriteServiceAsync userManagementWriteService;
    private final Set<UserStatusEventHandler> handlers;
    private boolean userInitiallyLoaded = false;
    private boolean preAuthenticated = false;
    private UserDTO currentUser;
    private final String id = UUID.randomUUID().toString();
    private UserDTO anonymousUser;
    private ServerInfoDTO serverInfo;
    private final Set<HasPermissions> allKnownHasPermissions;
    private final DelegatingCrossDomainStorageFuture crossDomainStorage;

    public UserService(UserManagementServiceAsync userManagementService, UserManagementWriteServiceAsync userManagementWriteService) {
        this.userManagementService = userManagementService;
        this.userManagementWriteService = userManagementWriteService;
        this.handlers = new HashSet();
        this.allKnownHasPermissions = new HashSet();
        this.crossDomainStorage = new DelegatingCrossDomainStorageFuture();
        this.initializeCrossDomainStorage();
        Util.addAll((Iterable)SecuredSecurityTypes.getAllInstances(), (Collection)this.allKnownHasPermissions);
        userManagementService.getAllHasPermissions((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.registerStorageEventHandler();
        this.updateUser(false);
    }

    private void initializeCrossDomainStorage() {
        assert (this.userManagementService != null);
        assert (this.crossDomainStorage != null);
        this.userManagementService.getSharingConfiguration((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public CrossDomainStorage getStorage() {
        return this.crossDomainStorage;
    }

    private void registerStorageEventHandler() {
        this.getStorage().addStorageEventHandler((CrossDomainStorageEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void fireUserUpdateEvent() {
        this.getStorage().setItem(LOCAL_STORAGE_UPDATE_KEY, "", e -> this.getStorage().setItem(LOCAL_STORAGE_UPDATE_KEY, this.id, null));
    }

    public void updateUser(boolean notifyOtherInstances) {
        this.userManagementService.getCurrentUser((AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void login(String username, String password, AsyncCallback<SuccessInfo> callback) {
        this.userManagementService.login(username, password, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void verifySocialUser(AsyncCallback<UserDTO> callback) throws Exception {
        String authProviderName = ClientUtils.getAuthProviderNameFromCookie();
        logger.info("Verifying " + authProviderName + " user ...");
        this.userManagementService.verifySocialUser(ClientUtils.getCredential(), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void logout() {
        this.userManagementService.logout((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public UserDTO getCurrentUser() {
        return this.currentUser;
    }

    private void setCurrentUser(Util.Triple<UserDTO, UserDTO, ServerInfoDTO> resultAndAnomynous, boolean notifyOtherInstances) {
        if (resultAndAnomynous.getA() == null) {
            this.currentUser = null;
        } else {
            this.setUserLoginHintToStorage();
            this.currentUser = (UserDTO)resultAndAnomynous.getA();
        }
        this.anonymousUser = (UserDTO)resultAndAnomynous.getB();
        this.serverInfo = (ServerInfoDTO)resultAndAnomynous.getC();
        this.preAuthenticated = !this.userInitiallyLoaded && this.currentUser != null;
        this.userInitiallyLoaded = true;
        logger.info("User changed to " + (this.currentUser == null ? "No User" : String.valueOf(this.currentUser.getName()) + " roles: " + this.currentUser.getRoles()));
        logger.info("User anonymous changed to " + (this.anonymousUser == null ? "No User" : String.valueOf(this.anonymousUser.getName()) + " roles: " + this.anonymousUser.getRoles()));
        this.notifyUserStatusEventHandlers(this.preAuthenticated);
        if (notifyOtherInstances) {
            this.fireUserUpdateEvent();
        }
    }

    public void addUserStatusEventHandler(UserStatusEventHandler handler) {
        this.addUserStatusEventHandler(handler, false);
    }

    public void addUserStatusEventHandler(UserStatusEventHandler handler, boolean fireIfUserIsAlreadyAvailable) {
        this.handlers.add(handler);
        if (this.userInitiallyLoaded && fireIfUserIsAlreadyAvailable) {
            handler.onUserStatusChange(this.currentUser, this.preAuthenticated);
        }
    }

    public void executeWithServerInfo(Consumer<ServerInfoDTO> consumer) {
        this.addUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */, true);
    }

    public void removeUserStatusEventHandler(UserStatusEventHandler handler) {
        this.handlers.remove(handler);
    }

    private void notifyUserStatusEventHandlers(boolean preAuthenticated) {
        for (UserStatusEventHandler handler : new HashSet(this.handlers)) {
            handler.onUserStatusChange(this.getCurrentUser(), preAuthenticated);
        }
    }

    public UserManagementServiceAsync getUserManagementService() {
        return this.userManagementService;
    }

    public UserManagementWriteServiceAsync getUserManagementWriteService() {
        return this.userManagementWriteService;
    }

    public void getPreference(String key, AsyncCallback<String> callback) {
        String username = this.getCurrentUser().getName();
        this.getUserManagementService().getPreference(username, key, callback);
    }

    public void getPreferences(List<String> keys, AsyncCallback<Map<String, String>> callback) {
        String username = this.getCurrentUser().getName();
        this.getUserManagementService().getPreferences(username, keys, callback);
    }

    public void getAllPreferences(AsyncCallback<Map<String, String>> callback) {
        String username = this.getCurrentUser().getName();
        this.getUserManagementService().getAllPreferences(username, callback);
    }

    public void setPreference(String key, String serializedSettings, AsyncCallback<Void> callback) {
        String username = this.getCurrentUser().getName();
        this.userManagementWriteService.setPreference(username, key, serializedSettings, callback);
    }

    public void setPreferences(Map<String, String> keyValuePairs, AsyncCallback<Void> callback) {
        String username = this.getCurrentUser().getName();
        this.userManagementWriteService.setPreferences(username, keyValuePairs, callback);
    }

    public void unsetPreference(String key) {
        String username = this.getCurrentUser().getName();
        this.userManagementWriteService.unsetPreference(username, key, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void runIfUserWasNotRecentlyLoggedInOrDismissedTheHint(Runnable runnable) {
        this.parseLastNewUserSupression(lastLoginOrSuppression -> {
            if (lastLoginOrSuppression == null || !lastLoginOrSuppression.plus(SUPRESSION_DELAY).before(MillisecondsTimePoint.now())) {
                runnable.run();
            }
        });
    }

    private void parseLastNewUserSupression(Consumer<TimePoint> callback) {
        this.getStorage().getItem(STORAGE_KEY_FOR_USER_LOGIN_HINT, stringValue -> {
            try {
                if (stringValue != null) {
                    callback.accept((TimePoint)new MillisecondsTimePoint(Long.parseLong(stringValue)));
                } else {
                    callback.accept(null);
                }
            }
            catch (Exception e) {
                logger.warning("Error parsing localstore value '" + stringValue + "'");
                this.getStorage().removeItem(STORAGE_KEY_FOR_USER_LOGIN_HINT, v -> callback.accept(null));
            }
        });
    }

    public void setUserLoginHintToStorage() {
        this.getStorage().setItem(STORAGE_KEY_FOR_USER_LOGIN_HINT, String.valueOf(MillisecondsTimePoint.now().asMillis()), null);
    }

    public boolean hasPermission(SecuredDTO securedDTO, HasPermissions.Action action) {
        boolean result = securedDTO == null ? false : PermissionChecker.isPermitted((WildcardPermission)securedDTO.getIdentifier().getPermission(action), (SecurityUser)this.currentUser, (SecurityUser)this.anonymousUser, (AbstractOwnership)securedDTO.getOwnership(), (SecurityAccessControlList)securedDTO.getAccessControlList());
        return result;
    }

    public void createEssentialSecuredDTOByIdAndType(HasPermissions permissionType, String name, TypeRelativeObjectIdentifier typeRelativeObjectIdentifier, AsyncCallback<SecuredDTO> callback) {
        EssentialSecuredDTO secureDTO = new EssentialSecuredDTO(permissionType, name, typeRelativeObjectIdentifier);
        this.userManagementService.addSecurityInformation((SecuredDTO)secureDTO, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean hasServerPermission(HasPermissions.Action action) {
        return this.hasPermission((SecuredDTO)this.serverInfo, action);
    }

    public boolean hasAnyServerPermission(HasPermissions.Action ... actions) {
        boolean hasAnyPermission = false;
        HasPermissions.Action[] actionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            HasPermissions.Action action = actionArray[n2];
            if (this.hasCurrentUserAnyPermission(this.serverInfo.getIdentifier().getPermission(action), this.serverInfo.getOwnership())) {
                hasAnyPermission = true;
                break;
            }
            ++n2;
        }
        return hasAnyPermission;
    }

    public boolean hasPermission(WildcardPermission permission, OwnershipDTO ownership) {
        return this.hasPermission(permission, ownership, null);
    }

    public boolean hasPermission(WildcardPermission permission, OwnershipDTO ownership, AccessControlListDTO acl) {
        if (this.anonymousUser == null) {
            return false;
        }
        return PermissionChecker.isPermitted((WildcardPermission)permission, (SecurityUser)this.currentUser, (SecurityUser)this.anonymousUser, (AbstractOwnership)ownership, (SecurityAccessControlList)acl);
    }

    public boolean hasCreatePermission(HasPermissions logicalSecuredObjectType) {
        if (this.currentUser == null) {
            return false;
        }
        return this.hasPermission(logicalSecuredObjectType.getPermission(new HasPermissions.Action[]{HasPermissions.DefaultActions.CREATE}), new OwnershipDTO(this.currentUser == null ? null : this.currentUser.asStrippedUser(), this.getCurrentTenant()));
    }

    public StrippedUserGroupDTO getCurrentTenant() {
        return this.currentUser == null ? null : this.currentUser.getDefaultTenant();
    }

    public String getCurrentTenantName() {
        StrippedUserGroupDTO defaultTenant = this.getCurrentTenant();
        return defaultTenant == null ? null : defaultTenant.getName();
    }

    public UserDTO getAnonymousUser() {
        return this.anonymousUser;
    }

    public boolean hasCurrentUserAnyPermission(WildcardPermission permissionToCheck, OwnershipDTO ownership) {
        return PermissionChecker.hasUserAnyPermission((WildcardPermission)permissionToCheck, (Iterable)this.allKnownHasPermissions, (SecurityUser)this.getCurrentUser(), (SecurityUser)this.anonymousUser, (AbstractOwnership)ownership);
    }

    public Iterable<HasPermissions> getAllKnownPermissions() {
        return this.allKnownHasPermissions;
    }

    public boolean hasCurrentUserPermissionToCreateObjectOfTypeWithoutServerCreateObjectPermissionCheck(HasPermissions type) {
        WildcardPermission createPermission = type.getPermission(new HasPermissions.Action[]{HasPermissions.DefaultActions.CREATE});
        OwnershipDTO ownershipOfNewlyCreatedObject = new OwnershipDTO(this.currentUser == null ? null : this.currentUser.asStrippedUser(), this.getCurrentTenant());
        return this.hasCurrentUserAnyPermission(createPermission, ownershipOfNewlyCreatedObject);
    }

    public boolean hasCurrentUserPermissionToCreateObjectOfType(HasPermissions type) {
        return this.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CREATE_OBJECT) && this.hasCurrentUserPermissionToCreateObjectOfTypeWithoutServerCreateObjectPermissionCheck(type);
    }

    public boolean hasCurrentUserPermissionToDeleteAnyObjectOfType(HasPermissions type) {
        WildcardPermission createPermission = type.getPermission(new HasPermissions.Action[]{HasPermissions.DefaultActions.DELETE});
        return this.hasCurrentUserAnyPermission(createPermission, null);
    }

    public boolean hasCurrentUserPermissionToUpdateAnyObjectOfType(HasPermissions type) {
        WildcardPermission createPermission = type.getPermission(new HasPermissions.Action[]{HasPermissions.DefaultActions.UPDATE});
        return this.hasCurrentUserAnyPermission(createPermission, null);
    }

    public ServerInfoDTO getServerInfo() {
        return this.serverInfo;
    }

    public void fileTakedownNotice(TakedownNoticeRequestContext takedownNoticeRequestContext) {
        this.userManagementWriteService.fileTakedownNotice(takedownNoticeRequestContext, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isEmailAddressOfCurrentUserValidated() {
        return this.getCurrentUser() != null && this.getCurrentUser().isEmailValidated();
    }

    public String getCurrentUserName() {
        return this.getCurrentUser() == null ? null : this.getCurrentUser().getName();
    }

    static /* synthetic */ Set access$0(UserService userService) {
        return userService.allKnownHasPermissions;
    }

    static /* synthetic */ DelegatingCrossDomainStorageFuture access$1(UserService userService) {
        return userService.crossDomainStorage;
    }

    static /* synthetic */ Logger access$2() {
        return logger;
    }

    static /* synthetic */ String access$3(UserService userService) {
        return userService.id;
    }

    static /* synthetic */ void access$4(UserService userService, Util.Triple triple, boolean bl) {
        userService.setCurrentUser(triple, bl);
    }

    static /* synthetic */ StringMessages access$5() {
        return stringMessages;
    }

    static /* synthetic */ void access$6(UserService userService, UserDTO userDTO) {
        userService.currentUser = userDTO;
    }

    static /* synthetic */ void access$7(UserService userService, boolean bl) {
        userService.preAuthenticated = bl;
    }

    static /* synthetic */ void access$8(UserService userService, boolean bl) {
        userService.notifyUserStatusEventHandlers(bl);
    }
}

