/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.authentication.create;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.GWTLocaleUtil;
import com.sap.sse.gwt.common.CommonSharedResources;
import com.sap.sse.security.ui.authentication.UserManagementResources;
import com.sap.sse.security.ui.authentication.create.CreateAccountView;
import com.sap.sse.security.ui.authentication.create.CreateAccountViewImpl;
import com.sap.sse.security.ui.client.i18n.StringMessages;

public class CreateAccountViewImpl
extends Composite
implements CreateAccountView {
    private static CreateAccountViewImplUiBinder uiBinder = (CreateAccountViewImplUiBinder)GWT.create(CreateAccountViewImplUiBinder.class);
    @UiField
    TextBox emailUi;
    @UiField
    TextBox usernameUi;
    @UiField
    TextBox nameUi;
    @UiField(provided=true)
    public ValueListBox<String> localeListBox = new ValueListBox((Renderer)new /* Unavailable Anonymous Inner Class!! */);
    @UiField
    TextBox companyUi;
    @UiField
    PasswordTextBox passwordUi;
    @UiField
    PasswordTextBox passwordConfirmationUi;
    @UiField
    Button createAccountUi;
    @UiField
    Button signInUi;
    @UiField
    DivElement formErrorUi;
    @UiField(provided=true)
    final CommonSharedResources res;
    private CreateAccountView.Presenter presenter;

    public CreateAccountViewImpl(CommonSharedResources resources) {
        this.res = resources;
        UserManagementResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        StringMessages i18n = StringMessages.INSTANCE;
        this.setPlaceholder((Widget)this.passwordUi, i18n.newPasswordPlaceholder());
        this.setPlaceholder((Widget)this.passwordConfirmationUi, i18n.passwordRepeatPlaceholder());
        this.emailUi.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.usernameUi.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.nameUi.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.localeListBox.setAcceptableValues(GWTLocaleUtil.getAvailableLocalesAndDefault());
        this.localeListBox.addValueChangeHandler(event -> this.presenter.onChangeLocale((String)this.localeListBox.getValue()));
        this.companyUi.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.passwordUi.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.passwordConfirmationUi.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public HasEnabled getCreateAccountControl() {
        return this.createAccountUi;
    }

    public void setPresenter(CreateAccountView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void setErrorMessage(String errorMessage) {
        this.formErrorUi.setInnerText(errorMessage);
    }

    protected void onLoad() {
        this.localeListBox.setValue((Object)LocaleInfo.getCurrentLocale().getLocaleName(), true);
        this.selectAll(this.emailUi);
    }

    @UiHandler(value={"createAccountUi"})
    void onCreateAccountUiControlClicked(ClickEvent event) {
        this.presenter.createAccount();
    }

    @UiHandler(value={"signInUi"})
    void onSignInControlUiClicked(ClickEvent event) {
        this.presenter.signIn();
    }

    private void setPlaceholder(Widget widget, String placeholderText) {
        widget.getElement().setAttribute("placeholder", placeholderText);
    }

    private void selectAll(TextBox textBox) {
        textBox.setFocus(true);
        textBox.selectAll();
    }

    static /* synthetic */ CreateAccountView.Presenter access$0(CreateAccountViewImpl createAccountViewImpl) {
        return createAccountViewImpl.presenter;
    }
}

