/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.components;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.shared.components.CollapsablePanelHeader;
import com.sap.sse.gwt.client.shared.components.ComponentResources;
import java.util.Iterator;

public final class CollapsablePanel
extends Composite
implements HasWidgets.ForIsWidget,
HasAnimation,
HasOpenHandlers<CollapsablePanel>,
HasCloseHandlers<CollapsablePanel> {
    private static ComponentResources resources = (ComponentResources)GWT.create(ComponentResources.class);
    private static final int ANIMATION_DURATION = 350;
    private static final String STYLENAME_DEFAULT = "collapsablePanel";
    private static final String STYLENAME_SUFFIX_OPEN = "open";
    private static final String STYLENAME_SUFFIX_CLOSED = "closed";
    private static final String STYLENAME_HEADER = "collapsablePanel-header";
    private static final String STYLENAME_CONTENT = "collapsablePanel-content";
    private static ContentAnimation contentAnimation;
    private final VerticalPanel mainPanel = new VerticalPanel();
    private final SimplePanel contentWrapper = new SimplePanel();
    private final SimplePanel headerWrapper = new SimplePanel();
    private CollapsablePanelHeader headerPanel;
    private boolean isAnimationEnabled = false;
    private boolean isOpen = false;
    private boolean isCollapsingEnabled = true;

    private CollapsablePanel() {
        this.initWidget((Widget)this.mainPanel);
        this.mainPanel.add((Widget)this.headerWrapper);
        this.mainPanel.add((Widget)this.contentWrapper);
        this.contentWrapper.getElement().getStyle().setPadding(0.0, Style.Unit.PX);
        this.contentWrapper.getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.setStyleName(STYLENAME_DEFAULT);
        this.setContentDisplay(false);
    }

    public CollapsablePanel(ImageResource openImage, ImageResource closedImage, String headerText, boolean hasToolbar) {
        this();
        this.headerPanel = new CollapsablePanelHeader(this, openImage, closedImage, headerText, hasToolbar);
        this.setHeader((Widget)this.headerPanel);
    }

    public CollapsablePanel(String headerText, boolean hasToolbar) {
        this(resources.openIcon(), resources.closeIcon(), headerText, hasToolbar);
    }

    public void setHeaderToolbar(Widget toolbar) {
        this.headerPanel.setToolbar(toolbar);
    }

    public void add(Widget w) {
        if (this.getContent() != null) {
            throw new IllegalStateException("A CollapsablePanel can only contain two Widgets.");
        }
        this.setContent(w);
    }

    public void add(IsWidget w) {
        this.add(CollapsablePanel.asWidgetOrNull((IsWidget)w));
    }

    public HandlerRegistration addCloseHandler(CloseHandler<CollapsablePanel> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    public HandlerRegistration addOpenHandler(OpenHandler<CollapsablePanel> handler) {
        return this.addHandler((EventHandler)handler, OpenEvent.getType());
    }

    public void clear() {
        this.setContent(null);
    }

    public Widget getContent() {
        return this.contentWrapper.getWidget();
    }

    public Widget getHeader() {
        return this.headerWrapper.getWidget();
    }

    public HasText getHeaderTextAccessor() {
        Widget widget = this.headerWrapper.getWidget();
        return widget instanceof HasText ? (HasText)widget : null;
    }

    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isCollapsingEnabled() {
        return this.isCollapsingEnabled;
    }

    public void setCollapsingEnabled(boolean enable) {
        this.isCollapsingEnabled = enable;
        this.headerPanel.setCollapsingEnabled(enable);
    }

    public Iterator<Widget> iterator() {
        return null;
    }

    public boolean remove(Widget w) {
        if (w == this.getContent()) {
            this.setContent(null);
            return true;
        }
        return false;
    }

    public boolean remove(IsWidget w) {
        return this.remove(CollapsablePanel.asWidgetOrNull((IsWidget)w));
    }

    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void setHeader(Widget headerContent) {
        Widget currentHeaderContent = this.getHeader();
        if (currentHeaderContent != null) {
            this.headerWrapper.setWidget(null);
            currentHeaderContent.removeStyleName(STYLENAME_HEADER);
        }
        if (headerContent != null) {
            this.headerWrapper.setWidget(headerContent);
            headerContent.addStyleName(STYLENAME_HEADER);
        }
    }

    public void setContent(Widget content) {
        Widget currentContent = this.getContent();
        if (currentContent != null) {
            this.contentWrapper.setWidget(null);
            currentContent.removeStyleName(STYLENAME_CONTENT);
        }
        if (content != null) {
            this.contentWrapper.setWidget(content);
            content.addStyleName(STYLENAME_CONTENT);
            this.setContentDisplay(false);
        }
    }

    public void setOpen(boolean isOpen) {
        if (this.isOpen != isOpen) {
            this.isOpen = isOpen;
            this.setContentDisplay(true);
            this.fireEvent();
        }
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.headerWrapper.ensureDebugId(String.valueOf(baseID) + "-header");
    }

    private void fireEvent() {
        if (this.isOpen) {
            OpenEvent.fire((HasOpenHandlers)this, (Object)((Object)this));
        } else {
            CloseEvent.fire((HasCloseHandlers)this, (Object)((Object)this));
        }
    }

    private void setContentDisplay(boolean animate) {
        if (this.isOpen) {
            this.removeStyleDependentName(STYLENAME_SUFFIX_CLOSED);
            this.addStyleDependentName(STYLENAME_SUFFIX_OPEN);
        } else {
            this.removeStyleDependentName(STYLENAME_SUFFIX_OPEN);
            this.addStyleDependentName(STYLENAME_SUFFIX_CLOSED);
        }
        if (this.getContent() != null) {
            if (contentAnimation == null) {
                contentAnimation = new ContentAnimation();
            }
            contentAnimation.setOpen(this, animate && this.isAnimationEnabled);
        }
    }

    private static class ContentAnimation
    extends Animation {
        private boolean opening;
        private CollapsablePanel curPanel;

        private ContentAnimation() {
        }

        public void setOpen(CollapsablePanel panel, boolean animate) {
            this.cancel();
            if (animate) {
                this.curPanel = panel;
                this.opening = panel.isOpen;
                this.run(350);
            } else {
                panel.contentWrapper.setVisible(panel.isOpen);
                if (panel.isOpen) {
                    panel.getContent().setVisible(true);
                }
            }
        }

        protected void onComplete() {
            if (!this.opening) {
                this.curPanel.contentWrapper.setVisible(false);
            }
            this.curPanel.contentWrapper.setHeight("auto");
            this.curPanel = null;
        }

        protected void onStart() {
            super.onStart();
            if (this.opening) {
                this.curPanel.contentWrapper.setVisible(true);
                this.curPanel.getContent().setVisible(true);
            }
        }

        protected void onUpdate(double progress) {
            int scrollHeight = this.curPanel.contentWrapper.getElement().getPropertyInt("scrollHeight");
            int height = (int)(progress * (double)scrollHeight);
            if (!this.opening) {
                height = scrollHeight - height;
            }
            height = Math.max(height, 1);
            this.curPanel.contentWrapper.getElement().getStyle().setHeight((double)height, Style.Unit.PX);
            this.curPanel.contentWrapper.setWidth("auto");
        }
    }

    public static interface Imager {
        public Image makeImage();

        public void updateImage(boolean var1, Image var2);
    }
}

