/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.slider;

import com.sap.sse.gwt.client.controls.slider.TimeUnits;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimeTicksCalculator {
    public NormalizedInterval normalizeTimeTickInterval(long tickInterval) {
        TimeUnits[] units = TimeUnits.values();
        TimeUnits unit = units[units.length - 1];
        long interval = unit.unitInMs;
        int[] multiples = unit.allowedMultiples;
        int i = 0;
        while (i < units.length) {
            double lessThan;
            unit = units[i];
            interval = unit.unitInMs;
            multiples = unit.allowedMultiples;
            if (i + 1 < units.length && (double)tickInterval <= (lessThan = (double)((interval * (long)multiples[multiples.length - 1] + units[i + 1].unitInMs) / 2L))) break;
            ++i;
        }
        if (interval == TimeUnits.YEAR.unitInMs && tickInterval < 5L * interval) {
            multiples = new int[]{1, 2, 5};
        }
        double temp = (double)tickInterval / (double)interval;
        int count = (int)this.normalizeTickInterval(temp, multiples, 1);
        return new NormalizedInterval(unit.name(), interval, count);
    }

    public long normalizeTickInterval(double interval, int[] multiples, int magnitude) {
        double normalized = interval / (double)magnitude;
        int i = 0;
        while (i < multiples.length) {
            int addedValue;
            interval = multiples[i];
            int n = addedValue = i + 1 < multiples.length ? multiples[i + 1] : multiples[i];
            if (normalized <= (double)((multiples[i] + addedValue) / 2)) break;
            ++i;
        }
        return Math.round(interval *= (double)magnitude);
    }

    private long makeTime(int year, int month) {
        return this.makeTime(year, month, 1, 0, 0, 0);
    }

    private long makeTime(int year, int month, int date) {
        return this.makeTime(year, month, date, 0, 0, 0);
    }

    private long makeTime(int year, int month, int date, int hours, int minutes, int seconds) {
        return new Date(year, month, date, hours, minutes, seconds).getTime();
    }

    public List<TickPosition> calculateTimeTicks(NormalizedInterval normalizedInterval, long min, long max, long startOfWeek) {
        ArrayList<TickPosition> tickPositions = new ArrayList<TickPosition>();
        boolean useUTC = true;
        int minYear = 0;
        Date minDate = new Date(min);
        long interval = normalizedInterval.unitRange;
        int count = normalizedInterval.count;
        if (interval >= TimeUnits.SECOND.unitInMs) {
            minDate.setTime(min - min % 1000L);
            minDate.setSeconds(interval >= TimeUnits.MINUTE.unitInMs ? 0 : count * Math.round(minDate.getSeconds() / count));
        }
        if (interval >= TimeUnits.MINUTE.unitInMs) {
            minDate.setMinutes(interval >= TimeUnits.HOUR.unitInMs ? 0 : count * Math.round(minDate.getMinutes() / count));
        }
        if (interval >= TimeUnits.HOUR.unitInMs) {
            minDate.setHours(interval >= TimeUnits.DAY.unitInMs ? 0 : count * Math.round(minDate.getHours() / count));
        }
        if (interval >= TimeUnits.DAY.unitInMs) {
            minDate.setDate(interval >= TimeUnits.MONTH.unitInMs ? 1 : count * Math.round(minDate.getDate() / count));
        }
        if (interval >= TimeUnits.MONTH.unitInMs) {
            minDate.setMonth(interval >= TimeUnits.YEAR.unitInMs ? 0 : count * Math.round(minDate.getMonth() + 1 / count) - 1);
            minYear = minDate.getYear() + 1900;
        }
        if (interval >= TimeUnits.YEAR.unitInMs) {
            minYear -= minYear % count;
            minDate.setYear(minYear - 1900);
        }
        if (interval == TimeUnits.WEEK.unitInMs) {
            long value = (long)(minDate.getDate() - minDate.getDay()) + startOfWeek;
            minDate.setDate((int)value);
        }
        int i = 1;
        minDate = new Date(minDate.getTime() - (long)minDate.getTimezoneOffset() * TimeUnits.MINUTE.unitInMs);
        minYear = minDate.getYear() + 1900;
        int minMonth = minDate.getMonth() + 1;
        int minDateDate = minDate.getDate();
        long time = minDate.getTime();
        while (time > min) {
            time -= interval * (long)count;
        }
        while (time < max) {
            if (time >= min) {
                tickPositions.add(new TickPosition(time));
            }
            time = interval == TimeUnits.YEAR.unitInMs ? this.makeTime(minYear + i * count, 0) : (interval == TimeUnits.MONTH.unitInMs ? this.makeTime(minYear, minMonth + i * count) : (!(useUTC || interval != TimeUnits.DAY.unitInMs && interval != TimeUnits.WEEK.unitInMs) ? this.makeTime(minYear, minMonth, minDateDate + i * count * (interval == TimeUnits.DAY.unitInMs ? 1 : 7)) : (time += interval * (long)count)));
            ++i;
        }
        if (time <= max) {
            tickPositions.add(new TickPosition(time));
        }
        return tickPositions;
    }

    public class NormalizedInterval {
        public String unitName;
        public long unitRange;
        public int count;

        public NormalizedInterval(String unitName, long unitRange, int count) {
            this.unitName = unitName;
            this.unitRange = unitRange;
            this.count = count;
        }

        public String toString() {
            return "NormalizedInterval [unitName=" + this.unitName + ", unitRange=" + this.unitRange + ", count=" + this.count + "]";
        }
    }

    public class TickPosition {
        private Date position;

        public TickPosition(long time) {
            this.position = new Date(time);
        }

        public Date getPosition() {
            return this.position;
        }
    }
}

