/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.listedit;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.controls.listedit.CollapsedListEditorUi;
import com.sap.sse.gwt.client.controls.listedit.ExpandedListEditorUi;
import com.sap.sse.gwt.client.controls.listedit.ListEditorComposite;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUiStrategy;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class GenericStringListEditorComposite<ValueType>
extends ListEditorComposite<ValueType> {
    protected GenericStringListEditorComposite(Iterable<ValueType> initialValues, StringMessages stringMessages, ImageResource removeImage, Iterable<String> suggestValues) {
        super(initialValues, new ExpandedUi(stringMessages, removeImage, suggestValues));
    }

    protected GenericStringListEditorComposite(Iterable<ValueType> initialValues, StringMessages stringMessages, ImageResource removeImage, Iterable<String> suggestValues, String placeholderTextForAddTextbox) {
        super(initialValues, new ExpandedUi(stringMessages, removeImage, suggestValues, placeholderTextForAddTextbox));
    }

    protected GenericStringListEditorComposite(Iterable<ValueType> initialValues, ListEditorUiStrategy<ValueType> activeUi) {
        super(initialValues, activeUi);
    }

    protected abstract ValueType parse(String var1);

    protected abstract ValueType parse(String var1, ValueType var2);

    protected abstract String toString(ValueType var1);

    public static abstract class CollapsedUi<ValueType>
    extends CollapsedListEditorUi<ValueType> {
        public CollapsedUi(StringMessages stringMessages, String dialogTitle, ExpandedListEditorUi<ValueType> expandedUi) {
            super(stringMessages, dialogTitle, expandedUi);
        }

        @Override
        protected String getCollapsedValueText(Iterable<ValueType> value) {
            return String.join((CharSequence)",", Util.map(value, v -> v.toString()));
        }
    }

    public static class ExpandedUi<ValueType>
    extends ExpandedListEditorUi<ValueType> {
        protected final MultiWordSuggestOracle inputOracle;
        protected final String placeholderTextForAddTextbox;
        protected final Integer inputBoxSize;
        protected Button addButton;
        protected SuggestBox suggestBox;

        public ExpandedUi(StringMessages stringMessages, ImageResource removeImage, Iterable<String> suggestValues) {
            this(stringMessages, removeImage, suggestValues, null);
        }

        public ExpandedUi(StringMessages stringMessages, ImageResource removeImage, Iterable<String> suggestValues, String placeholderTextForAddTextbox) {
            this(stringMessages, removeImage, suggestValues, placeholderTextForAddTextbox, null);
        }

        public void setEnabled(boolean enabled) {
            if (!enabled) {
                this.addButton.setEnabled(false);
            }
            this.suggestBox.setEnabled(enabled);
        }

        public ExpandedUi(StringMessages stringMessages, ImageResource removeImage, Iterable<String> suggestValues, String placeholderTextForAddTextbox, Integer inputBoxSize) {
            super(stringMessages, removeImage, true);
            this.placeholderTextForAddTextbox = placeholderTextForAddTextbox;
            this.inputOracle = new MultiWordSuggestOracle();
            for (String suggestValue : suggestValues) {
                this.inputOracle.add(suggestValue);
            }
            ArrayList defaultSuggestions = new ArrayList();
            Util.addAll(suggestValues, defaultSuggestions);
            this.inputOracle.setDefaultSuggestionsFromText(defaultSuggestions);
            this.inputBoxSize = inputBoxSize;
        }

        protected GenericStringListEditorComposite<ValueType> getContext() {
            return (GenericStringListEditorComposite)this.context;
        }

        @Override
        public void setContext(ListEditorComposite<ValueType> context) {
            super.setContext(context);
            Iterator iterator = context.getValue().iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                this.inputOracle.add(this.getContext().toString(value));
            }
        }

        protected SuggestBox createSuggestBox() {
            this.suggestBox = new SuggestBox((SuggestOracle)this.inputOracle);
            if (this.placeholderTextForAddTextbox != null) {
                this.suggestBox.getElement().setAttribute("placeholder", this.placeholderTextForAddTextbox);
            }
            return this.suggestBox;
        }

        @Override
        protected Widget createAddWidget() {
            this.createAndWireAddButtonAndSuggestBox();
            HorizontalPanel panel = new HorizontalPanel();
            panel.add((Widget)this.suggestBox);
            panel.add((Widget)this.addButton);
            return panel;
        }

        protected void createAndWireAddButtonAndSuggestBox() {
            final SuggestBox inputBox = this.createSuggestBox();
            inputBox.ensureDebugId("InputSuggestBox");
            if (this.inputBoxSize != null) {
                inputBox.setWidth(String.valueOf(Integer.toString(this.inputBoxSize)) + Style.Unit.EM);
            }
            this.addButton = new Button(this.getStringMessages().add());
            this.addButton.ensureDebugId("AddButton");
            this.addButton.setEnabled(false);
            this.addButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    this.addValue(this.createNewValue());
                    inputBox.setText("");
                    inputBox.setFocus(true);
                }
            });
            inputBox.addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    this.enableAddButtonBasedOnInputBoxText(inputBox);
                }
            });
            inputBox.addKeyPressHandler(new KeyPressHandler(){

                public void onKeyPress(KeyPressEvent event) {
                    if (event.getUnicodeCharCode() == 13) {
                        addButton.click();
                    }
                }
            });
            inputBox.addValueChangeHandler(vch -> this.enableAddButtonBasedOnInputBoxText(inputBox));
            inputBox.addSelectionHandler((SelectionHandler)new SelectionHandler<SuggestOracle.Suggestion>(){

                public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                    this.enableAddButtonBasedOnInputBoxText(inputBox);
                }
            });
        }

        protected ValueType createNewValue() {
            return this.getContext().parse(this.suggestBox.getValue());
        }

        @Override
        protected Widget createValueWidget(int rowIndex, ValueType newValue) {
            return new Label(this.getContext().toString(newValue));
        }

        protected void enableAddButtonBasedOnInputBoxText(SuggestBox inputBox) {
            this.addButton.setEnabled(this.isToEnableAddButtonBasedOnValueOfInputBoxText(inputBox));
        }

        protected boolean isToEnableAddButtonBasedOnValueOfInputBoxText(SuggestBox inputBox) {
            return !inputBox.getValue().isEmpty();
        }
    }
}

