/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.NotificationPanel;
import com.sap.sse.gwt.client.formfactor.DeviceDetector;
import java.util.LinkedList;
import java.util.List;

public class Notification {
    private static final int MAX_NOTIFICATIONS = 5;
    private static final Panel notifications = new FlowPanel();
    private static final List<NotificationPanel> QUEUE = new LinkedList<NotificationPanel>();
    static final NotificationResources ress = (NotificationResources)GWT.create(NotificationResources.class);

    static {
        ress.css().ensureInjected();
        RootPanel.get().add((Widget)notifications);
        notifications.getElement().setId("notificationBar");
        if (DeviceDetector.isDesktop()) {
            notifications.addStyleName(ress.css().notification_bar());
        } else {
            notifications.addStyleName(ress.css().notification_bar_mobile());
        }
    }

    private Notification() {
    }

    public static void notify(String message, NotificationType type) {
        NotificationPanel notification = new NotificationPanel(message, type, notifications);
        if (!QUEUE.contains(notification)) {
            QUEUE.add(notification);
        }
        Notification.checkQueue(notification);
    }

    protected static void checkQueue(NotificationPanel notification) {
        if (notification.alreadyShown()) {
            QUEUE.remove(notification);
        }
        long currentlyShown = QUEUE.stream().filter(value -> value.alreadyShown()).count();
        for (NotificationPanel notificationInQueue : QUEUE) {
            if (notificationInQueue.alreadyShown() || currentlyShown >= 5L) continue;
            notificationInQueue.show();
            ++currentlyShown;
        }
    }

    static interface NotificationCSS
    extends CssResource {
        public String notification_bar();

        public String notification_bar_mobile();

        public String notification();
    }

    static interface NotificationResources
    extends ClientBundle {
        @ClientBundle.Source(value={"notification.css"})
        public NotificationCSS css();
    }

    public static enum NotificationType {
        ERROR("\u2716", "RED", "WHITE"),
        WARNING("\u26a0", "ORANGE", "WHITE"),
        INFO("\u2139", "#008fcc", "WHITE"),
        SUCCESS("\u2713", "#00cc00", "WHITE");

        private String decorator;
        private String bgColor;
        private String color;

        private NotificationType(String decorator, String bgColor, String color) {
            this.decorator = decorator;
            this.bgColor = bgColor;
            this.color = color;
        }

        public String getDecorator() {
            return this.decorator;
        }

        public String getColor() {
            return this.color;
        }

        public String getBackgroundColor() {
            return this.bgColor;
        }
    }
}

