/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sse.common.Base64Utils;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;

public class SshKeyDisplayAndDownloadDialog
extends DataEntryDialog<Void> {
    private final TextArea publicKeyTextArea;
    private final TextArea encryptedPrivateKeyTextArea;
    private final Anchor publicKeyDownloadLink;
    private final Anchor encryptedPrivateKeyDownloadLink;
    private final StringMessages stringMessages;

    public SshKeyDisplayAndDownloadDialog(String keyName, byte[] publicKey, byte[] encryptedPrivateKey, StringMessages stringMessages) {
        super(stringMessages.sshKeys(), stringMessages.sshKeys(), stringMessages.close(), null, null, null);
        this.stringMessages = stringMessages;
        this.publicKeyTextArea = new TextArea();
        this.publicKeyTextArea.setSize("40em", "6em");
        this.publicKeyTextArea.setText(new String(publicKey));
        this.encryptedPrivateKeyTextArea = new TextArea();
        this.encryptedPrivateKeyTextArea.setSize("40em", "6em");
        this.encryptedPrivateKeyTextArea.setText(new String(encryptedPrivateKey));
        this.publicKeyDownloadLink = new Anchor(stringMessages.download());
        this.publicKeyDownloadLink.getElement().setAttribute("download", String.valueOf(keyName) + ".pub");
        this.publicKeyDownloadLink.setHref("data:application/octet-stream;charset=utf-8;base64," + Base64Utils.toBase64((byte[])publicKey));
        this.encryptedPrivateKeyDownloadLink = new Anchor(stringMessages.download());
        this.encryptedPrivateKeyDownloadLink.getElement().setAttribute("download", keyName);
        this.encryptedPrivateKeyDownloadLink.setHref("data:application/octet-stream;charset=utf-8;base64," + Base64Utils.toBase64((byte[])encryptedPrivateKey));
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(4, 2);
        int row = 0;
        result.setWidget(row++, 0, (Widget)new Label(this.stringMessages.publicKey()));
        result.setWidget(row, 0, (Widget)this.publicKeyTextArea);
        result.setWidget(row++, 1, (Widget)this.publicKeyDownloadLink);
        result.setWidget(row++, 0, (Widget)new Label(this.stringMessages.encryptedPrivateKey()));
        result.setWidget(row, 0, (Widget)this.encryptedPrivateKeyTextArea);
        result.setWidget(row++, 1, (Widget)this.encryptedPrivateKeyDownloadLink);
        return result;
    }

    protected Void getResult() {
        return null;
    }
}

