/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.domain.tracking.impl.CourseDesignUpdateHandler;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sse.common.Util;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.map.IMapItem;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;

public class TracTracCourseDesignUpdateHandler
extends CourseDesignUpdateHandler {
    private final IRace tractracRace;
    private final DomainFactory domainFactory;

    public TracTracCourseDesignUpdateHandler(URI updateURI, String tracTracApiToken, Serializable tracTracEventId, Serializable raceId, IRace tractracRace, DomainFactory domainFactory) {
        super(updateURI, tracTracApiToken, tracTracEventId, raceId);
        this.domainFactory = domainFactory;
        this.tractracRace = tractracRace;
    }

    protected CourseBase replaceControlPointsByMatchingExistingControlPoints(CourseBase courseDesign) {
        Iterable<IMapItem> candidates = this.domainFactory.getControlsForCourseArea(this.tractracRace.getEvent(), this.tractracRace.getCourseArea());
        CourseDataImpl result = new CourseDataImpl(courseDesign.getName());
        int zeroBasedPosition = 0;
        boolean changed = false;
        for (Waypoint waypoint : courseDesign.getWaypoints()) {
            if (Util.size((Iterable)waypoint.getMarks()) > 1) {
                Mark second;
                Iterator markIter = waypoint.getMarks().iterator();
                Mark first = (Mark)markIter.next();
                ControlPoint existingControlPoint = this.domainFactory.getExistingControlWithTwoMarks(candidates, first, second = (Mark)markIter.next());
                if (existingControlPoint == null) {
                    result.addWaypoint(zeroBasedPosition++, waypoint);
                    continue;
                }
                result.addWaypoint(zeroBasedPosition++, this.domainFactory.getBaseDomainFactory().createWaypoint(existingControlPoint, waypoint.getPassingInstructions()));
                changed = true;
                continue;
            }
            result.addWaypoint(zeroBasedPosition++, waypoint);
        }
        return changed ? result : courseDesign;
    }
}

