/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.impl.AbstractReceiverWithQueue;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.tractrac.model.lib.api.data.IControlPassing;
import com.tractrac.model.lib.api.data.IControlPassings;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.model.lib.api.map.IMapItem;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.control.IControlPassingsListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class MarkPassingReceiver
extends AbstractReceiverWithQueue<IRaceCompetitor, IControlPassings, Void> {
    private static final Logger logger = Logger.getLogger(MarkPassingReceiver.class.getName());
    private final IControlPassingsListener listener = new IControlPassingsListener(){

        public void gotControlPassings(long timestamp, IRaceCompetitor raceCompetitor, IControlPassings controlPassings) {
            MarkPassingReceiver.this.enqueue(new Util.Triple((Object)raceCompetitor, (Object)controlPassings, null));
        }
    };

    public MarkPassingReceiver(DynamicTrackedRegatta trackedRegatta, IEvent tractracEvent, Simulator simulator, DomainFactory domainFactory, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, long timeoutInMilliseconds) {
        super(domainFactory, tractracEvent, trackedRegatta, simulator, eventSubscriber, raceSubscriber, timeoutInMilliseconds);
    }

    @Override
    public void subscribe() {
        this.getRaceSubscriber().subscribeControlPassings(this.listener);
        this.startThread();
    }

    @Override
    protected void unsubscribe() {
        this.getRaceSubscriber().unsubscribeControlPassings(this.listener);
    }

    @Override
    protected void handleEvent(Util.Triple<IRaceCompetitor, IControlPassings, Void> event) {
        if (!((IRaceCompetitor)event.getA()).getCompetitor().isNonCompeting()) {
            System.out.print("L");
            DynamicTrackedRace trackedRace = this.getTrackedRace(((IRaceCompetitor)event.getA()).getRace());
            if (trackedRace != null) {
                Course course = trackedRace.getRace().getCourse();
                Iterator<Waypoint> waypointsIter = course.getWaypoints().iterator();
                HashMap<Waypoint, MarkPassing> passingsByWaypoint = new HashMap<Waypoint, MarkPassing>();
                for (IControlPassing passing : ((IControlPassings)event.getB()).getPassings()) {
                    IMapItem controlPointPassed = passing.getControl();
                    ControlPoint domainControlPoint = this.getDomainFactory().getOrCreateControlPoint(controlPointPassed);
                    Waypoint passed = this.findWaypointForControlPoint((TrackedRace)trackedRace, waypointsIter, domainControlPoint);
                    if (passed != null) {
                        MillisecondsTimePoint time = new MillisecondsTimePoint(passing.getTimestamp());
                        Competitor competitor = this.getDomainFactory().resolveCompetitor(((IRaceCompetitor)event.getA()).getCompetitor());
                        MarkPassing markPassing = this.getDomainFactory().createMarkPassing((TimePoint)time, passed, competitor);
                        passingsByWaypoint.put(passed, markPassing);
                        continue;
                    }
                    logger.warning("Didn't find waypoint in course " + course + " for mark passing around " + passing.getControl());
                }
                ArrayList<MarkPassing> markPassings = new ArrayList<MarkPassing>();
                for (Waypoint waypoint : course.getWaypoints()) {
                    MarkPassing passing = (MarkPassing)passingsByWaypoint.get(waypoint);
                    if (passing == null) continue;
                    markPassings.add(passing);
                }
                logger.fine("Received mark passings in race " + trackedRace.getRace().getName() + ": " + markPassings);
                Competitor competitor = this.getDomainFactory().resolveCompetitor(((IRaceCompetitor)event.getA()).getCompetitor());
                if (competitor != null) {
                    if (this.getSimulator() != null) {
                        this.getSimulator().delayMarkPassings(competitor, markPassings);
                    } else {
                        trackedRace.updateMarkPassings(competitor, markPassings);
                    }
                } else {
                    logger.warning("Didn't find competitor for mark passings");
                }
            } else {
                logger.warning("Couldn't find tracked race for race " + ((IRaceCompetitor)event.getA()).getRace().getName() + ". Dropping mark passing event " + event);
            }
        }
    }

    private Waypoint findWaypointForControlPoint(TrackedRace trackedRace, Iterator<Waypoint> waypointsIter, ControlPoint domainControlPoint) {
        while (waypointsIter.hasNext()) {
            Waypoint waypoint = waypointsIter.next();
            if (waypoint.getControlPoint() != domainControlPoint) continue;
            return waypoint;
        }
        return null;
    }
}

