/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.tractracadapter.LoadingQueueDoneCallBack;
import com.sap.sailing.domain.tractracadapter.Receiver;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractLoadingQueueDoneCallBack
implements LoadingQueueDoneCallBack {
    private final Set<Receiver> receiversToCallback;

    public AbstractLoadingQueueDoneCallBack(Collection<Receiver> receivers) {
        this.receiversToCallback = new HashSet<Receiver>(receivers);
        for (Receiver receiver : receivers) {
            receiver.callBackWhenLoadingQueueIsDone(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadingQueueDone(Receiver receiver) {
        Set<Receiver> set = this.receiversToCallback;
        synchronized (set) {
            this.receiversToCallback.remove(receiver);
            if (this.receiversToCallback.isEmpty()) {
                this.executeWhenAllReceiversAreDoneLoading();
            }
        }
    }

    protected abstract void executeWhenAllReceiversAreDoneLoading();
}

