/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.windimport.routeconverter;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sailing.server.gateway.windimport.AbstractWindImporter;
import com.sap.sailing.server.trackfiles.RouteConverterGPSFixImporterFactory;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import slash.common.io.NotClosingUnderlyingInputStream;

public class RouteconverterWindImporter
extends AbstractWindImporter {
    private static final Logger logger = Logger.getLogger(RouteconverterWindImporter.class.getName());

    @Override
    protected WindSource getDefaultWindSource(AbstractWindImporter.UploadRequest uploadRequest) {
        logger.info("Importing Routeconverter wind data from " + uploadRequest.files);
        String sourceName = uploadRequest.files != null && !uploadRequest.files.isEmpty() ? uploadRequest.files.toString() : "Routeconverter Wind Import";
        WindSourceWithAdditionalID windSource = new WindSourceWithAdditionalID(WindSourceType.WEB, String.valueOf(sourceName) + "@" + MillisecondsTimePoint.now());
        return windSource;
    }

    @Override
    protected Map<WindSource, Iterable<Wind>> importWind(WindSource defaultWindSource, Map<InputStream, Util.Pair<String, Charset>> inputStreamsAndFilenamesAndCharsets) throws Exception {
        HashMap<WindSource, Iterable<Wind>> result = new HashMap<WindSource, Iterable<Wind>>();
        if (inputStreamsAndFilenamesAndCharsets != null) {
            for (Map.Entry<InputStream, Util.Pair<String, Charset>> inputStreamAndFileName : inputStreamsAndFilenamesAndCharsets.entrySet()) {
                logger.info("Reading Routeconverter wind data from " + inputStreamAndFileName.getValue());
                Map<WindSource, ? extends Iterable<Wind>> windFixesFromStream = this.readWind((String)inputStreamAndFileName.getValue().getA(), inputStreamAndFileName.getKey(), (Charset)inputStreamAndFileName.getValue().getB());
                result.putAll(windFixesFromStream);
            }
        }
        return result;
    }

    private Map<WindSource, ? extends Iterable<Wind>> readWind(String filename, InputStream inputStream, Charset charset) throws Exception {
        try {
            final HashMap result = new HashMap();
            GPSFixImporter importer = RouteConverterGPSFixImporterFactory.INSTANCE.createRouteConverterGPSFixImporter();
            GPSFixImporter.Callback callback = new GPSFixImporter.Callback(){

                public void addFix(GPSFix fix, TrackFileImportDeviceIdentifier device) {
                    if (fix instanceof GPSFixMoving) {
                        WindImpl wind = new WindImpl(fix.getPosition(), fix.getTimePoint(), ((GPSFixMoving)fix).getSpeed());
                        WindSource windSource = WindSource.fromTypeAndId((String)device.getTrackName());
                        if (windSource.getType().canBeStored()) {
                            result.computeIfAbsent(windSource, ws -> new ArrayList()).add(wind);
                        }
                    }
                }
            };
            if (filename.toLowerCase().endsWith("zip")) {
                ZipEntry entry;
                logger.info("Routeconverter file " + filename + " is a ZIP file");
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    String entryName = entry.getName();
                    int extensionStart = entryName.lastIndexOf(46);
                    if (extensionStart != -1 && !Util.contains((Iterable)importer.getSupportedFileExtensions(), (Object)entryName.substring(extensionStart + 1))) continue;
                    logger.info("Reading Routeconverter wind data from " + filename + "'s ZIP entry " + entry.getName());
                    importer.importFixes((InputStream)new NotClosingUnderlyingInputStream((InputStream)zipInputStream), charset, callback, false, entry.getName());
                }
            } else {
                importer.importFixes(inputStream, charset, callback, false, filename);
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "An exception occurred while trying to close the input stream from which we're reading wind", e);
            }
        }
    }
}

