/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.subscription.chargebee;

import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.subscription.SubscriptionPermissionsAuthorizationFilter;
import com.sap.sailing.server.gateway.subscription.chargebee.SubscriptionWebHookEvent;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ChargebeeSubscriptionPermissionsAuthorizationFilter
extends SubscriptionPermissionsAuthorizationFilter {
    private static final Logger logger = Logger.getLogger(ChargebeeSubscriptionPermissionsAuthorizationFilter.class.getName());

    @Override
    protected String getSubscriptionUserName(ServletRequest request) {
        try {
            Object requestBody = JSONValue.parseWithException((Reader)request.getReader());
            JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
            logger.info(() -> "Received Chargebee webhook: " + requestObject.toJSONString());
            SubscriptionWebHookEvent event = new SubscriptionWebHookEvent(requestObject);
            if (!event.isValidEvent()) {
                throw new IllegalArgumentException("Invalid Chargebee webhook event");
            }
            request.setAttribute("event", (Object)event);
            return event.getCustomerId();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Chargebee subscription webhook permission checking error", e);
            return null;
        }
    }
}

