/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.subscription;

import com.sap.sailing.server.gateway.SailingServerHttpServlet;
import com.sap.sailing.server.gateway.subscription.SubscriptionWebHookHandler;
import com.sap.sailing.server.gateway.subscription.SubscriptionWebHookHandlerFactory;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SubscriptionWebHookServlet
extends SailingServerHttpServlet {
    private static final long serialVersionUID = -6953289975184826299L;
    private static final Logger logger = Logger.getLogger(SubscriptionWebHookServlet.class.getName());

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = this.getRequestHandlerPath(request);
        SubscriptionWebHookHandler handler = SubscriptionWebHookHandlerFactory.getInstance().getHandlerForPath(path, this);
        if (handler != null) {
            handler.handle(request, response);
        } else {
            logger.warning(() -> "Unable to get subscription webhook handler for request /" + path);
        }
    }

    private String getRequestHandlerPath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        String[] pathParts = pathInfo.split("/");
        return pathParts[pathParts.length - 1];
    }
}

